
require 'wx'
include Wx

TreeTest_Quit,
TreeTest_About,
TreeTest_TogButtons,
TreeTest_TogTwist,
TreeTest_TogLines,
TreeTest_TogEdit,
TreeTest_TogHideRoot,
TreeTest_TogRootLines,
TreeTest_TogBorder,
TreeTest_TogFullHighlight,
TreeTest_SetFgColour,
TreeTest_SetBgColour,
TreeTest_ResetStyle,
TreeTest_Dump,
TreeTest_DumpSelected,
TreeTest_Count,
TreeTest_CountRec,
TreeTest_Sort,
TreeTest_SortRev,
TreeTest_SetBold,
TreeTest_ClearBold,
TreeTest_Rename,
TreeTest_Delete,
TreeTest_DeleteChildren,
TreeTest_DeleteAll,
TreeTest_Recreate,
TreeTest_ToggleImages,
TreeTest_ToggleButtons,
TreeTest_SetImageSize,
TreeTest_ToggleSel,
TreeTest_CollapseAndReset,
TreeTest_EnsureVisible,
TreeTest_AddItem,
TreeTest_InsertItem,
TreeTest_IncIndent,
TreeTest_DecIndent,
TreeTest_IncSpacing,
TreeTest_DecSpacing,
TreeTest_ToggleIcon,
TreeTest_Select,
TreeTest_Unselect = (0..41).to_a
TreeTest_Ctrl = 1000

TreeCtrlIcon_File,
TreeCtrlIcon_FileSelected,
TreeCtrlIcon_Folder,
TreeCtrlIcon_FolderSelected,
TreeCtrlIcon_FolderOpened = 0,1,2,3,4

class MyTreeItemData < WxTreeItemData
    def initialize(desc)
        super()
        @m_desc = desc
    end

    def Bool2String(b)
        return b ? "" : "not "
    end

    def ShowInfo(tree)
        WxLogMessage("Item '%s': %sselected, %sexpanded, %sbold,\n" +
                     "%d children (%d immediately under self item).",
                     @m_desc,
                     Bool2String(tree.IsSelected(GetId())),
                     Bool2String(tree.IsExpanded(GetId())),
                     Bool2String(tree.IsBold(GetId())),
                     tree.GetChildrenCount(GetId()),
                     tree.GetChildrenCount(GetId(), FALSE))
    end

    def GetDesc()
        @m_desc
    end

end

class MyTreeCtrl < WxTreeCtrl
    def initialize(parent, id,pos, size,style)
        super(parent, id, pos, size, style)

        @m_reverseSort = FALSE

        CreateImageList()

        # Add some items to the tree
        AddTestItemsToTree(5, 2)

        EVT_TREE_BEGIN_DRAG(self,TreeTest_Ctrl, "OnBeginDrag")
        EVT_TREE_BEGIN_RDRAG(self,TreeTest_Ctrl, "OnBeginRDrag")
        EVT_TREE_END_DRAG(self,TreeTest_Ctrl, "OnEndDrag")
        EVT_TREE_BEGIN_LABEL_EDIT(self,TreeTest_Ctrl, "OnBeginLabelEdit")
        EVT_TREE_END_LABEL_EDIT(self,TreeTest_Ctrl, "OnEndLabelEdit")
        EVT_TREE_DELETE_ITEM(self,TreeTest_Ctrl, "OnDeleteItem")
        EVT_TREE_SET_INFO(self,TreeTest_Ctrl, "OnSetInfo")
        EVT_TREE_ITEM_EXPANDED(self,TreeTest_Ctrl, "OnItemExpanded")
        EVT_TREE_ITEM_EXPANDING(self,TreeTest_Ctrl, "OnItemExpanding")
        EVT_TREE_ITEM_COLLAPSED(self,TreeTest_Ctrl, "OnItemCollapsed")
        EVT_TREE_ITEM_COLLAPSING(self,TreeTest_Ctrl, "OnItemCollapsing")
        EVT_TREE_ITEM_RIGHT_CLICK(self,TreeTest_Ctrl, "OnItemRightClick")

        EVT_RIGHT_UP(self,"OnRMouseUp")
        EVT_TREE_SEL_CHANGED(self,TreeTest_Ctrl, "OnSelChanged")
        EVT_TREE_SEL_CHANGING(self,TreeTest_Ctrl, "OnSelChanging")
        EVT_TREE_KEY_DOWN(self,TreeTest_Ctrl, "OnTreeKeyDown")
        EVT_TREE_ITEM_ACTIVATED(self,TreeTest_Ctrl, "OnItemActivated")
        EVT_RIGHT_DCLICK(self,"OnRMouseDClick")

    end

    def DoSortChildren(item,reverse = FALSE)
         @m_reverseSort = reverse
         SortChildren(item)
    end

    def DoEnsureVisible()
        EnsureVisible(@m_lastItem)
    end

    def ImageSize()
        return @m_imageSize
    end

    def IsTestItem(item)
        # the test item is the first child folder
        return GetItemParent(item) == GetRootItem() && !GetPrevSibling(item)
    end

    def CreateImageList(size = 16)
        if size == -1
            SetImageList(nil)
            return nil
        end
        if size == 0
            size = @m_imageSize
        else
            @m_imageSize = size
        end

        # Make an image list containing small icons
        images = WxImageList.new(size, size, TRUE)

        # should correspond to TreeCtrlIcon_xxx enum
        wait = WxBusyCursor.new
        icons = [
            WxIcon.new("icon1.xpm"),
            WxIcon.new("icon2.xpm"),
            WxIcon.new("icon3.xpm"),
            WxIcon.new("icon4.xpm"),
            WxIcon.new("icon5.xpm")]

        sizeOrig = icons[0].GetWidth()
        for i in 0 ... icons.length
            if size == sizeOrig
                images.Add(icons[i])
            else
                images.Add(icons[i])
            end
        end

        AssignImageList(images)
        wait.free
    end

    def CreateButtonsImageList(size = 11)
        if size == -1
            SetButtonsImageList(nil)
            return nil
        end

        # Make an image list containing small icons
        images = WxImageList.new(size, size, TRUE)

        # should correspond to TreeCtrlIcon_xxx enum
        wait = WxBusyCursor.new
        icons = [
            WxIcon.new("icon3.xpm"),   # closed
            WxIcon.new("icon3.xpm"),   # closed, selected
            WxIcon.new("icon5.xpm"),   # open
            WxIcon.new("icon5.xpm")]   # open, selected

        for i in 0 ... icons.length
            sizeOrig = icons[i].GetWidth()
            if size == sizeOrig
                images.Add(icons[i])
            else
                images.Add(WxBitmap.new(icons[i].ConvertToImage().Rescale(size, size)))
            end
        end

        AssignButtonsImageList(images)
        wait.free
    end

    def OnCompareItems(item1,item2)
        if @m_reverseSort
            # just exchange 1st and 2nd items
            return super(item2, item1)
        else
            return super(item1, item2)
        end
    end

    def AddItemsRecursively(idParent,numChildren,depth,folder)
        if depth > 0
            hasChildren = depth > 1

            for n in 0 ... numChildren
                # at depth 1 elements won't have any more children
                if hasChildren
                    str = sprintf("%s child %d", "Folder", n + 1)
                else
                    str = sprintf("%s child %d.%d", "File", folder, n + 1)
                end
                # here we pass to AppendItem() normal and selected item images (we
                # suppose that selected image follows the normal one in the enum)
                if WxGetApp().ShowImages()
                    image = depth == 1 ? TreeCtrlIcon_File : TreeCtrlIcon_Folder
                    imageSel = image + 1
                else
                    image = imageSel = -1
                end
                id = AppendItem(idParent, str, image, imageSel,MyTreeItemData.new(str))

                # and now we also set the expanded one (only for the folders)
                if hasChildren && WxGetApp().ShowImages()
                    SetItemImage(id, TreeCtrlIcon_FolderOpened,
                                 WxTreeItemIcon_Expanded)
                end

                # remember the last child for OnEnsureVisible()
                if !hasChildren && n == numChildren - 1
                    @m_lastItem = id
                end

                AddItemsRecursively(id, numChildren, depth - 1, n + 1)
            end
        end
    end

    def AddTestItemsToTree(numChildren,depth)
        image = WxGetApp().ShowImages() ? TreeCtrlIcon_Folder : -1
        rootId = AddRoot("Root",image, image,MyTreeItemData.new("Root item"))
        if image != -1
            SetItemImage(rootId, TreeCtrlIcon_FolderOpened, WxTreeItemIcon_Expanded)
        end

        AddItemsRecursively(rootId, numChildren, depth, 0)

        # set some colours/fonts for testing
        SetItemFont(rootId, WxITALIC_FONT)

        id,cookie = GetFirstChild(rootId)
        SetItemTextColour(id, WxBLUE)

        id,cookie = GetNextChild(rootId,cookie)
        id,cookie = GetNextChild(rootId,cookie)
        SetItemTextColour(id, WxRED)
        SetItemBackgroundColour(id, WxLIGHT_GREY)
    end

    def GetItemsRecursively(idParent,cookie)
        if cookie == -1
            id,cookie = GetFirstChild(idParent)
        else
            id,cookie = GetNextChild(idParent,cookie)
        end
        if id <= 0
            return nil
        end

        text = GetItemText(id)
        WxLogMessage(text)

        if ItemHasChildren(id)
            GetItemsRecursively(id,-1)
        end
        GetItemsRecursively(idParent, cookie)
    end

    def DoToggleIcon(item)
        image = GetItemImage(item) == TreeCtrlIcon_Folder ? TreeCtrlIcon_File : TreeCtrlIcon_Folder

        SetItemImage(item, image)
    end

    def OnBeginRDrag(event)
        WxLogMessage("OnBeginRDrag")
        event.Skip()
    end

    def OnDeleteItem(event)
        WxLogMessage("OnDeleteItem")
        event.Skip()
    end

    def OnGetInfo(event)
        WxLogMessage("OnGetInfo")
        event.Skip()
    end

    def OnSetInfo(event)
        WxLogMessage("OnSetInfo")
        event.Skip()
    end

    def OnItemExpanded(event)
        WxLogMessage("OnItemExpanded")
        event.Skip()
    end

    def OnItemExpanding(event)
        WxLogMessage("OnItemExpanding")
        event.Skip()
    end

    def OnItemCollapsed(event)
        WxLogMessage("OnItemCollapsed")
        event.Skip()
    end

    def OnSelChanged(event)
        WxLogMessage("OnSelChanged")
        event.Skip()
    end

    def OnSelChanging(event)
        WxLogMessage("OnSelChanging")
        event.Skip()
    end

    def LogKeyEvent(name,event)
        keycode = event.KeyCode()

        case keycode
            when WXK_BACK
                key = "BACK"
            when WXK_TAB
                key = "TAB"
            when WXK_RETURN
                key = "RETURN"
            when WXK_ESCAPE
                key = "ESCAPE"
            when WXK_SPACE
                key = "SPACE"
            when WXK_DELETE
                key = "DELETE"
            when WXK_START
                key = "START"
            when WXK_LBUTTON
                key = "LBUTTON"
            when WXK_RBUTTON
                key = "RBUTTON"
            when WXK_CANCEL
                key = "CANCEL"
            when WXK_MBUTTON
                key = "MBUTTON"
            when WXK_CLEAR
                key = "CLEAR"
            when WXK_SHIFT
                key = "SHIFT"
            when WXK_ALT
                key = "ALT"
            when WXK_CONTROL
                key = "CONTROL"
            when WXK_MENU
                key = "MENU"
            when WXK_PAUSE
                key = "PAUSE"
            when WXK_CAPITAL
                key = "CAPITAL"
            when WXK_PRIOR
                key = "PRIOR"
            when WXK_NEXT
                key = "NEXT"
            when WXK_END
                key = "END"
            when WXK_HOME
                key = "HOME"
            when WXK_LEFT
                key = "LEFT"
            when WXK_UP
                key = "UP"
            when WXK_RIGHT
                key = "RIGHT"
            when WXK_DOWN
                key = "DOWN"
            when WXK_SELECT
                key = "SELECT"
            when WXK_PRINT
                key = "PRINT"
            when WXK_EXECUTE
                key = "EXECUTE"
            when WXK_SNAPSHOT
                key = "SNAPSHOT"
            when WXK_INSERT
                key = "INSERT"
            when WXK_HELP
                key = "HELP"
            when WXK_NUMPAD0
                key = "NUMPAD0"
            when WXK_NUMPAD1
                key = "NUMPAD1"
            when WXK_NUMPAD2
                key = "NUMPAD2"
            when WXK_NUMPAD3
                key = "NUMPAD3"
            when WXK_NUMPAD4
                key = "NUMPAD4"
            when WXK_NUMPAD5
                key = "NUMPAD5"
            when WXK_NUMPAD6
                key = "NUMPAD6"
            when WXK_NUMPAD7
                key = "NUMPAD7"
            when WXK_NUMPAD8
                key = "NUMPAD8"
            when WXK_NUMPAD9
                key = "NUMPAD9"
            when WXK_MULTIPLY
                key = "MULTIPLY"
            when WXK_ADD
                key = "ADD"
            when WXK_SEPARATOR
                key = "SEPARATOR"
            when WXK_SUBTRACT
                key = "SUBTRACT"
            when WXK_DECIMAL
                key = "DECIMAL"
            when WXK_DIVIDE
                key = "DIVIDE"
            when WXK_F1
                key = "F1"
            when WXK_F2
                key = "F2"
            when WXK_F3
                key = "F3"
            when WXK_F4
                key = "F4"
            when WXK_F5
                key = "F5"
            when WXK_F6
                key = "F6"
            when WXK_F7
                key = "F7"
            when WXK_F8
                key = "F8"
            when WXK_F9
                key = "F9"
            when WXK_F10
                key = "F10"
            when WXK_F11
                key = "F11"
            when WXK_F12
                key = "F12"
            when WXK_F13
                key = "F13"
            when WXK_F14
                key = "F14"
            when WXK_F15
                key = "F15"
            when WXK_F16
                key = "F16"
            when WXK_F17
                key = "F17"
            when WXK_F18
                key = "F18"
            when WXK_F19
                key = "F19"
            when WXK_F20
                key = "F20"
            when WXK_F21
                key = "F21"
            when WXK_F22
                key = "F22"
            when WXK_F23
                key = "F23"
            when WXK_F24
                key = "F24"
            when WXK_NUMLOCK
                key = "NUMLOCK"
            when WXK_SCROLL
                key = "SCROLL"
            when WXK_PAGEUP
                key = "PAGEUP"
            when WXK_PAGEDOWN
                key = "PAGEDOWN"
            when WXK_NUMPAD_SPACE
                key = "NUMPAD_SPACE"
            when WXK_NUMPAD_TAB
                key = "NUMPAD_TAB"
            when WXK_NUMPAD_ENTER
                key = "NUMPAD_ENTER"
            when WXK_NUMPAD_F1
                key = "NUMPAD_F1"
            when WXK_NUMPAD_F2
                key = "NUMPAD_F2"
            when WXK_NUMPAD_F3
                key = "NUMPAD_F3"
            when WXK_NUMPAD_F4
                key = "NUMPAD_F4"
            when WXK_NUMPAD_HOME
                key = "NUMPAD_HOME"
            when WXK_NUMPAD_LEFT
                key = "NUMPAD_LEFT"
            when WXK_NUMPAD_UP
                key = "NUMPAD_UP"
            when WXK_NUMPAD_RIGHT
                key = "NUMPAD_RIGHT"
            when WXK_NUMPAD_DOWN
                key = "NUMPAD_DOWN"
            when WXK_NUMPAD_PRIOR
                key = "NUMPAD_PRIOR"
            when WXK_NUMPAD_PAGEUP
                key = "NUMPAD_PAGEUP"
            when WXK_NUMPAD_PAGEDOWN
                key = "NUMPAD_PAGEDOWN"
            when WXK_NUMPAD_END
                key = "NUMPAD_END"
            when WXK_NUMPAD_BEGIN
                key = "NUMPAD_BEGIN"
            when WXK_NUMPAD_INSERT
                key = "NUMPAD_INSERT"
            when WXK_NUMPAD_DELETE
                key = "NUMPAD_DELETE"
            when WXK_NUMPAD_EQUAL
                key = "NUMPAD_EQUAL"
            when WXK_NUMPAD_MULTIPLY
                key = "NUMPAD_MULTIPLY"
            when WXK_NUMPAD_ADD
                key = "NUMPAD_ADD"
            when WXK_NUMPAD_SEPARATOR
                key = "NUMPAD_SEPARATOR"
            when WXK_NUMPAD_SUBTRACT
                key = "NUMPAD_SUBTRACT"
            when WXK_NUMPAD_DECIMAL
                key = "NUMPAD_DECIMAL"
            else
                   if keycode >= 32 && keycode <127
                       key = sprintf("'%s'", keycode.chr)
                   elsif keycode > 0 && keycode < 27
                       key = sprintf("Ctrl-%c", ?A + keycode - 1)
                   else
                       key = sprintf("unknown (%d)", keycode)
                   end
        end

        WxLogMessage( "%s event: %s (flags = %s%s%s%s)",
                      name,
                      key,
                      event.ControlDown() ? 'C' : '-',
                      event.AltDown() ? 'A' : '-',
                      event.ShiftDown() ? 'S' : '-',
                      event.MetaDown() ? 'M' : '-')
    end

    def OnTreeKeyDown(event)
        LogKeyEvent("Tree key down ", event.GetKeyEvent())

        event.Skip()
    end

    def OnBeginDrag(event)
        # need to explicitly allow drag
        if event.GetItem() != GetRootItem()

            @m_draggedItem = event.GetItem()

            WxLogMessage("OnBeginDrag: started dragging %s",
                         GetItemText(@m_draggedItem))

            event.Allow()
        else
            WxLogMessage("OnBeginDrag: self item can't be dragged.")
        end
    end

    def OnEndDrag(event)

        itemSrc = @m_draggedItem
        itemDst = event.GetItem()
        @m_draggedItem = 0

        # where to copy the item?
        if itemDst.IsOk() && !ItemHasChildren(itemDst)
            # copy to the parent then
            itemDst = GetItemParent(itemDst)
        end

        if !itemDst.IsOk()
            WxLogMessage("OnEndDrag: can't drop here.")

            return nil
        end

        text = GetItemText(itemSrc)
        WxLogMessage("OnEndDrag: '%s' copied to '%s'.",
                     text, GetItemText(itemDst))

        # just do append here - we could also insert it just before/after the item
        # on which it was dropped, but self requires slightly more work... we also
        # completely ignore the client data and icon of the old item but could
        # copy them as well.
        #
        # Finally, we only copy one item here but we might copy the entire tree if
        # we were dragging a folder.
        image = WxGetApp().ShowImages() ? TreeCtrlIcon_File : -1
        AppendItem(itemDst, text, image)
    end

    def OnBeginLabelEdit(event)
        WxLogMessage("OnBeginLabelEdit")

        # for testing, prevent self item's label editing
        itemId = event.GetItem()
        if IsTestItem(itemId)
            WxMessageBox("You can't edit self item.")

            event.Veto()
        end
    end

    def OnEndLabelEdit(event)
        WxLogMessage("OnEndLabelEdit")

        # don't allow anything except letters in the labels
        if event.GetLabel() !~ /[0-9a-zA-Z.]+/
            WxMessageBox("The new label should be a single word.")

            event.Veto()
        end
    end

    def OnItemCollapsing(event)
        WxLogMessage("OnItemCollapsing")

        # for testing, prevent the user from collapsing the first child folder
        itemId = event.GetItem()
        if IsTestItem(itemId)
            WxMessageBox("You can't collapse self item.")

            event.Veto()
        end
    end

    def OnItemActivated(event)
        # show some info about self item
        itemId = event.GetItem()
        item = GetItemData(itemId)

        if item != nil
            item.ShowInfo(self)
        end

        WxLogMessage("OnItemActivated")
    end

    def OnItemRightClick(event)
        ShowMenu(event.GetItem(), event.GetPoint())
    end

    def OnRMouseUp(event)
        pt = event.GetPosition()
        ShowMenu(HitTest(pt), pt)
    end

    def ShowMenu(id,pt)
        title = ""
        if id>=0
            title << "Menu for " << GetItemText(id)
        else
            title = "Menu for no particular item"
        end

        menu = WxMenu.new(title)
        menu.Append(TreeTest_About, "&About...")
        menu.Append(TreeTest_Dump, "&Dump")

        PopupMenu(menu, pt)
    end

    def OnRMouseDClick(event)
        id = HitTest(event.GetPosition())
        if !id
            WxLogMessage("No item under mouse")
        else
            item = GetItemData(id)
            if item
                WxLogMessage("Item '%s' under mouse", item.GetDesc())
            end
        end
    end

end


class MyFrame < WxFrame
    def initialize(title, x, y, w, h)
        super(nil, -1, title, WxPoint.new(x, y), WxSize.new(w, h))
        @m_treeCtrl = nil
        @m_textCtrl = nil
        @s_num = 0

        # This reduces flicker effects - even better would be to define
        # OnEraseBackground to do nothing. When the tree control's scrollbars are
        # show or hidden, the frame is sent a background erase event.
        SetBackgroundColour(WxColour.new(255, 255, 255))

        # Give it an icon
        SetIcon(WxIcon.new("mondrian.xpm"))

        # Make a menubar
        file_menu = WxMenu.new
        style_menu = WxMenu.new
        tree_menu = WxMenu.new
        item_menu = WxMenu.new

        file_menu.Append(TreeTest_About, "&About...")
        file_menu.AppendSeparator()
        file_menu.Append(TreeTest_Quit, "E&xit\tAlt-X")

        style_menu.Append(TreeTest_TogButtons, "Toggle &normal buttons", "", WxITEM_CHECK)
        style_menu.Append(TreeTest_TogTwist, "Toggle &twister buttons", "", WxITEM_CHECK)
        style_menu.Append(TreeTest_ToggleButtons, "Toggle image &buttons", "", WxITEM_CHECK)
        style_menu.AppendSeparator()
        style_menu.Append(TreeTest_TogLines, "Toggle &connecting lines", "", WxITEM_CHECK)
        style_menu.Append(TreeTest_TogRootLines, "Toggle &lines at root", "", WxITEM_CHECK)
        style_menu.Append(TreeTest_TogHideRoot, "Toggle &hidden root", "", WxITEM_CHECK)
        style_menu.Append(TreeTest_TogBorder, "Toggle &item border", "", WxITEM_CHECK)
        style_menu.Append(TreeTest_TogFullHighlight, "Toggle &full row highlight", "", WxITEM_CHECK)
        style_menu.Append(TreeTest_TogEdit, "Toggle &edit mode", "", WxITEM_CHECK)
        style_menu.Append(TreeTest_ToggleSel, "Toggle &selection mode", "", WxITEM_CHECK)
        style_menu.Append(TreeTest_ToggleImages, "Toggle show ima&ges", "", WxITEM_CHECK)
        style_menu.Append(TreeTest_SetImageSize, "Set image si&ze...")
        style_menu.AppendSeparator()
        style_menu.Append(TreeTest_SetFgColour, "Set &foreground colour...")
        style_menu.Append(TreeTest_SetBgColour, "Set &background colour...")
        style_menu.AppendSeparator()
        style_menu.Append(TreeTest_ResetStyle, "&Reset to default\tF10")

        tree_menu.Append(TreeTest_Recreate, "&Recreate the tree")
        tree_menu.Append(TreeTest_CollapseAndReset, "C&ollapse and reset")
        tree_menu.AppendSeparator()
        tree_menu.Append(TreeTest_AddItem, "Append a &new item")
        tree_menu.Append(TreeTest_InsertItem, "&Insert a new item")
        tree_menu.Append(TreeTest_Delete, "&Delete self item")
        tree_menu.Append(TreeTest_DeleteChildren, "Delete &children")
        tree_menu.Append(TreeTest_DeleteAll, "Delete &all items")
        tree_menu.AppendSeparator()
        tree_menu.Append(TreeTest_Count, "Count children of current item")
        tree_menu.Append(TreeTest_CountRec, "Recursively count children of current item")
        tree_menu.AppendSeparator()
        tree_menu.Append(TreeTest_Sort, "Sort children of current item")
        tree_menu.Append(TreeTest_SortRev, "Sort in reversed order")
        tree_menu.AppendSeparator()
        tree_menu.Append(TreeTest_EnsureVisible, "Make the last item &visible")
        tree_menu.AppendSeparator()
        tree_menu.Append(TreeTest_IncIndent, "Add 5 points to indentation\tAlt-I")
        tree_menu.Append(TreeTest_DecIndent, "Reduce indentation by 5 points\tAlt-R")
        tree_menu.AppendSeparator()
        tree_menu.Append(TreeTest_IncSpacing, "Add 5 points to spacing\tCtrl-I")
        tree_menu.Append(TreeTest_DecSpacing, "Reduce spacing by 5 points\tCtrl-R")

        item_menu.Append(TreeTest_Dump, "&Dump item children")
        item_menu.Append(TreeTest_Rename, "&Rename item...")

        item_menu.AppendSeparator()
        item_menu.Append(TreeTest_SetBold, "Make item &bold")
        item_menu.Append(TreeTest_ClearBold, "Make item &not bold")
        item_menu.AppendSeparator()
        item_menu.Append(TreeTest_ToggleIcon, "Toggle the item's &icon")

        item_menu.AppendSeparator()
        item_menu.Append(TreeTest_DumpSelected, "Dump selected items\tAlt-D")
        item_menu.Append(TreeTest_Select, "Select current item\tAlt-S")
        item_menu.Append(TreeTest_Unselect, "Unselect everything\tAlt-U")

        menu_bar = WxMenuBar.new
        menu_bar.Append(file_menu, "&File")
        menu_bar.Append(style_menu, "&Style")
        menu_bar.Append(tree_menu, "&Tree")
        menu_bar.Append(item_menu, "&Item")
        SetMenuBar(menu_bar)


        # create the controls
        @m_textCtrl = WxTextCtrl.new(self, -1, "",
                                    WxDefaultPosition, WxDefaultSize,
                                    WxTE_MULTILINE | WxSUNKEN_BORDER)

        CreateTreeWithDefStyle()

        menu_bar.Check(TreeTest_ToggleImages, TRUE)

        # create a status bar with 3 panes
        CreateStatusBar(3)
        SetStatusText("", 0)

        # set our text control as the log target
        logWindow = WxLogTextCtrl.new(@m_textCtrl)
        WxLog::SetActiveTarget(logWindow)

        EVT_SIZE(self,"OnSize")

        EVT_MENU(self,TreeTest_Quit,"OnQuit")
        EVT_MENU(self,TreeTest_About,"OnAbout")

        EVT_MENU(self,TreeTest_TogButtons,"OnTogButtons")
        EVT_MENU(self,TreeTest_TogTwist,"OnTogTwist")
        EVT_MENU(self,TreeTest_TogLines,"OnTogLines")
        EVT_MENU(self,TreeTest_TogEdit,"OnTogEdit")
        EVT_MENU(self,TreeTest_TogHideRoot,"OnTogHideRoot")
        EVT_MENU(self,TreeTest_TogRootLines,"OnTogRootLines")
        EVT_MENU(self,TreeTest_TogBorder,"OnTogBorder")
        EVT_MENU(self,TreeTest_TogFullHighlight,"OnTogFullHighlight")
        EVT_MENU(self,TreeTest_SetFgColour,"OnSetFgColour")
        EVT_MENU(self,TreeTest_SetBgColour,"OnSetBgColour")
        EVT_MENU(self,TreeTest_ResetStyle,"OnResetStyle")

        EVT_MENU(self,TreeTest_Dump,"OnDump")
        EVT_MENU(self,TreeTest_DumpSelected,"OnDumpSelected")
        EVT_MENU(self,TreeTest_Select,"OnSelect")
        EVT_MENU(self,TreeTest_Unselect,"OnUnselect")
        EVT_MENU(self,TreeTest_ToggleSel,"OnToggleSel")
        EVT_MENU(self,TreeTest_Rename,"OnRename")
        EVT_MENU(self,TreeTest_Count,"OnCount")
        EVT_MENU(self,TreeTest_CountRec,"OnCountRec")
        EVT_MENU(self,TreeTest_Sort,"OnSort")
        EVT_MENU(self,TreeTest_SortRev,"OnSortRev")
        EVT_MENU(self,TreeTest_SetBold,"OnSetBold")
        EVT_MENU(self,TreeTest_ClearBold,"OnClearBold")
        EVT_MENU(self,TreeTest_Delete,"OnDelete")
        EVT_MENU(self,TreeTest_DeleteChildren,"OnDeleteChildren")
        EVT_MENU(self,TreeTest_DeleteAll,"OnDeleteAll")
        EVT_MENU(self,TreeTest_Recreate,"OnRecreate")
        EVT_MENU(self,TreeTest_ToggleImages,"OnToggleImages")
        EVT_MENU(self,TreeTest_ToggleButtons,"OnToggleButtons")
        EVT_MENU(self,TreeTest_SetImageSize,"OnSetImageSize")
        EVT_MENU(self,TreeTest_CollapseAndReset,"OnCollapseAndReset")
        EVT_MENU(self,TreeTest_EnsureVisible,"OnEnsureVisible")
        EVT_MENU(self,TreeTest_AddItem,"OnAddItem")
        EVT_MENU(self,TreeTest_InsertItem,"OnInsertItem")
        EVT_MENU(self,TreeTest_IncIndent,"OnIncIndent")
        EVT_MENU(self,TreeTest_DecIndent,"OnDecIndent")
        EVT_MENU(self,TreeTest_IncSpacing,"OnIncSpacing")
        EVT_MENU(self,TreeTest_DecSpacing,"OnDecSpacing")
        EVT_MENU(self,TreeTest_ToggleIcon,"OnToggleIcon")

        EVT_CLOSE(self,"OnClose");
    end

    def CreateTreeWithDefStyle()

        style = WxTR_DEFAULT_STYLE |
                     WxTR_EDIT_LABELS

        CreateTree(style | WxSUNKEN_BORDER)

        # as we don't know what WxTR_DEFAULT_STYLE could contain, test for
        # everything
        mbar = GetMenuBar()
        mbar.Check(TreeTest_TogButtons, (style & WxTR_HAS_BUTTONS) != 0)
        mbar.Check(TreeTest_TogButtons, (style & WxTR_TWIST_BUTTONS) != 0)
        mbar.Check(TreeTest_TogLines, (style & WxTR_NO_LINES) == 0)
        mbar.Check(TreeTest_TogRootLines, (style & WxTR_LINES_AT_ROOT) != 0)
        mbar.Check(TreeTest_TogHideRoot, (style & WxTR_HIDE_ROOT) != 0)
        mbar.Check(TreeTest_TogEdit, (style & WxTR_EDIT_LABELS) != 0)
        mbar.Check(TreeTest_TogBorder, (style & WxTR_ROW_LINES) != 0)
        mbar.Check(TreeTest_TogFullHighlight, (style & WxTR_FULL_ROW_HIGHLIGHT) != 0)
    end

    def CreateTree(style)

        @m_treeCtrl = MyTreeCtrl.new(self, TreeTest_Ctrl,
                                    WxDefaultPosition, WxDefaultSize,
                                    style)
        Resize()
    end

    def TogStyle(id,flag)

        style = @m_treeCtrl.GetWindowStyle() ^ flag

        # most treectrl styles can't be changed on the fly using the native
        # control and the tree must be recreated
        if WxRUBY_PLATFORM != "WXMSW"
            @m_treeCtrl.SetWindowStyle(style)
        else
            @m_treeCtrl.free
            CreateTree(style)
        end

        GetMenuBar().Check(id, (style & flag) != 0)
    end

    def OnTogButtons(event)
         TogStyle(event.GetId(), WxTR_HAS_BUTTONS)
    end

    def OnTogTwist(event)
         TogStyle(event.GetId(), WxTR_TWIST_BUTTONS)
    end

    def OnTogLines(event)
         TogStyle(event.GetId(), WxTR_NO_LINES)
    end

    def OnTogEdit(event)
         TogStyle(event.GetId(), WxTR_EDIT_LABELS)
    end

    def OnTogHideRoot(event)
         TogStyle(event.GetId(), WxTR_HIDE_ROOT)
    end

    def OnTogRootLines(event)
         TogStyle(event.GetId(), WxTR_LINES_AT_ROOT)
    end

    def OnTogBorder(event)
         TogStyle(event.GetId(), WxTR_ROW_LINES)
    end

    def OnTogFullHighlight(event)
         TogStyle(event.GetId(), WxTR_FULL_ROW_HIGHLIGHT)
    end

    def OnResetStyle(event)
         CreateTreeWithDefStyle()
    end

    def OnSetBold(event)
        DoSetBold(TRUE)
    end

    def OnClearBold(event)
        DoSetBold(FALSE)
    end

    def OnSort(event)
        DoSort()
    end

    def OnSortRev(event)
        DoSort(TRUE)
    end

    def OnSize(event)
        if @m_treeCtrl && @m_textCtrl
            Resize()
        end

        event.Skip()
    end

    def Resize()
        size = GetClientSize()
        @m_treeCtrl.SetSize(0, 0, size.x, 2*size.y/3)
        @m_textCtrl.SetSize(0, 2*size.y/3, size.x, size.y/3)
    end

    def OnClose(event)
        WxLog::SetActiveTarget(nil)
        Destroy()
    end

    def OnQuit(event)
        Close(TRUE)
    end

    def OnAbout(event)
        WxMessageBox("Tree test sample\n" +
                     "(c) Julian Smart 1997, Vadim Zeitlin 1998",
                     "About tree test",
                     WxOK | WxICON_INFORMATION, self)
    end

    def CHECK_ITEM(item)
        if item<0
            WxMessageBox("Please select some item first!",
                      "Tree sample error",
                      WxOK | WxICON_EXCLAMATION,
                      self)
        end
        item >= 0
    end

    def OnRename(event)
        item = @m_treeCtrl.GetSelection()

        return nil unless CHECK_ITEM( item )

        # TODO demonstrate creating a custom edit control...
        @m_treeCtrl.EditLabel(item)
    end

    def OnCount(event)
        item = @m_treeCtrl.GetSelection()

        return nil unless CHECK_ITEM( item )

        i = @m_treeCtrl.GetChildrenCount( item, FALSE )

        WxLogMessage("%d children", i)
    end

    def OnCountRec(event)
        item = @m_treeCtrl.GetSelection()

        return nil unless CHECK_ITEM( item )

        i = @m_treeCtrl.GetChildrenCount( item )

        WxLogMessage("%d children", i)
    end

    def DoSort(reverse = FALSE)
        item = @m_treeCtrl.GetSelection()

        return nil unless CHECK_ITEM( item )

        @m_treeCtrl.DoSortChildren(item, reverse)
    end

    def OnDump(event)
        root = @m_treeCtrl.GetSelection()

        return nil unless CHECK_ITEM( root )

        @m_treeCtrl.GetItemsRecursively(root, -1)
    end

    def OnToggleSel(event)
        TogStyle(event.GetId(), WxTR_MULTIPLE)
    end

    def OnDumpSelected(event)
        array = @m_treeCtrl.GetSelections()
        count = array.length
        WxLogMessage("%u items selected", count)

        for n in 0 ... count
            WxLogMessage("\t%s", @m_treeCtrl.GetItemText(array[n]))
        end
    end

    def OnSelect(event)
        @m_treeCtrl.SelectItem(@m_treeCtrl.GetSelection())
    end

    def OnUnselect(event)
        @m_treeCtrl.UnselectAll()
    end


    def DoSetBold(bold = TRUE)
        item = @m_treeCtrl.GetSelection()

        return nil unless CHECK_ITEM( item )

        @m_treeCtrl.SetItemBold(item, bold)
    end

    def OnDelete(event)
        item = @m_treeCtrl.GetSelection()

        return nil unless CHECK_ITEM( item )

        @m_treeCtrl.Delete(item)
    end

    def OnDeleteChildren(event)
        item = @m_treeCtrl.GetSelection()

        return nil unless CHECK_ITEM( item )

        @m_treeCtrl.DeleteChildren(item)
    end

    def OnDeleteAll(event)
        @m_treeCtrl.DeleteAllItems()
    end

    def OnRecreate(event)
        OnDeleteAll(event)
        @m_treeCtrl.AddTestItemsToTree(5, 2)
    end

    def OnSetImageSize(event)
        size = WxGetNumberFromUser("Enter the size for the images to use",
                                        "Size: ",
                                        "TreeCtrl sample",
                                        @m_treeCtrl.ImageSize())
        if size == -1
            return nil
        end

        @m_treeCtrl.CreateImageList(size)
        WxGetApp().SetShowImages(TRUE)
    end

    def OnToggleImages(event)
        if WxGetApp().ShowImages()
            @m_treeCtrl.CreateImageList(-1)
            WxGetApp().SetShowImages(FALSE)
        else
            @m_treeCtrl.CreateImageList(0)
            WxGetApp().SetShowImages(TRUE)
        end
    end

    def OnToggleButtons(event)
    end

    def OnCollapseAndReset(event)
        @m_treeCtrl.CollapseAndReset(@m_treeCtrl.GetRootItem())
    end

    def OnEnsureVisible(event)
        @m_treeCtrl.DoEnsureVisible()
    end

    def OnInsertItem(event)
        image = WxGetApp().ShowImages() ? TreeCtrlIcon_File : -1
        @m_treeCtrl.InsertItem(@m_treeCtrl.GetRootItem(), image, "2nd item")
    end

    def OnAddItem(event)
        @s_num += 1
        text = sprintf("Item #%d", @s_num)

        @m_treeCtrl.AppendItem(@m_treeCtrl.GetRootItem(),
                               text)
    end

    def OnIncIndent(event)
        indent = @m_treeCtrl.GetIndent()
        if indent < 100
            @m_treeCtrl.SetIndent( indent+5 )
        end
    end

    def OnDecIndent(event)
        indent = @m_treeCtrl.GetIndent()
        if indent > 10
            @m_treeCtrl.SetIndent( indent-5 )
        end
    end

    def OnIncSpacing(event)
        indent = @m_treeCtrl.GetSpacing()
        if indent < 100
            @m_treeCtrl.SetSpacing( indent+5 )
        end
    end

    def OnDecSpacing(event)
        indent = @m_treeCtrl.GetSpacing()
        if indent > 10
            @m_treeCtrl.SetSpacing( indent-5 )
        end
    end

    def OnToggleIcon(event)
        item = @m_treeCtrl.GetSelection()

        return nil unless CHECK_ITEM( item )

        @m_treeCtrl.DoToggleIcon(item)
    end

    def OnSetFgColour(event)
        col = WxGetColourFromUser(self, @m_treeCtrl.GetForegroundColour())
        if col.Ok()
            @m_treeCtrl.SetForegroundColour(col)
        end
    end

    def OnSetBgColour(event)
        col = WxGetColourFromUser(self, @m_treeCtrl.GetBackgroundColour())
        if col.Ok()
            @m_treeCtrl.SetBackgroundColour(col)
        end
    end

end

class MyApp < WxApp
    def initialize
        @m_showImages = TRUE
        @m_showButtons = FALSE
        super
    end
    
    def OnInit
        # Create the main frame window
        frame = MyFrame.new("WxTreeCtrl Test", 50, 50, 450, 600)

        # Show the frame
        frame.Show(TRUE)
        SetTopWindow(frame)

    end

    def SetShowImages(show)
        @m_showImages = show
    end

    def ShowImages()
        @m_showImages
    end

    def SetShowButtons(show)
        @m_showButtons = show
    end

    def ShowButtons()
        @m_showButtons
    end
    
end


a = MyApp.new
a.MainLoop()

