
require 'wx'
include Wx

ID_TOOLBAR = 500

TOOLBAR_STYLE = WxTB_FLAT | WxTB_DOCKABLE | WxTB_TEXT


IDM_TOOLBAR_TOGGLETOOLBARSIZE = 200
IDM_TOOLBAR_TOGGLETOOLBARORIENT = 201
IDM_TOOLBAR_TOGGLETOOLBARROWS = 202
IDM_TOOLBAR_ENABLEPRINT = 203
IDM_TOOLBAR_DELETEPRINT = 204
IDM_TOOLBAR_INSERTPRINT = 205
IDM_TOOLBAR_TOGGLEHELP = 206
IDM_TOOLBAR_TOGGLE_TOOLBAR = 207
IDM_TOOLBAR_TOGGLE_ANOTHER_TOOLBAR = 208
IDM_TOOLBAR_CHANGE_TOOLTIP = 209
IDM_TOOLBAR_SHOW_TEXT = 210
IDM_TOOLBAR_SHOW_ICONS = 211
IDM_TOOLBAR_SHOW_BOTH = 212

ID_COMBO = 1000


class MyFrame < WxFrame
    def initialize(parent,id = -1,title = "WxToolBar Sample",pos = WxDefaultPosition,
                size = WxDefaultSize,style = WxDEFAULT_FRAME_STYLE)
        super(parent, id, title, pos, size, style)

        @m_tbar = nil
        @m_textWindow = WxTextCtrl.new(self, -1, "", WxPoint.new(0, 0), WxSize.new(-1, -1), WxTE_MULTILINE)

        @m_smallToolbar = TRUE
        @m_horzToolbar = TRUE
        @m_rows = 1
        @m_nPrint = 1

        # Give it a status line
        CreateStatusBar()

        # Give it an icon
        SetIcon(WxIcon.new("mondrian.xpm"))

        # Make a menubar
        tbarMenu = WxMenu.new
        tbarMenu.AppendCheckItem(IDM_TOOLBAR_TOGGLE_TOOLBAR,
                                  "Toggle &toolbar\tCtrl-Z",
                                  "Show or hide the toolbar")

        tbarMenu.AppendCheckItem(IDM_TOOLBAR_TOGGLE_ANOTHER_TOOLBAR,
                                  "Toggle &another toolbar\tCtrl-A",
                                  "Show/hide another test toolbar")

        tbarMenu.AppendCheckItem(IDM_TOOLBAR_TOGGLETOOLBARSIZE,
                                  "&Toggle toolbar size\tCtrl-S",
                                  "Toggle between big/small toolbar")

        tbarMenu.AppendCheckItem(IDM_TOOLBAR_TOGGLETOOLBARORIENT,
                                  "Toggle toolbar &orientation\tCtrl-O",
                                  "Toggle toolbar orientation")

        tbarMenu.AppendCheckItem(IDM_TOOLBAR_TOGGLETOOLBARROWS,
                                  "Toggle number of &rows\tCtrl-R",
                                  "Toggle number of toolbar rows between 1 and 2")

        tbarMenu.AppendSeparator()

        tbarMenu.Append(IDM_TOOLBAR_ENABLEPRINT, "&Enable print button\tCtrl-E", "")
        tbarMenu.Append(IDM_TOOLBAR_DELETEPRINT, "&Delete print button\tCtrl-D", "")
        tbarMenu.Append(IDM_TOOLBAR_INSERTPRINT, "&Insert print button\tCtrl-I", "")
        tbarMenu.Append(IDM_TOOLBAR_TOGGLEHELP, "Toggle &help button\tCtrl-T", "")
        tbarMenu.AppendSeparator()
        tbarMenu.Append(IDM_TOOLBAR_CHANGE_TOOLTIP, "Change tool tip", "")
        tbarMenu.AppendSeparator()
        tbarMenu.AppendRadioItem(IDM_TOOLBAR_SHOW_TEXT, "Show &text\tAlt-T")
        tbarMenu.AppendRadioItem(IDM_TOOLBAR_SHOW_ICONS, "Show &icons\tAlt-I")
        tbarMenu.AppendRadioItem(IDM_TOOLBAR_SHOW_BOTH, "Show &both\tAlt-B")

        fileMenu = WxMenu.new
        fileMenu.Append(WxID_EXIT, "E&xit\tAlt-X", "Quit toolbar sample" )

        helpMenu = WxMenu.new
        helpMenu.Append(WxID_HELP, "&About", "About toolbar sample")

        menuBar = WxMenuBar.new( WxMB_DOCKABLE )

        menuBar.Append(fileMenu, "&File")
        menuBar.Append(tbarMenu, "&Toolbar")
        menuBar.Append(helpMenu, "&Help")

        # Associate the menu bar with the frame
        SetMenuBar(menuBar)

        menuBar.Check(IDM_TOOLBAR_SHOW_BOTH, TRUE)

        # Create the toolbar
        RecreateToolbar()

        EVT_SIZE(self,"OnSize")

        EVT_MENU(self,WxID_EXIT, "OnQuit")
        EVT_MENU(self,WxID_HELP, "OnAbout")

        EVT_MENU(self,IDM_TOOLBAR_TOGGLE_TOOLBAR, "OnToggleToolbar")
        EVT_MENU(self,IDM_TOOLBAR_TOGGLE_ANOTHER_TOOLBAR, "OnToggleAnotherToolbar")

        EVT_MENU(self,IDM_TOOLBAR_TOGGLETOOLBARSIZE, "OnToggleToolbarSize")
        EVT_MENU(self,IDM_TOOLBAR_TOGGLETOOLBARORIENT, "OnToggleToolbarOrient")
        EVT_MENU(self,IDM_TOOLBAR_TOGGLETOOLBARROWS, "OnToggleToolbarRows")

        EVT_MENU(self,IDM_TOOLBAR_ENABLEPRINT, "OnEnablePrint")
        EVT_MENU(self,IDM_TOOLBAR_DELETEPRINT, "OnDeletePrint")
        EVT_MENU(self,IDM_TOOLBAR_INSERTPRINT, "OnInsertPrint")
        EVT_MENU(self,IDM_TOOLBAR_TOGGLEHELP, "OnToggleHelp")
        EVT_MENU(self,IDM_TOOLBAR_CHANGE_TOOLTIP, "OnChangeToolTip")

        EVT_MENU_RANGE(self,IDM_TOOLBAR_SHOW_TEXT, IDM_TOOLBAR_SHOW_BOTH,
                       "OnToolbarStyle")

        EVT_MENU(self,-1, "OnToolLeftClick")

        EVT_COMBOBOX(self,ID_COMBO, "OnCombo")

        EVT_TOOL_ENTER(self,ID_TOOLBAR, "OnToolEnter")

        EVT_UPDATE_UI(self,WxID_COPY, "OnUpdateCopyAndCut")
        EVT_UPDATE_UI(self,WxID_CUT, "OnUpdateCopyAndCut")

    end

    def RecreateToolbar()

        # delete and recreate the toolbar
        toolBar = GetToolBar()
        style = toolBar ? toolBar.GetWindowStyle() : TOOLBAR_STYLE

        if toolBar != nil
            toolBar.free
        end

        SetToolBar(nil)

        style &= ~(WxTB_HORIZONTAL | WxTB_VERTICAL)
        style |= @m_horzToolbar ? WxTB_HORIZONTAL : WxTB_VERTICAL

        toolBar = CreateToolBar(style, ID_TOOLBAR)

        # Set up toolbar
        toolBarBitmaps = [ WxBitmap.new("bitmaps/new.xpm"),
            WxBitmap.new("bitmaps/open.xpm"),
            WxBitmap.new("bitmaps/save.xpm"),
            WxBitmap.new("bitmaps/copy.xpm"),
            WxBitmap.new("bitmaps/cut.xpm"),
            WxBitmap.new("bitmaps/preview.xpm"),
            WxBitmap.new("bitmaps/print.xpm"),
            WxBitmap.new("bitmaps/help.xpm")]

        if  !@m_smallToolbar
            w = 2*toolBarBitmaps[0].GetWidth()
            h = 2*toolBarBitmaps[0].GetHeight()
            for n in 0 ... toolBarBitmaps.length
                toolBarBitmaps[n] =
                    WxBitmap.new(toolBarBitmaps[n].ConvertToImage().Scale(w, h))
            end

            toolBar.SetToolBitmapSize(WxSize.new(w, h))
        end

        toolBar.AddTool(WxID_NEW, "New", toolBarBitmaps[0], "New file")
        toolBar.AddTool(WxID_OPEN, "Open", toolBarBitmaps[1], "Open file")

        if  @m_horzToolbar
            combo = WxComboBox.new(toolBar, ID_COMBO, "", WxDefaultPosition, WxSize.new(200,-1) )
            combo.Append("This")
            combo.Append("is a")
            combo.Append("combobox")
            combo.Append("in a")
            combo.Append("toolbar")
            toolBar.AddControl(combo)
        end

        toolBar.AddTool(WxID_SAVE, "Save", toolBarBitmaps[2], "Toggle button 1", WxITEM_CHECK)
        toolBar.AddTool(WxID_COPY, "Copy", toolBarBitmaps[3], "Toggle button 2", WxITEM_CHECK)
        toolBar.AddTool(WxID_CUT, "Cut", toolBarBitmaps[4], "Toggle/Untoggle help button")
        toolBar.AddTool(WxID_PASTE, "Paste", toolBarBitmaps[5], "Paste")
        toolBar.AddTool(WxID_PRINT, "Print", toolBarBitmaps[6], "Delete self tool")
        toolBar.AddSeparator()
        toolBar.AddTool(WxID_HELP, "Help", toolBarBitmaps[7], "Help button", WxITEM_CHECK)

        # after adding the buttons to the toolbar, must call Realize() to reflect
        # the changes
        toolBar.Realize()

        toolBar.SetRows(@m_horzToolbar ? @m_rows : 10 / @m_rows)
    end

    def LayoutChildren()

        size = GetClientSize()

        if @m_tbar
            @m_tbar.SetSize(-1, size.y)
            @m_tbar.Move(0, 0)
            offset = @m_tbar.GetSize().x
        else
            offset = 0
        end

        @m_textWindow.SetSize(offset, 0, size.x - offset, size.y)
    end

    def OnSize(event)
        if @m_tbar
            LayoutChildren()
        else
            event.Skip()
        end
    end

    def OnToggleToolbar(event)
        tbar = GetToolBar()

        if !tbar
            RecreateToolbar()
        else
            tbar.free
            SetToolBar(nil)
        end
    end

    def OnEnablePrint(event)
        DoEnablePrint()
    end

    def OnDeletePrint(event)
        DoDeletePrint()
    end

    def OnToggleHelp(event)
        DoToggleHelp()
    end

    def OnToggleAnotherToolbar(event)
        if @m_tbar
            @m_tbar.free
            @m_tbar = nil
        else
            tb = GetToolBar()
            style = 0
            style = tb.GetWindowStyle() if tb

            style &= ~WxTB_HORIZONTAL
            style |= WxTB_VERTICAL

            @m_tbar = WxToolBar.new(self, -1,
                                   WxDefaultPosition, WxDefaultSize,
                                   style)

            @m_tbar.SetMargins(4, 4)

            @m_tbar.AddRadioTool(WxID_NEW, "First", WxBitmap.new("bitmaps/new.xpm"))
            @m_tbar.AddRadioTool(WxID_OPEN, "Second", WxBitmap.new("bitmaps/open.xpm"))
            @m_tbar.AddRadioTool(WxID_SAVE, "Third", WxBitmap.new("bitmaps/save.xpm"))
            @m_tbar.AddSeparator()
            @m_tbar.AddTool(WxID_HELP, "Help", WxBitmap.new("bitmaps/help.xpm"))

            @m_tbar.Realize()
        end

        LayoutChildren()
    end

    def OnToggleToolbarSize(event)
        @m_smallToolbar = !@m_smallToolbar

        RecreateToolbar()
    end

    def OnToggleToolbarRows(event)
        # @m_rows may be only 1 or 2
        @m_rows = 3 - @m_rows

        GetToolBar().SetRows((@m_horzToolbar != nil) ? @m_rows : 10 / @m_rows)

        #RecreateToolbar() -- self is unneeded
    end

    def OnToggleToolbarOrient(event)
        @m_horzToolbar = !@m_horzToolbar
        RecreateToolbar()
    end

    def OnQuit(event)
        Close(TRUE)
    end

    def OnAbout(event)
        WxMessageBox("WxWindows toolbar sample", "About WxToolBar")
    end

    def OnToolLeftClick(event)
        str = sprintf( "Clicked on tool %d\n", event.GetId())
        @m_textWindow.WriteText( str )

        if event.GetId() == WxID_HELP
            if event.GetExtraLong() != 0
                @m_textWindow.WriteText( "Help button down now.\n" )
            else
                @m_textWindow.WriteText( "Help button up now.\n" )
            end
        end

        if event.GetId() == WxID_COPY
            DoEnablePrint()
        end

        if event.GetId() == WxID_CUT
            DoToggleHelp()
        end

        if event.GetId() == WxID_PRINT
            DoDeletePrint()
        end
    end

    def OnCombo(event)
        WxLogStatus("Combobox string '%s' selected", event.GetString())
    end

    def DoEnablePrint()
        if !@m_nPrint
            return nil
        end

        tb = GetToolBar()
        tb.EnableTool(WxID_PRINT, !tb.GetToolEnabled(WxID_PRINT)) if tb
    end

    def DoDeletePrint()
        if  !@m_nPrint
            return nil
        end

        tb = GetToolBar()
        tb.DeleteTool( WxID_PRINT ) if tb

        @m_nPrint -= 1
    end

    def DoToggleHelp()
        tb = GetToolBar()
        tb.ToggleTool( WxID_HELP, !tb.GetToolState( WxID_HELP ) ) if tb
    end

    def OnUpdateCopyAndCut(event)
        event.Enable( @m_textWindow.CanCopy() )
    end

    def OnChangeToolTip(event)
        GetToolBar().SetToolShortHelp(WxID_NEW, "New toolbar button")
    end

    def OnToolbarStyle(event)
        tb = GetToolBar()
        style = 0
        style = tb.GetWindowStyle() if tb
        style &= ~(WxTB_NOICONS | WxTB_TEXT)

        case  event.GetId()
            when IDM_TOOLBAR_SHOW_TEXT
                style |= WxTB_NOICONS | WxTB_TEXT
            when IDM_TOOLBAR_SHOW_ICONS
                # nothing to do
            when IDM_TOOLBAR_SHOW_BOTH
                style |= WxTB_TEXT
        end

        GetToolBar().SetWindowStyle(style)
    end

    def OnInsertPrint(event)
        @m_nPrint += 1

        tb = GetToolBar()
        tb.InsertTool(0, WxID_PRINT, "New print",
                       WxBitmap.new("bitmaps/print.xpm"), WxNullBitmap,
                       WxITEM_NORMAL,
                       "Delete self tool",
                       "This button was inserted into the toolbar")

        # must call Realize() after adding a new button
        tb.Realize()
    end

    def OnToolEnter(event)
        if event.GetSelection() > -1
            str = sprintf("This is tool number %d", event.GetSelection())
            SetStatusText(str)
        else
            SetStatusText("")
        end
    end

end

class MyApp < WxApp
    def OnInit
        # Create the main frame window
        frame = MyFrame.new(nil, -1,
                                 "WxToolBar Sample",
                                 WxPoint.new(100, 100), WxSize.new(550, 300))

        frame.Show(TRUE)

        frame.SetStatusText("Hello, WxWindows")

        SetTopWindow(frame)
    end

    
end

a = MyApp.new
a.MainLoop()

