
require 'wx'
include Wx

ID_COMBOBOX = 1000

class ComboBoxDlg < WxDialog
  def initialize
    super(nil, -1, "ComboBoxDialog", WxDefaultPosition, WxSize.new(185, 185))

    list = [ "ABS", "Airbag", "Air conditioning" ]

    @m_pComboBox = WxComboBox.new(self, ID_COMBOBOX, "", WxDefaultPosition, WxDefaultSize, list)

    dlgSizer = WxBoxSizer.new(WxHORIZONTAL)
    comboboxSizer = WxBoxSizer.new(WxVERTICAL)
    comboboxSizer.Add(@m_pComboBox, 1, WxGROW)
    dlgSizer.Add(comboboxSizer, 1, WxGROW)
    SetSizer(dlgSizer)
    SetAutoLayout(TRUE)
    Layout()

    EVT_COMBOBOX(self,ID_COMBOBOX, "OnComboBox")
    EVT_CLOSE(self,"OnClose")
  end

  def OnComboBox(event)
    WxLogMessage("You've selected item: " + event.GetString())
  end

  def OnClose(event)
     Destroy()
  end
end


class WxRbApp < WxApp
  def OnInit
    dlg = ComboBoxDlg.new
    SetTopWindow(dlg)
    dlg.Show(TRUE)
  end

end

a = WxRbApp.new
a.MainLoop()

