
require 'wx'
include Wx

ID_RADIOBUTTON_1 = 1000
ID_RADIOBUTTON_2 = 1001
ID_RADIOBUTTON_3 = 1002

ID_RADIOBOX = 1000

class RadiobuttonDlg < WxDialog
  def initialize
    super(nil, -1, "RadiobuttonDialog", WxDefaultPosition, WxSize.new(185, 185))

    @m_pRadiobutton1 = WxRadioButton.new(self, ID_RADIOBUTTON_1, "ABS", WxDefaultPosition, WxDefaultSize, WxRB_GROUP)
    @m_pRadiobutton2 = WxRadioButton.new(self, ID_RADIOBUTTON_2, "Airbag")
    @m_pRadiobutton3 = WxRadioButton.new(self, ID_RADIOBUTTON_3, "Air Conditioning")

    dlgSizer = WxBoxSizer.new(WxHORIZONTAL)
    radioButtonSizer = WxBoxSizer.new(WxVERTICAL)
    radioButtonSizer.Add(@m_pRadiobutton1)
    radioButtonSizer.Add(@m_pRadiobutton2)
    radioButtonSizer.Add(@m_pRadiobutton3)
    dlgSizer.Add(radioButtonSizer, 1, WxGROW)
    SetSizer(dlgSizer)
    SetAutoLayout(TRUE)
    Layout()

    EVT_RADIOBUTTON(self,ID_RADIOBUTTON_1, "OnRadioButton")
    EVT_RADIOBUTTON(self,ID_RADIOBUTTON_2, "OnRadioButton")
    EVT_RADIOBUTTON(self,ID_RADIOBUTTON_3, "OnRadioButton")
    EVT_CLOSE(self,"OnClose")
  end

  def OnRadioButton(event)
    current = nil
    case event.GetId
      when ID_RADIOBUTTON_1
         current = @m_pRadiobutton1
      when ID_RADIOBUTTON_2
         current = @m_pRadiobutton2
      when ID_RADIOBUTTON_3
         current = @m_pRadiobutton3
    end
    if current != nil
      SetTitle("You've selected " + current.GetLabel)
    end
  end

  def OnClose(event)
     Destroy()
  end
end

class WxRbApp < WxApp
  def OnInit
    dlg = RadiobuttonDlg.new
    SetTopWindow(dlg)
    dlg.Show(TRUE)
  end

end

a = WxRbApp.new
a.MainLoop()

