
require 'wx'
include Wx

BASIC_EXIT    =   1
BASIC_OPEN	= 100
BASIC_ABOUT	= 200

TITLE = "Basic - Step 3: Responding to events"

class BasicFrame < WxFrame
  def initialize(title,xpos,ypos,width,height)
    super(nil,-1,title,WxPoint.new(xpos,ypos),WxSize.new(width,height))

    @theText = WxTextCtrl.new(self,
  	  -1,
  	  ("This is a text control\n\n" \
  	           "The text control supports" \
                   " basic text editing operations\n" \
  	           "along with copy, cut, paste, " \
                   "delete, select all and undo.\n\n" \
  	           "Right click on the control" \
                   " to see the pop-up menu.\n"
  	          ),
  	  WxDefaultPosition,
  	  WxDefaultSize,
  	  WxTE_MULTILINE)

  fileMenu = WxMenu.new
  fileMenu.Append(BASIC_OPEN,  "&Open file")
  fileMenu.Append(BASIC_ABOUT, "&About")
  fileMenu.AppendSeparator
  fileMenu.Append(BASIC_EXIT,  "E&xit")

  menuBar = WxMenuBar.new
  menuBar.Append(fileMenu, "&File")
  SetMenuBar(menuBar)
  CreateStatusBar(3)

  EVT_MENU (self, BASIC_EXIT,  "OnExit")
  EVT_MENU (self, BASIC_ABOUT, "OnAbout")
  EVT_MENU (self, BASIC_OPEN,  "OnOpenFile")

  end

  def OnOpenFile (event)
    @theText.LoadFile("data.txt")
  end


  def OnAbout (event)
    t = TITLE
    t << "\nDB 2001"

    aboutDialog = WxMessageDialog.new(self, t, "About Basic",
    WxOK | WxCANCEL)
    aboutDialog.ShowModal
  end

  def OnExit (event)
    Close(TRUE)
  end

end

class WxRbApp < WxApp
  def OnInit
    frame = BasicFrame.new("wxWindows Basic Steps - Step 1:" \
        " A simple application",
         50, 50, 200, 200)

    frame.Show(TRUE)
    SetTopWindow(frame)
  end

end


a = WxRbApp.new
a.MainLoop

