
require 'wx'
include Wx

CONTROLS_QUIT   = 100
CONTROLS_TEXT   = 101
CONTROLS_ABOUT  = 102
CONTROLS_CLEAR_LOG = 103
# tooltip menu
CONTROLS_SET_TOOLTIP_DELAY = 200
CONTROLS_ENABLE_TOOLTIPS = 201
# panel menu
CONTROLS_ENABLE_ALL     = 202


ID_NOTEBOOK          = 1000

ID_LISTBOX           = 130
ID_LISTBOX_SEL_NUM   = 131
ID_LISTBOX_SEL_STR   = 132
ID_LISTBOX_CLEAR     = 133
ID_LISTBOX_APPEND    = 134
ID_LISTBOX_DELETE    = 135
ID_LISTBOX_FONT      = 136
ID_LISTBOX_ENABLE    = 137
ID_LISTBOX_SORTED    = 138

ID_CHOICE            = 120
ID_CHOICE_SEL_NUM    = 121
ID_CHOICE_SEL_STR    = 122
ID_CHOICE_CLEAR      = 123
ID_CHOICE_APPEND     = 124
ID_CHOICE_DELETE     = 125
ID_CHOICE_FONT       = 126
ID_CHOICE_ENABLE     = 127
ID_CHOICE_SORTED     = 128

ID_COMBO             = 140
ID_COMBO_SEL_NUM     = 141
ID_COMBO_SEL_STR     = 142
ID_COMBO_CLEAR       = 143
ID_COMBO_APPEND      = 144
ID_COMBO_DELETE      = 145
ID_COMBO_FONT        = 146
ID_COMBO_ENABLE      = 147

ID_RADIOBOX          = 160
ID_RADIOBOX_SEL_NUM  = 161
ID_RADIOBOX_SEL_STR  = 162
ID_RADIOBOX_FONT     = 163
ID_RADIOBOX_ENABLE   = 164

ID_RADIOBUTTON_1     = 166
ID_RADIOBUTTON_2     = 167

ID_SET_FONT          = 170

ID_GAUGE             = 180
ID_SLIDER            = 181

ID_SPIN              = 182
ID_BTNPROGRESS       = 183
ID_BUTTON_LABEL      = 184
ID_SPINCTRL          = 185

ID_BUTTON_TEST1      = 190
ID_BUTTON_TEST2      = 191
ID_BITMAP_BTN        = 192

ID_CHANGE_COLOUR     = 200

ID_SIZER_CHECK1      = 201
ID_SIZER_CHECK2      = 202
ID_SIZER_CHECK3      = 203
ID_SIZER_CHECK4      = 204
ID_SIZER_CHECK14     = 205
ID_SIZER_CHECKBIG    = 206

Image_List, Image_Choice, Image_Combo, Image_Text, Image_Radio, Image_Gauge, Image_Max = 0,1,2,3,4,5,6

def MySetClientData(name,control)
    count = control.GetCount()
    for n in 0 ... count
        s = sprintf("%s client data for '%s'",
                 name, control.GetString(n))
        control.SetClientData(n, s)
    end
end


# a button which intercepts double clicks (for testing...)
class MyButton < WxButton
    def initialize(parent,id,label = WxEmptyString,pos = WxDefaultPosition,size = WxDefaultSize)
        super(parent,id,label,pos,size)

        EVT_LEFT_DCLICK(self,"OnDClick")
    end

    def OnDClick(event)
        WxLogMessage("MyButton::OnDClick")
        event.Skip()
    end

end

# a combo which intercepts chars (to test Windows behaviour)
class MyComboBox < WxComboBox
    def initialize(parent,id,value = WxEmptyString,
               pos = WxDefaultPosition,
               size = WxDefaultSize,
               choices = [],
               style = 0)
        super(parent, id, value, pos, size, choices, style)

        EVT_CHAR(self,"OnChar")
        EVT_KEY_DOWN(self,"OnKeyDown")
        EVT_KEY_UP(self,"OnKeyUp")

        EVT_SET_FOCUS(self,"OnFocusGot")
    end

    def OnChar(event)
        WxLogMessage("MyComboBox::OnChar")
        if event.KeyCode() == ?w
            WxLogMessage("MyComboBox: 'w' will be ignored.")
        else
            event.Skip()
        end
    end

    def OnKeyDown(event)
        WxLogMessage("MyComboBox::OnKeyDown")
        if event.KeyCode() == ?w
            WxLogMessage("MyComboBox: 'w' will be ignored.")
        else
            event.Skip()
        end
    end

    def OnKeyUp(event)
        WxLogMessage("MyComboBox::OnKeyUp")
        event.Skip()
    end

    def OnFocusGot(event)
        WxLogMessage("MyComboBox::OnFocusGot")
        event.Skip()
    end

end

# a radiobox which handles focus set/kill (for testing)
class MyRadioBox < WxRadioBox
    def initialize(parent,
               id,title = WxEmptyString,
               pos = WxDefaultPosition,
               size = WxDefaultSize,
               choices = [],
               majorDim = 1,
               style = WxRA_HORIZONTAL)
        super(parent, id, title, pos, size, choices, majorDim,style)
        SetForegroundColour(WxRED)

        EVT_SET_FOCUS(self,"OnFocusGot")
        EVT_KILL_FOCUS(self,"OnFocusLost")

    end

    def OnFocusGot(event)
        WxLogMessage("MyRadioBox::OnFocusGot")
        event.Skip()
    end

    def OnFocusLost(event)
        WxLogMessage("MyRadioBox::OnFocusLost")
        event.Skip()
    end

end


class MyPanel < WxPanel

#    delete WxLog::SetActiveTarget(@m_logTargetOld)
#    delete @m_notebook.GetImageList()
    attr_reader   :m_text,:m_logTargetOld

    def initialize(frame,x,y,w,h)
        super( frame, -1, WxPoint.new(x, y), WxSize.new(w, h) )

        @s_colOld = WxColour.new

        @m_text = WxTextCtrl.new(self, -1, "This is the log window.\n",
                                WxPoint.new(0, 250), WxSize.new(100, 50), WxTE_MULTILINE)
        @m_text.SetBackgroundColour(WxColour.new("wheat"))

        @m_logTargetOld = WxLog::SetActiveTarget(WxLogTextCtrl.new(@m_text))

        @m_notebook = WxNotebook.new(self, ID_NOTEBOOK)

        choices = [
            "This",
            "is one of my",
            "really",
            "wonderful",
            "examples."
        ]

        # fill the image list

        imagelist = WxImageList.new(16, 16)

        imagelist.Add( WxIcon.new( "icons/list.xpm" ))
        imagelist.Add( WxIcon.new( "icons/choice.xpm" ))
        imagelist.Add( WxIcon.new( "icons/combo.xpm" ))
        imagelist.Add( WxIcon.new( "icons/text.xpm" ))
        imagelist.Add( WxIcon.new( "icons/radio.xpm" ))
        imagelist.Add( WxIcon.new( "icons/gauge.xpm" ))
        @m_notebook.SetImageList(imagelist)

        panel = WxPanel.new(@m_notebook)
        @m_listbox = WxListBox.new( panel, ID_LISTBOX,
                                   WxPoint.new(10,10), WxSize.new(120,70),
                                   choices, WxLB_ALWAYS_SB )

        @m_listboxSorted = WxListBox.new( panel, ID_LISTBOX_SORTED,
                                         WxPoint.new(10,90), WxSize.new(120,70),
                                         choices, WxLB_SORT )

        MySetClientData("listbox", @m_listbox)
        MySetClientData("listbox", @m_listboxSorted)

        @m_listbox.SetCursor(WxCROSS_CURSOR)

        @m_listbox.SetToolTip( "This is a list box" )


        @m_lbSelectNum = WxButton.new( panel, ID_LISTBOX_SEL_NUM, "Select #&2", WxPoint.new(180,30), WxSize.new(140,30) )
        @m_lbSelectThis = WxButton.new( panel, ID_LISTBOX_SEL_STR, "&Select 'This'", WxPoint.new(340,30), WxSize.new(140,30) )
        WxButton.new( panel, ID_LISTBOX_CLEAR, "&Clear", WxPoint.new(180,80), WxSize.new(140,30) )
        MyButton.new( panel, ID_LISTBOX_APPEND, "&Append 'Hi!'", WxPoint.new(340,80), WxSize.new(140,30) )
        WxButton.new( panel, ID_LISTBOX_DELETE, "D&elete selected item", WxPoint.new(180,130), WxSize.new(140,30) )
        button = MyButton.new( panel, ID_LISTBOX_FONT, "Set &Italic font", WxPoint.new(340,130), WxSize.new(140,30) )

        button.SetDefault()

        button.SetForegroundColour(WxBLUE)

        button.SetToolTip( "Press here to set italic font" )

        @m_checkbox = WxCheckBox.new( panel, ID_LISTBOX_ENABLE, "&Disable", WxPoint.new(20,170) )
        @m_checkbox.SetValue(FALSE)
        @m_checkbox.SetToolTip( "Click here to disable the listbox" )
        WxCheckBox.new( panel, ID_CHANGE_COLOUR, "&Toggle colour",
                              WxPoint.new(110,170) )
        panel.SetCursor(WxCursor.new(WxCURSOR_HAND))
        @m_notebook.AddPage(panel, "WxListBox", TRUE, Image_List)

        panel = WxPanel.new(@m_notebook)
        @m_choice = WxChoice.new( panel, ID_CHOICE, WxPoint.new(10,10), WxSize.new(120,-1), choices )
        @m_choiceSorted = WxChoice.new( panel, ID_CHOICE_SORTED, WxPoint.new(10,70), WxSize.new(120,-1),
                                       choices, WxCB_SORT )

        MySetClientData("choice", @m_choice)
        MySetClientData("choice", @m_choiceSorted)

        @m_choice.SetSelection(2)
        @m_choice.SetBackgroundColour(WxColour.new("red"))
        WxButton.new( panel, ID_CHOICE_SEL_NUM, "Select #&2", WxPoint.new(180,30), WxSize.new(140,30) )
        WxButton.new( panel, ID_CHOICE_SEL_STR, "&Select 'This'", WxPoint.new(340,30), WxSize.new(140,30) )
        WxButton.new( panel, ID_CHOICE_CLEAR, "&Clear", WxPoint.new(180,80), WxSize.new(140,30) )
        WxButton.new( panel, ID_CHOICE_APPEND, "&Append 'Hi!'", WxPoint.new(340,80), WxSize.new(140,30) )
        WxButton.new( panel, ID_CHOICE_DELETE, "D&elete selected item", WxPoint.new(180,130), WxSize.new(140,30) )
        WxButton.new( panel, ID_CHOICE_FONT, "Set &Italic font", WxPoint.new(340,130), WxSize.new(140,30) )
        WxCheckBox.new( panel, ID_CHOICE_ENABLE, "&Disable", WxPoint.new(20,130), WxSize.new(140,30) )

        @m_notebook.AddPage(panel, "WxChoice", FALSE, Image_Choice)

        panel = WxPanel.new(@m_notebook)
        WxStaticBox.new( panel, -1, "&Box around combobox",
                               WxPoint.new(5, 5), WxSize.new(150, 100))
        @m_combo = MyComboBox.new( panel, ID_COMBO, "This",
                                  WxPoint.new(20,25), WxSize.new(120, -1),
                                  choices,WxPROCESS_ENTER)
                                  # WxCB_READONLY | WxPROCESS_ENTER)

        WxButton.new( panel, ID_COMBO_SEL_NUM, "Select #&2", WxPoint.new(180,30), WxSize.new(140,30) )
        WxButton.new( panel, ID_COMBO_SEL_STR, "&Select 'This'", WxPoint.new(340,30), WxSize.new(140,30) )
        WxButton.new( panel, ID_COMBO_CLEAR, "&Clear", WxPoint.new(180,80), WxSize.new(140,30) )
        WxButton.new( panel, ID_COMBO_APPEND, "&Append 'Hi!'", WxPoint.new(340,80), WxSize.new(140,30) )
        WxButton.new( panel, ID_COMBO_DELETE, "D&elete selected item", WxPoint.new(180,130), WxSize.new(140,30) )
        WxButton.new( panel, ID_COMBO_FONT, "Set &Italic font", WxPoint.new(340,130), WxSize.new(140,30) )
        WxCheckBox.new( panel, ID_COMBO_ENABLE, "&Disable", WxPoint.new(20,130), WxSize.new(140,30) )
        @m_notebook.AddPage(panel, "WxComboBox", FALSE, Image_Combo)

        choices2 = ["First", "Second"]
            # "Third",
            #"Fourth", "Fifth", "Sixth",
            #"Seventh", "Eighth", "Nineth", "Tenth" */

        panel = WxPanel.new(@m_notebook)
        MyRadioBox.new( panel, ID_RADIOBOX, "&That", WxPoint.new(10,160), WxSize.new(-1,-1), choices2, 1, WxRA_SPECIFY_ROWS )
        @m_radio = WxRadioBox.new( panel, ID_RADIOBOX, "T&his", WxPoint.new(10,10), WxSize.new(-1,-1), choices, 1, WxRA_SPECIFY_COLS )
        @m_radio.SetForegroundColour(WxRED)

        @m_combo.SetToolTip("This is a natural\ncombobox - can you believe me?")
        @m_radio.SetToolTip("Ever seen a radiobox?")

        WxButton.new( panel, ID_RADIOBOX_SEL_NUM, "Select #&2", WxPoint.new(180,30), WxSize.new(140,30) )
        WxButton.new( panel, ID_RADIOBOX_SEL_STR, "&Select 'This'", WxPoint.new(180,80), WxSize.new(140,30) )
        @m_fontButton = WxButton.new( panel, ID_SET_FONT, "Set &more Italic font", WxPoint.new(340,30), WxSize.new(140,30) )
        WxButton.new( panel, ID_RADIOBOX_FONT, "Set &Italic font", WxPoint.new(340,80), WxSize.new(140,30) )
        WxCheckBox.new( panel, ID_RADIOBOX_ENABLE, "&Disable", WxPoint.new(340,130), WxDefaultSize )
        rb = WxRadioButton.new( panel, ID_RADIOBUTTON_1, "Radiobutton1", WxPoint.new(210,170), WxDefaultSize, WxRB_GROUP )
        rb.SetValue( FALSE )
        WxRadioButton.new( panel, ID_RADIOBUTTON_2, "&Radiobutton2", WxPoint.new(340,170), WxDefaultSize )
        @m_notebook.AddPage(panel, "WxRadioBox", FALSE, Image_Radio)

        panel = WxPanel.new(@m_notebook)
        WxStaticBox.new( panel, -1, "&WxGauge and WxSlider", WxPoint.new(10,10), WxSize.new(222,130) )
        @m_gauge = WxGauge.new( panel, -1, 200, WxPoint.new(18,50), WxSize.new(155, 30), WxGA_HORIZONTAL|WxNO_BORDER )
        @m_gauge.SetBackgroundColour(WxGREEN)
        @m_gauge.SetForegroundColour(WxRED)
        @m_gaugeVert = WxGauge.new( panel, -1, 100,
                                   WxPoint.new(195,35), WxSize.new(30, 90),
                                   WxGA_VERTICAL | WxGA_SMOOTH | WxNO_BORDER )
        @m_slider = WxSlider.new( panel, ID_SLIDER, 0, 0, 200, WxPoint.new(18,90), WxSize.new(155,-1),
                                 WxSL_AUTOTICKS | WxSL_LABELS )
        @m_slider.SetTickFreq(40, 0)
        @m_slider.SetToolTip("This is a sliding slider")

        WxStaticBox.new( panel, -1, "&Explanation",
                               WxPoint.new(230,10), WxSize.new(270,130),
                               WxALIGN_CENTER )

        WxStaticText.new( panel, -1,
                                "In order see the gauge (aka progress bar)\n"+
                                "control do something you have to drag the\n"+
                                "handle of the slider to the right.\n"+
                                "\n"+
                                "This is also supposed to demonstrate how\n"+
                                "to use static controls.\n",
                                WxPoint.new(250,25),
                                WxSize.new(240, 110))
        initialSpinValue = -5
        s = initialSpinValue.to_s
        @m_spintext = WxTextCtrl.new( panel, -1, s, WxPoint.new(20,160), WxSize.new(80,-1) )
        @m_spinbutton = WxSpinButton.new( panel, ID_SPIN, WxPoint.new(103,160), WxSize.new(80, -1) )
        @m_spinbutton.SetRange(-40,30)
        @m_spinbutton.SetValue(initialSpinValue)

        @m_btnProgress = WxButton.new( panel, ID_BTNPROGRESS, "&Show progress dialog",
                                      WxPoint.new(300, 160) )

        @m_spinctrl = WxSpinCtrl.new( panel, ID_SPINCTRL, "", WxPoint.new(200, 160), WxSize.new(80, -1) )
        @m_spinctrl.SetRange(10,30)
        @m_spinctrl.SetValue(15)

        @m_notebook.AddPage(panel, "WxGauge", FALSE, Image_Gauge)

        panel = WxPanel.new(@m_notebook)

        icon = WxArtProvider::GetIcon(WxART_INFORMATION)
        WxStaticBitmap.new( panel, -1, icon, WxPoint.new(10, 10) )

        bitmap = WxBitmap.new( 100, 100 )
        dc = WxMemoryDC.new
        dc.SelectObject( bitmap )
        dc.SetPen(WxGREEN_PEN)
        dc.Clear()
        dc.DrawEllipse(5, 5, 90, 90)
        dc.DrawText("Bitmap", 30, 40)
        dc.SelectObject( WxNullBitmap )
        dc.free

        WxBitmapButton.new(panel, ID_BITMAP_BTN, bitmap, WxPoint.new(100, 20))

        if WxRUBY_PLATFORM ==  "WXMSW"
            # test for masked bitmap display
            bitmap = WxBitmap.new("test2.bmp", WxBITMAP_TYPE_BMP)
            if bitmap.Ok()
               bitmap.SetMask(WxMask.new(bitmap, WxBLUE))
               WxStaticBitmap.new(panel, -1, bitmap, WxPoint.new(300, 120))
            end
        end
        bmp1 = WxArtProvider::GetBitmap(WxART_INFORMATION)
        bmp2 = WxArtProvider::GetBitmap(WxART_WARNING)
        bmp3 = WxArtProvider::GetBitmap(WxART_QUESTION)
        bmpBtn = WxBitmapButton.new(panel, -1,
                                    bmp1,
                                    WxPoint.new(30, 70))

        bmpBtn.SetBitmapSelected(bmp2)
        bmpBtn.SetBitmapFocus(bmp3)

        WxToggleButton.new(panel, ID_BUTTON_LABEL,
                                 "&Toggle label", WxPoint.new(250, 20))

        @m_label = WxStaticText.new(panel, -1, "Label with some long text",
                                   WxPoint.new(250, 60), WxDefaultSize,
                                   WxALIGN_RIGHT)
        @m_label.SetForegroundColour(WxBLUE )

        @m_notebook.AddPage(panel, "WxBitmapXXX")

        # layout constraints

        panel = WxPanel.new(@m_notebook)
        panel.SetAutoLayout( TRUE )

        c = WxLayoutConstraints.new
        c.top.SameAs( panel, WxTop, 10 )
        c.height.AsIs( )
        c.left.SameAs( panel, WxLeft, 10 )
        c.width.PercentOf( panel, WxWidth, 40 )

        pMyButton = WxButton.new(panel, ID_BUTTON_TEST1, "Test Button &1" )
        pMyButton.SetConstraints( c )

        c = WxLayoutConstraints.new
        c.top.SameAs( panel, WxTop, 10 )
        c.bottom.SameAs( panel, WxBottom, 10 )
        c.right.SameAs( panel, WxRight, 10 )
        c.width.PercentOf( panel, WxWidth, 40 )

        pMyButton2 = WxButton.new(panel, ID_BUTTON_TEST2, "Test Button &2" )
        pMyButton2.SetConstraints( c )

        @m_notebook.AddPage(panel, "WxLayoutConstraint")

        # sizer

        panel = WxPanel.new(@m_notebook)
        panel.SetAutoLayout( TRUE )

        sizer = WxBoxSizer.new( WxVERTICAL )

        csizer =
          WxStaticBoxSizer.new(WxStaticBox.new(panel, -1, "Show Buttons"),
    			    WxHORIZONTAL )

        check1 = WxCheckBox.new(panel, ID_SIZER_CHECK1, "1")
        check1.SetValue(TRUE)
        csizer.Add(check1)
        check2 = WxCheckBox.new(panel, ID_SIZER_CHECK2, "2")
        check2.SetValue(TRUE)
        csizer.Add(check2)
        check3 = WxCheckBox.new(panel, ID_SIZER_CHECK3, "3")
        check3.SetValue(TRUE)
        csizer.Add(check3)
        check4 = WxCheckBox.new(panel, ID_SIZER_CHECK4, "4")
        check4.SetValue(TRUE)
        csizer.Add(check4)
        check14 = WxCheckBox.new(panel, ID_SIZER_CHECK14, "1-4")
        check14.SetValue(TRUE)
        csizer.Add(check14)
        checkBig = WxCheckBox.new(panel, ID_SIZER_CHECKBIG, "Big")
        checkBig.SetValue(TRUE)
        csizer.Add(checkBig)

        sizer.Add(csizer)

        @m_hsizer = WxBoxSizer.new( WxHORIZONTAL )

        @m_buttonSizer = WxBoxSizer.new(WxVERTICAL)

        @m_sizerBtn1 = WxButton.new(panel, -1, "Test Button &1" )
        @m_buttonSizer.Add( @m_sizerBtn1, 0, WxALL, 10 )
        @m_sizerBtn2 = WxButton.new(panel, -1, "Test Button &2" )
        @m_buttonSizer.Add( @m_sizerBtn2, 0, WxALL, 10 )
        @m_sizerBtn3 = WxButton.new(panel, -1, "Test Button &3" )
        @m_buttonSizer.Add( @m_sizerBtn3, 0, WxALL, 10 )
        @m_sizerBtn4 = WxButton.new(panel, -1, "Test Button &4" )
        @m_buttonSizer.Add( @m_sizerBtn4, 0, WxALL, 10 )

        @m_hsizer.Add(@m_buttonSizer)
        @m_hsizer.Add( 20,20, 1 )
        @m_bigBtn = WxButton.new(panel, -1, "Multiline\nbutton" )
        @m_hsizer.Add( @m_bigBtn , 3, WxGROW|WxALL, 10 )

        sizer.Add(@m_hsizer, 1, WxGROW)

        panel.SetSizer( sizer )

        @m_notebook.AddPage(panel, "WxSizer")

        EVT_SIZE(self,                         "OnSize")
        EVT_NOTEBOOK_PAGE_CHANGING(self,ID_NOTEBOOK, "OnPageChanging")
        EVT_NOTEBOOK_PAGE_CHANGED(self,ID_NOTEBOOK,  "OnPageChanged")
        EVT_LISTBOX(self,ID_LISTBOX,              "OnListBox")
        EVT_LISTBOX(self,ID_LISTBOX_SORTED,       "OnListBox")
        EVT_LISTBOX_DCLICK(self,ID_LISTBOX,          "OnListBoxDoubleClick")
        EVT_BUTTON(self,ID_LISTBOX_SEL_NUM,      "OnListBoxButtons")
        EVT_BUTTON(self,ID_LISTBOX_SEL_STR,      "OnListBoxButtons")
        EVT_BUTTON(self,ID_LISTBOX_CLEAR,        "OnListBoxButtons")
        EVT_BUTTON(self,ID_LISTBOX_APPEND,       "OnListBoxButtons")
        EVT_BUTTON(self,ID_LISTBOX_DELETE,       "OnListBoxButtons")
        EVT_BUTTON(self,ID_LISTBOX_FONT,         "OnListBoxButtons")
        EVT_CHECKBOX(self,ID_LISTBOX_ENABLE,       "OnListBoxButtons")
        EVT_CHOICE(self,ID_CHOICE,               "OnChoice")
        EVT_CHOICE(self,ID_CHOICE_SORTED,        "OnChoice")
        EVT_BUTTON(self,ID_CHOICE_SEL_NUM,       "OnChoiceButtons")
        EVT_BUTTON(self,ID_CHOICE_SEL_STR,       "OnChoiceButtons")
        EVT_BUTTON(self,ID_CHOICE_CLEAR,         "OnChoiceButtons")
        EVT_BUTTON(self,ID_CHOICE_APPEND,        "OnChoiceButtons")
        EVT_BUTTON(self,ID_CHOICE_DELETE,        "OnChoiceButtons")
        EVT_BUTTON(self,ID_CHOICE_FONT,          "OnChoiceButtons")
        EVT_CHECKBOX(self,ID_CHOICE_ENABLE,        "OnChoiceButtons")
        EVT_COMBOBOX(self,ID_COMBO,                "OnCombo")
        EVT_TEXT(self,ID_COMBO,                "OnComboTextChanged")
        EVT_TEXT_ENTER(self,ID_COMBO,                "OnComboTextEnter")
        EVT_BUTTON(self,ID_COMBO_SEL_NUM,        "OnComboButtons")
        EVT_BUTTON(self,ID_COMBO_SEL_STR,        "OnComboButtons")
        EVT_BUTTON(self,ID_COMBO_CLEAR,          "OnComboButtons")
        EVT_BUTTON(self,ID_COMBO_APPEND,         "OnComboButtons")
        EVT_BUTTON(self,ID_COMBO_DELETE,         "OnComboButtons")
        EVT_BUTTON(self,ID_COMBO_FONT,           "OnComboButtons")
        EVT_CHECKBOX(self,ID_COMBO_ENABLE,         "OnComboButtons")
        EVT_RADIOBOX(self,ID_RADIOBOX,             "OnRadio")
        EVT_BUTTON(self,ID_RADIOBOX_SEL_NUM,     "OnRadioButtons")
        EVT_BUTTON(self,ID_RADIOBOX_SEL_STR,     "OnRadioButtons")
        EVT_BUTTON(self,ID_RADIOBOX_FONT,        "OnRadioButtons")
        EVT_CHECKBOX(self,ID_RADIOBOX_ENABLE,      "OnRadioButtons")
        EVT_BUTTON(self,ID_SET_FONT,             "OnSetFont")
        EVT_SLIDER(self,ID_SLIDER,               "OnSliderUpdate")
        EVT_SPIN(self,ID_SPIN,                 "OnSpinUpdate")
        EVT_SPIN_UP(self,ID_SPIN,                 "OnSpinUp")
        EVT_SPIN_DOWN(self,ID_SPIN,                 "OnSpinDown")
        EVT_UPDATE_UI(self,ID_BTNPROGRESS,          "OnUpdateShowProgress")
        EVT_BUTTON(self,ID_BTNPROGRESS,          "OnShowProgress")
        EVT_SPINCTRL(self,ID_SPINCTRL,             "OnSpinCtrl")
        EVT_SPIN_UP(self,ID_SPINCTRL,             "OnSpinCtrlUp")
        EVT_SPIN_DOWN(self,ID_SPINCTRL,             "OnSpinCtrlDown")
        EVT_TEXT(self,ID_SPINCTRL,             "OnSpinCtrlText")
        EVT_TOGGLEBUTTON(self,ID_BUTTON_LABEL,       "OnUpdateLabel")
        EVT_CHECKBOX(self,ID_CHANGE_COLOUR,        "OnChangeColour")
        EVT_BUTTON(self,ID_BUTTON_TEST1,         "OnTestButton")
        EVT_BUTTON(self,ID_BUTTON_TEST2,         "OnTestButton")
        EVT_BUTTON(self,ID_BITMAP_BTN,           "OnBmpButton")

        EVT_CHECKBOX(self,ID_SIZER_CHECK1,         "OnSizerCheck")
        EVT_CHECKBOX(self,ID_SIZER_CHECK2,         "OnSizerCheck")
        EVT_CHECKBOX(self,ID_SIZER_CHECK3,         "OnSizerCheck")
        EVT_CHECKBOX(self,ID_SIZER_CHECK4,         "OnSizerCheck")
        EVT_CHECKBOX(self,ID_SIZER_CHECK14,        "OnSizerCheck")
        EVT_CHECKBOX(self,ID_SIZER_CHECKBIG,       "OnSizerCheck")

    end

    def OnSize(event)
        x,y = GetClientSizeWH()
        if @m_notebook
            @m_notebook.SetSize( 2, 2, x-4, y*2/3-4 )
        end
        if @m_text
            @m_text.SetSize( 2, y*2/3+2, x-4, y/3-4 )
        end
    end

    def OnPageChanging(event)
        selOld = event.GetOldSelection()
        if selOld == 2
            if WxMessageBox("This demonstrates how a program may prevent the\n"+
                              "page change from taking place - if you select\n"+
                              "[No] the current page will stay the third one\n",
                              "Control sample",
                              WxICON_QUESTION | WxYES_NO, self) != WxYES
                event.Veto()
                return nil
            end
        end
        @m_text << "Notebook selection is being changed from " << selOld \
                << " to " << event.GetSelection()   \
                << " (current page from notebook is "   \
                << @m_notebook.GetSelection() << ")\n"
    end

    def OnPageChanged(event)
        @m_text << "Notebook selection is now " << event.GetSelection() \
                << " (from notebook: " << @m_notebook.GetSelection()    \
                << ")\n"
    end

    def OnTestButton(event)
        WxLogMessage("Button %s clicked.",
                     event.GetId() == ID_BUTTON_TEST1 ? '1' : '2')
    end

    def OnBmpButton(event)
        WxLogMessage("Bitmap button clicked.")
    end

    def OnChangeColour(event)
        # test panel colour changing and propagation to the subcontrols
        if @s_colOld.Ok()

            SetBackgroundColour(@s_colOld)
            @s_colOld = WxNullColour

            @m_lbSelectThis.SetForegroundColour(WxColour.new("red"))
            @m_lbSelectThis.SetBackgroundColour(WxColour.new("white"))
        else
            @s_colOld = WxColour.new("red")
            SetBackgroundColour(WxColour.new("white"))

            @m_lbSelectThis.SetForegroundColour(WxColour.new("white"))
            @m_lbSelectThis.SetBackgroundColour(WxColour.new("red"))
        end

        @m_lbSelectThis.Refresh()
        Refresh()
    end

    def OnListBox(event)
    #    GetParent().Move(100, 100)
        if event.GetInt() == -1
            @m_text.AppendText( "ListBox has no selections anymore\n" )
            return Qnil
        end

        listbox = (event.GetId() == ID_LISTBOX) ? @m_listbox : @m_listboxSorted

        @m_text.AppendText( "ListBox event selection string is: '" )
        @m_text.AppendText( event.GetString() )
        @m_text.AppendText( "'\n" )
        @m_text.AppendText( "ListBox control selection string is: '" )
        @m_text.AppendText( listbox.GetStringSelection() )
        @m_text.AppendText( "'\n" )

        obj = event.GetClientData()
        @m_text.AppendText( "ListBox event client data string is: '" )
        if obj
            @m_text.AppendText( obj )
        else
            @m_text.AppendText( "none" )
        end

        @m_text.AppendText( "'\n" )
        @m_text.AppendText( "ListBox control client data string is: '" )
        obj = listbox.GetClientData(listbox.GetSelection())
        if obj
            @m_text.AppendText( obj )
        else
            @m_text.AppendText( "none" )
        end
        @m_text.AppendText( "'\n" )
    end

    def OnListBoxDoubleClick(event)
        @m_text.AppendText( "ListBox double click string is: " )
        @m_text.AppendText( event.GetString() )
        @m_text.AppendText( "\n" )
    end

    def OnListBoxButtons(event)
        case event.GetId()
            when ID_LISTBOX_ENABLE
                    @m_text.AppendText("Checkbox clicked.\n")
                    cb = event.GetEventObject()
                    if event.GetInt() != 0
                        cb.SetToolTip( "Click to enable listbox" )
                    else
                        cb.SetToolTip( "Click to disable listbox" )
                    end
                    @m_listbox.Enable( event.GetInt() == 0 )
                    @m_lbSelectThis.Enable( event.GetInt() == 0 )
                    @m_lbSelectNum.Enable( event.GetInt() == 0 )
                    @m_listboxSorted.Enable( event.GetInt() == 0 )
                    FindWindow(ID_CHANGE_COLOUR).Enable( event.GetInt() == 0 )
            when ID_LISTBOX_SEL_NUM
                    @m_listbox.SetSelection( 2 )
                    @m_listboxSorted.SetSelection( 2 )
                    @m_lbSelectThis.WarpPointer( 40, 14 )
            when ID_LISTBOX_SEL_STR
                    @m_listbox.SetStringSelection( "This" )
                    @m_listboxSorted.SetStringSelection( "This" )
                    @m_lbSelectNum.WarpPointer( 40, 14 )
            when ID_LISTBOX_CLEAR
                    @m_listbox.Clear()
                    @m_listboxSorted.Clear()
            when ID_LISTBOX_APPEND
                    @m_listbox.Append( "Hi!" )
                    @m_listboxSorted.Append( "Hi!" )
            when ID_LISTBOX_DELETE
                    idx = @m_listbox.GetSelection()
                    if idx != WxNOT_FOUND
                        @m_listbox.Delete( idx )
                    end
                    idx = @m_listboxSorted.GetSelection()
                    if idx != WxNOT_FOUND
                        @m_listboxSorted.Delete( idx )
                    end
            when ID_LISTBOX_FONT
                    @m_listbox.SetFont( WxITALIC_FONT )
                    @m_listboxSorted.SetFont( WxITALIC_FONT )
                    @m_checkbox.SetFont( WxITALIC_FONT )
        end
    end


    def OnChoice(event)

        choice = (event.GetId() == ID_CHOICE) ? @m_choice : @m_choiceSorted

        @m_text.AppendText( "Choice event selection string is: '" )
        @m_text.AppendText( event.GetString() )
        @m_text.AppendText( "'\n" )
        @m_text.AppendText( "Choice control selection string is: '" )
        @m_text.AppendText( choice.GetStringSelection() )
        @m_text.AppendText( "'\n" )

        obj = event.GetClientData()
        @m_text.AppendText( "Choice event client data string is: '" )

        if obj
           @m_text.AppendText( obj )
        else
           @m_text.AppendText( "none" )
        end

        @m_text.AppendText( "'\n" )
        @m_text.AppendText( "Choice control client data string is: '" )

        obj = choice.GetClientData(choice.GetSelection())
        if obj
           @m_text.AppendText( obj )
        else
           @m_text.AppendText( "none" )
        end
        @m_text.AppendText( "'\n" )
    end

    def OnChoiceButtons(event)
        case event.GetId()
            when ID_CHOICE_ENABLE
                    @m_choice.Enable( event.GetInt() == 0 )
                    @m_choiceSorted.Enable( event.GetInt() == 0 )
            when ID_CHOICE_SEL_NUM
                    @m_choice.SetSelection( 2 )
                    @m_choiceSorted.SetSelection( 2 )
            when ID_CHOICE_SEL_STR
                    @m_choice.SetStringSelection( "This" )
                    @m_choiceSorted.SetStringSelection( "This" )
            when ID_CHOICE_CLEAR
                    @m_choice.Clear()
                    @m_choiceSorted.Clear()
            when ID_CHOICE_APPEND
                    @m_choice.Append( "Hi!" )
                    @m_choiceSorted.Append( "Hi!" )
            when ID_CHOICE_DELETE
                    idx = @m_choice.GetSelection()
                    if idx != WxNOT_FOUND
                        @m_choice.Delete( idx )
                    end
                    idx = @m_choiceSorted.GetSelection()
                    if idx != WxNOT_FOUND
                        @m_choiceSorted.Delete( idx )
                    end
            when ID_CHOICE_FONT
                    @m_choice.SetFont( WxITALIC_FONT )
                    @m_choiceSorted.SetFont( WxITALIC_FONT )
        end
    end

    def OnCombo(event)
        @m_text.AppendText( "ComboBox event selection string is: " )
        @m_text.AppendText( event.GetString() )
        @m_text.AppendText( "\n" )
        @m_text.AppendText( "ComboBox control selection string is: " )
        @m_text.AppendText( @m_combo.GetStringSelection() )
        @m_text.AppendText( "\n" )
    end

    def OnComboTextChanged(event)
        str = sprintf( "Text in the combobox changed: now is '%s'.",
                    event.GetString())
        WxLogMessage( str )
    end

    def OnComboTextEnter(event)
        WxLogMessage("Enter pressed in the combobox: value is '%s'.",
                     @m_combo.GetValue())
    end

    def OnComboButtons(event)
        case event.GetId()
            when ID_COMBO_ENABLE
                    @m_combo.Enable( event.GetInt() == 0 )
            when ID_COMBO_SEL_NUM
                    @m_combo.SetSelection( 2 )
            when ID_COMBO_SEL_STR
                    @m_combo.SetStringSelection( "This" )
            when ID_COMBO_CLEAR
                    @m_combo.Clear()
            when ID_COMBO_APPEND
                    @m_combo.Append( "Hi!" )
            when ID_COMBO_DELETE
                    idx = @m_combo.GetSelection()
                    @m_combo.Delete( idx )
            when ID_COMBO_FONT
                    @m_combo.SetFont( WxITALIC_FONT )
        end
    end

    def OnRadio(event)
        @m_text.AppendText( "RadioBox selection string is: " )
        @m_text.AppendText( event.GetString() )
        @m_text.AppendText( "\n" )
    end

    def OnRadioButtons(event)
        case event.GetId()
            when ID_RADIOBOX_ENABLE
                    @m_radio.Enable( event.GetInt() == 0 )
            when ID_RADIOBOX_SEL_NUM
                    @m_radio.SetSelection( 2 )
            when ID_RADIOBOX_SEL_STR
                    @m_radio.SetStringSelection( "This" )
            when ID_RADIOBOX_FONT
                    @m_radio.SetForegroundColour(WxGREEN)
                    @m_radio.SetFont( WxITALIC_FONT )
        end
    end

    def OnSetFont(event)
        @m_fontButton.SetFont( WxITALIC_FONT )
        @m_text.SetFont( WxITALIC_FONT )
    end

    def OnUpdateLabel(event)
        @m_label.SetLabel(event.GetInt() != 0 ? "Very very very very very long text." : "Shorter text.")
    end

    def OnSliderUpdate(event)
        @m_gauge.SetValue( @m_slider.GetValue() )
        @m_gaugeVert.SetValue( @m_slider.GetValue() / 2 )
    end


    def OnSpinCtrlText(event)
        if @m_spinctrl
            s = sprintf( "Spin ctrl text changed: now %d (from event: %s)\n",
                     @m_spinctrl.GetValue(), event.GetString() )
            @m_text.AppendText(s)
        end
    end

    def OnSpinCtrl(event)
        if @m_spinctrl
            s = sprintf( "Spin ctrl changed: now %d (from event: %d)\n",
                     @m_spinctrl.GetValue(), event.GetInt() )
            @m_text.AppendText(s)
        end
    end

    def OnSpinCtrlUp(event)
        if @m_spinctrl
            @m_text.AppendText( sprintf(
                "Spin up: %d (from event: %d)\n",
                @m_spinctrl.GetValue(), event.GetInt() ) )
        end
    end

    def OnSpinCtrlDown(event)
        if @m_spinctrl
            @m_text.AppendText( sprintf(
                "Spin down: %d (from event: %d)\n",
                @m_spinctrl.GetValue(), event.GetInt() ) )
        end
    end


    def OnSpinUp(event)
        value = sprintf( "Spin control up: current = %d\n",
                     @m_spinbutton.GetValue())

        if event.GetPosition() > 17
            value += "Preventing the spin button from going above 17.\n"
            event.Veto()
        end

        @m_text.AppendText(value)
    end

    def OnSpinDown(event)
        value = sprintf( "Spin control down: current = %d\n",
                     @m_spinbutton.GetValue())

        if event.GetPosition() < -17
            value += "Preventing the spin button from going below -17.\n"
            event.Veto()
        end

        @m_text.AppendText(value)
    end

    def OnSpinUpdate(event)
        value = sprintf( "%d", event.GetPosition() )
        @m_spintext.SetValue( value )

        value = sprintf( "Spin control range: (%d, %d), current = %d\n",
                     @m_spinbutton.GetMin(), @m_spinbutton.GetMax(),
                     @m_spinbutton.GetValue())

        @m_text.AppendText(value)
    end

    def OnUpdateShowProgress(event)
        event.Enable( @m_spinbutton.GetValue() > 0 )
    end

    def OnShowProgress(event)
        max = @m_spinbutton.GetValue()
        if max <= 0
            WxLogError("You must set positive range!")
            return Qnil
        end

        dialog = WxProgressDialog.new("Progress dialog example",
                                "An informative message",
                                max,    # range
                                self,   # parent
                                WxPD_CAN_ABORT |
                                WxPD_AUTO_HIDE |
                                WxPD_APP_MODAL |
                                WxPD_ELAPSED_TIME |
                                WxPD_ESTIMATED_TIME |
                                WxPD_REMAINING_TIME)

        cont = TRUE
        0.upto(max) {|i|
            break if !cont
            sleep(1)
            if i == max
                cont = dialog.Update(i, "That's all, folks!")
            elsif i == max / 2
                cont = dialog.Update(i, "Only a half left (very long message)!")
            else
                cont = dialog.Update(i)
            end
        }
    	dialog.Destroy()
        if !cont
            @m_text << "Progress dialog aborted!\n"
        else
            @m_text << "Countdown from " << max << " finished.\n"
        end
    end

    def OnSizerCheck(event)
        case event.GetId()
          when ID_SIZER_CHECK1
            @m_buttonSizer.Show(@m_sizerBtn1, event.IsChecked())
            @m_buttonSizer.Layout()
          when ID_SIZER_CHECK2
            @m_buttonSizer.Show(@m_sizerBtn2, event.IsChecked())
            @m_buttonSizer.Layout()
          when ID_SIZER_CHECK3
            @m_buttonSizer.Show(@m_sizerBtn3, event.IsChecked())
            @m_buttonSizer.Layout()
          when ID_SIZER_CHECK4
            @m_buttonSizer.Show(@m_sizerBtn4, event.IsChecked())
            @m_buttonSizer.Layout()
          when ID_SIZER_CHECK14
            @m_hsizer.Show(@m_buttonSizer, event.IsChecked())
            @m_hsizer.Layout()
          when ID_SIZER_CHECKBIG
            @m_hsizer.Show(@m_bigBtn, event.IsChecked())
            @m_hsizer.Layout()
        end
    end
end


class MyFrame < WxFrame
    def initialize(title,x,y)
        super(nil, -1, title, WxPoint.new(x, y), WxSize.new(500, 430))

        @s_delay = 5000
        @s_enabled = TRUE
        @s_enable2 = TRUE
        @s_windowFocus = nil

        SetIcon(WxIcon.new("mondrian.xpm"))

        file_menu = WxMenu.new

        file_menu.Append(CONTROLS_CLEAR_LOG, "&Clear log\tCtrl-L")
        file_menu.AppendSeparator()
        file_menu.Append(CONTROLS_ABOUT, "&About\tF1")
        file_menu.AppendSeparator()
        file_menu.Append(CONTROLS_QUIT, "E&xit\tAlt-X", "Quit controls sample")

        menu_bar = WxMenuBar.new
        menu_bar.Append(file_menu, "&File")

        tooltip_menu = WxMenu.new
        tooltip_menu.Append(CONTROLS_SET_TOOLTIP_DELAY, "Set &delay\tCtrl-D")
        tooltip_menu.AppendSeparator()
        tooltip_menu.Append(CONTROLS_ENABLE_TOOLTIPS, "&Toggle tooltips\tCtrl-T",
                "enable/disable tooltips", WxITEM_CHECK)
        tooltip_menu.Check(CONTROLS_ENABLE_TOOLTIPS, TRUE)
        menu_bar.Append(tooltip_menu, "&Tooltips")

        panel_menu = WxMenu.new
        panel_menu.Append(CONTROLS_ENABLE_ALL, "&Disable all\tCtrl-E",
                           "Enable/disable all panel controls", WxITEM_CHECK)
        menu_bar.Append(panel_menu, "&Panel")

        SetMenuBar(menu_bar)

        CreateStatusBar(2)

        @m_panel = MyPanel.new( self, 10, 10, 300, 100 )

        SetSizeHints( 500, 425 )

        EVT_MENU(self,CONTROLS_QUIT,   "OnQuit")
        EVT_MENU(self,CONTROLS_ABOUT,  "OnAbout")
        EVT_MENU(self,CONTROLS_CLEAR_LOG,  "OnClearLog")
        EVT_MENU(self,CONTROLS_SET_TOOLTIP_DELAY,  "OnSetTooltipDelay")
        EVT_MENU(self,CONTROLS_ENABLE_TOOLTIPS,  "OnToggleTooltips")
        EVT_MENU(self,CONTROLS_ENABLE_ALL, "OnEnableAll")

        EVT_SIZE(self,"OnSize")
        EVT_MOVE(self,"OnMove")
        EVT_IDLE(self,"OnIdle")
        EVT_CLOSE(self,"OnClose")
    end

    def OnClose(event)
        WxLog::SetActiveTarget(@m_panel.m_logTargetOld)
        Destroy()
    end

    def OnQuit(event)
        Close(TRUE)
    end

    def OnAbout(event)
        bc = WxBusyCursor.new
        dialog = WxMessageDialog.new(self, "This is a control sample", "About Controls", WxOK )
        dialog.ShowModal()
        bc.free
    end

    def OnClearLog(event)
        @m_panel.m_text.Clear()
    end

    def OnSetTooltipDelay(event)
        delay = @s_delay.to_s

        delay = WxGetTextFromUser("Enter delay (in milliseconds)",
                "Set tooltip delay",
                delay,
                self)
        if !delay
            return Qnil # cancelled
        end

        @s_delay = delay.to_i

        WxToolTip::SetDelay(@s_delay)

        WxLogStatus(self, "Tooltip delay set to %d milliseconds", @s_delay)
    end

    def OnToggleTooltips(event)
        @s_enabled = ! @s_enabled
        WxToolTip::Enable(@s_enabled)
        WxLogStatus(self, "Tooltips %sabled", @s_enabled ? "en" : "dis" )
    end

    def OnEnableAll(event)
        @s_enable2 = ! @s_enable2
        @m_panel.Enable(@s_enable2)
    end

    def OnMove(event)
        UpdateStatusBar(event.GetPosition(), GetSize())
        event.Skip()
    end

    def OnSize(event)
        UpdateStatusBar(GetPosition(), event.GetSize())
        event.Skip()
    end

    def OnIdle(event)

        # track the window which has the focus in the status bar
        focus = WxWindow::FindFocus()
        if focus && (focus != @s_windowFocus)

            @s_windowFocus = focus

            if WxRUBY_PLATFORM=="WXMSW"
                msg = sprintf(
                    "Focus: %s, HWND = %08x",
                    @s_windowFocus.GetClassInfo().GetClassName(),
                    @s_windowFocus.GetHWND()
                      )
            else
                msg = sprintf(
                    "Focus: %s",
                    @s_windowFocus.GetClassInfo().GetClassName()
                      )
            end
            SetStatusText(msg)
        end
    end

    def GetPanel()
        @m_panel
    end

    def UpdateStatusBar(pos,size)
        if GetStatusBar()
            sizeAll = GetSize()
            sizeCl = GetClientSize()
            msg = sprintf("pos=(%d, %d), size=%dx%d or %dx%d (client=%dx%d)",
                       pos.x, pos.y,
                       size.x, size.y,
                       sizeAll.x, sizeAll.y,
                       sizeCl.x, sizeCl.y)
            SetStatusText(msg, 1)
        end
    end

end

class MyApp < WxApp
    def OnInit()
        # parse the cmd line
        x = 50
        y = 50
        # Create the main frame window
        frame = MyFrame.new("Controls WxWindows App", x, y)
        frame.Show(TRUE)
    end
end

a = MyApp.new
a.MainLoop()


