require 'wx'
include Wx


# IDs for the controls and the menu commands
ID_Quit = WxID_HIGHEST
ID_Logs = WxID_HIGHEST + 1
ID_Browser = WxID_HIGHEST + 2
ID_PlugProvider = WxID_HIGHEST + 3


def FillClients(choice)
    choice.Append("WxART_OTHER",WxART_OTHER)
    choice.Append("WxART_TOOLBAR",WxART_TOOLBAR)
    choice.Append("WxART_MENU",WxART_MENU)
    choice.Append("WxART_FRAME_ICON",WxART_FRAME_ICON)
    choice.Append("WxART_CMN_DIALOG",WxART_CMN_DIALOG)
    choice.Append("WxART_HELP_BROWSER",WxART_HELP_BROWSER)
    choice.Append("WxART_MESSAGE_BOX",WxART_MESSAGE_BOX)
end

def FillBitmaps(images,list,index,client,size)
    icon = WxArtProvider::GetIcon(WxART_ERROR, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_ERROR",ind)
    list.SetItemData(index,WxART_ERROR)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_QUESTION, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_QUESTION",ind)
    list.SetItemData(index,WxART_QUESTION)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_WARNING, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_WARNING",ind)
    list.SetItemData(index,WxART_WARNING)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_INFORMATION, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_INFORMATION",ind)
    list.SetItemData(index,WxART_INFORMATION)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_ADD_BOOKMARK, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_ADD_BOOKMARK",ind)
    list.SetItemData(index,WxART_ADD_BOOKMARK)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_DEL_BOOKMARK, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_DEL_BOOKMARK",ind)
    list.SetItemData(index,WxART_DEL_BOOKMARK)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_HELP_SIDE_PANEL, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_HELP_SIDE_PANEL",ind)
    list.SetItemData(index,WxART_HELP_SIDE_PANEL)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_HELP_SETTINGS, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_HELP_SETTINGS",ind)
    list.SetItemData(index,WxART_HELP_SETTINGS)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_HELP_BOOK, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_HELP_BOOK",ind)
    list.SetItemData(index,WxART_HELP_BOOK)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_HELP_FOLDER, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_HELP_FOLDER",ind)
    list.SetItemData(index,WxART_HELP_FOLDER)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_HELP_PAGE, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_HELP_PAGE",ind)
    list.SetItemData(index,WxART_HELP_PAGE)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_GO_BACK, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_GO_BACK",ind)
    list.SetItemData(index,WxART_GO_BACK)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_GO_FORWARD, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_GO_FORWARD",ind)
    list.SetItemData(index,WxART_GO_FORWARD)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_GO_UP, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_GO_UP",ind)
    list.SetItemData(index,WxART_GO_UP)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_GO_DOWN, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_GO_DOWN",ind)
    list.SetItemData(index,WxART_GO_DOWN)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_GO_TO_PARENT, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_GO_TO_PARENT",ind)
    list.SetItemData(index,WxART_GO_TO_PARENT)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_GO_HOME, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_GO_HOME",ind)
    list.SetItemData(index,WxART_GO_HOME)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_FILE_OPEN, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_FILE_OPEN",ind)
    list.SetItemData(index,WxART_FILE_OPEN)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_PRINT, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_PRINT",ind)
    list.SetItemData(index,WxART_PRINT)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_HELP, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_HELP",ind)
    list.SetItemData(index,WxART_HELP)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_TIP, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_TIP",ind)
    list.SetItemData(index,WxART_TIP)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_REPORT_VIEW, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_REPORT_VIEW",ind)
    list.SetItemData(index,WxART_REPORT_VIEW)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_LIST_VIEW, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_LIST_VIEW",ind)
    list.SetItemData(index,WxART_LIST_VIEW)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_NEW_DIR, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_NEW_DIR",ind)
    list.SetItemData(index,WxART_NEW_DIR)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_FOLDER, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_FOLDER",ind)
    list.SetItemData(index,WxART_FOLDER)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_GO_DIR_UP, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_GO_DIR_UP",ind)
    list.SetItemData(index,WxART_GO_DIR_UP)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_EXECUTABLE_FILE, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_EXECUTABLE_FILE",ind)
    list.SetItemData(index,WxART_EXECUTABLE_FILE)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_NORMAL_FILE, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_NORMAL_FILE",ind)
    list.SetItemData(index,WxART_NORMAL_FILE)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_TICK_MARK, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_TICK_MARK",ind)
    list.SetItemData(index,WxART_TICK_MARK)
    index += 1

    icon = WxArtProvider::GetIcon(WxART_CROSS_MARK, client, size)
    ind = icon.Ok ? images.AddIcon(icon) : 0
    list.InsertItem(index,"WxART_CROSS_MARK",ind)
    list.SetItemData(index,WxART_CROSS_MARK)
    index += 1

end

class WxArtBrowserDialog < WxDialog

  def initialize(parent)
    super(parent, -1, "Art resources browser",
               WxDefaultPosition, WxDefaultSize,
               WxDEFAULT_DIALOG_STYLE|WxRESIZE_BORDER)
    sizer = WxBoxSizer.new(WxVERTICAL)

    choice = WxChoice.new(self, -1)
    FillClients(choice)

    subsizer = WxBoxSizer.new(WxHORIZONTAL)
    subsizer.Add(WxStaticText.new(self, -1, "Client:"), 0, WxALIGN_CENTER_VERTICAL)
    subsizer.Add(choice, 1, WxLEFT, 5)
    sizer.Add(subsizer, 0, WxALL | WxEXPAND, 10)

    subsizer = WxBoxSizer.new(WxHORIZONTAL)

    @m_list = WxListCtrl.new(self, -1, WxDefaultPosition, WxSize.new(250, 300),
                            WxLC_REPORT | WxSUNKEN_BORDER)
    @m_list.InsertColumn(0, "WxArtID")
    subsizer.Add(@m_list, 1, WxEXPAND | WxRIGHT, 10)

    subsub = WxBoxSizer.new(WxVERTICAL)
    @m_canvas = WxStaticBitmap.new(self, -1, WxBitmap.new("null.xpm"))
    subsub.Add(@m_canvas)
    subsub.Add(100, 100)
    subsizer.Add(subsub)

    sizer.Add(subsizer, 1, WxEXPAND | WxLEFT|WxRIGHT, 10)

    ok = WxButton.new(self, WxID_OK, "Close")
    ok.SetDefault
    sizer.Add(ok, 0, WxALIGN_RIGHT | WxALL, 10)

    SetSizer(sizer)
    SetAutoLayout(TRUE)
    sizer.Fit(self)

    choice.SetSelection(6)
    SetArtClient(WxART_MESSAGE_BOX)

    EVT_LIST_ITEM_SELECTED(self,-1, "OnSelectItem")
    EVT_CHOICE(self,-1, "OnChooseClient")

  end

  def SetArtClient(client)
    img = WxImageList.new(16, 16)
    img.AddIcon(WxIcon.new("null.xpm"))
    index = 0

    @m_list.DeleteAllItems
    FillBitmaps(img, @m_list, index, client, WxSize.new(16, 16))
    @m_list.AssignImageList(img, WxIMAGE_LIST_SMALL)
    @m_list.SetColumnWidth(0, WxLIST_AUTOSIZE)

    @m_client = client

  end

  def OnSelectItem(event)
    data = event.GetData
    bmp = WxArtProvider::GetBitmap(data, @m_client)
    @m_canvas.SetBitmap(bmp)
    @m_canvas.SetSize(bmp.GetWidth, bmp.GetHeight)
  end

  def OnChooseClient(event)
    data = event.GetClientData
    SetArtClient(data)
  end

end

class MyApp < WxApp
  def OnInit()
    # create the main application window
    frame = MyFrame.new("WxArtProvider sample",
                                 WxPoint.new(50, 50), WxSize.new(450, 340))
    frame.Show(TRUE)
  end
end

class MyFrame < WxFrame
  def initialize(title,pos,size,style = WxDEFAULT_FRAME_STYLE)
    super(nil, -1, title, pos, size, style)

    if WxRUBY_PLATFORM == "WXMSW"
      SetIcon(WxIcon.new("mondrian.ico",WxBITMAP_TYPE_ICO))
    else
      SetIcon(WxIcon.new("mondrian.xpm",WxBITMAP_TYPE_XPM))
    end

    # create a menu bar
    menuFile = WxMenu.new

    # the "About" item should be in the help menu
    helpMenu = WxMenu.new
    helpMenu.Append(WxID_ABOUT, "&About...\tF1", "Show about dialog")

    menuFile.AppendCheckItem(ID_PlugProvider, "&Plug-in art provider", "Enable custom art provider")
    menuFile.AppendSeparator

    menuFile.Append(ID_Logs, "&Logging test", "Show some logging output")
    menuFile.Append(ID_Browser, "&Resources browser", "Browse all available icons")
    menuFile.AppendSeparator

    menuFile.Append(ID_Quit, "E&xit\tAlt-X", "Quit this program")

    # now append the freshly created menu to the menu bar...
    menuBar = WxMenuBar.new
    menuBar.Append(menuFile, "&File")
    menuBar.Append(helpMenu, "&Help")

    # ... and attach this menu bar to the frame
    SetMenuBar(menuBar);

    EVT_MENU(self,ID_Quit,         "OnQuit")
    EVT_MENU(self,ID_Logs,         "OnLogs")
    EVT_MENU(self,WxID_ABOUT,      "OnAbout")
    EVT_MENU(self,ID_Browser,      "OnBrowser")
    EVT_MENU(self,ID_PlugProvider, "OnPlugProvider")
  end

  # event handlers (these functions should _not_ be virtual)
  def OnQuit(event)
    # TRUE is to force the frame to close
    Close(TRUE)
  end

  def OnAbout(event)
    msg = sprintf( "This is the about dialog of WxArtProvider sample.\n" \
                "Welcome to %s", WxVERSION_STRING)

    WxMessageBox(msg, "About WxArtProvider sample",
        WxOK | WxICON_INFORMATION, self)
  end

  def OnLogs(event)
    WxLogMessage("Some information.")
    WxLogError("This is an error.")
    WxLogWarning("A warning.")
    WxLogError("Yet another error.")
    WxLog::GetActiveTarget().Flush
    WxLogMessage("Check/uncheck 'File/Plug-in art provider' and try again.")
  end

  def OnBrowser(event)
    dlg = WxArtBrowserDialog.new(self)
    dlg.ShowModal
  end

  def OnPlugProvider(event)
    if event.IsChecked
        WxArtProvider::PushProvider(MyArtProvider.new)
    else
        WxArtProvider::PopProvider()
    end
  end

end

class MyArtProvider < WxArtProvider
  def CreateBitmap(id,client,size)
    if client == WxART_MESSAGE_BOX
        if id == WxART_INFORMATION
            return WxBitmap.new("info.xpm")
        end
        if id == WxART_ERROR
            return WxBitmap.new("error.xpm")
        end
        if id == WxART_WARNING
            return WxBitmap.new("warning.xpm")
        end
        if id == WxART_QUESTION
            return WxBitmap.new("question.xpm")
        end
    end
    return WxNullBitmap
  end
end

a = MyApp.new
a.MainLoop

