var bolls = [];
var padd = null;
var blocks = [];
var canvas = null;
var isTicker = false;

function start() {
	var img = document.createElement("img");
	img.src = "boll.png";
	img.className = "boll";
	canvas.appendChild(img);
	var boll = bollThread(img);
	bolls.push(boll);
	if (!isTicker) ticker();
}
function ticker() {
	isTicker = true;
	setTimeout(ticker, 20);
	for (var i=0; i<bolls.length; i++) {
		if (bolls[i] != null) {
			try {
				bolls[i].next();
			} catch (e) {
				bolls[i] = null;
			}
		}
	}
}

function init() {
	canvas =	document.getElementById("canvas");
	for (var y=0; y<6; y++) {
		var start = (y >= 5) ? 0 : 1;
		var end   = (y >= 5) ? 12 : 11;
		for (var x=start; x<end; x++) {
			var div = document.createElement("div");
			blocks.push(div);
			canvas.appendChild(div);
			div.className = "block";
			div.x1 = (x * 32);
			div.y1 = (y * 16 + 32);
			div.x2 = div.x1+32;
			div.y2 = div.y1+16;
			div.style.left = div.x1+ "px";
			div.style.top  = div.y1+ "px";
		}
	}

	padd =	document.getElementById("padd");
	padd.y1 = 420;
	padd.y2 = padd.y1+24;
	padd.x1 = 0;
	padd.x2 = padd.x1+48;

}
function getHitPosition(x,y) {
	for (var i=0; i<blocks.length; i++) {
		var b = blocks[i];
		if (b == null) continue;
		var pos = getHitPos(b, x,y);
		if (pos != null) {
			b.style.display = "none";
			blocks[i] = null;
			return pos;
		}
	}
	var pos = getHitPos(padd, x,y);
	if (pos == "W" || pos == "E") pos = "P"+pos;
	return pos;
}
function getHitPos(b,x,y) {
	if (isHit(b, x,    y+7 )) return "W";
	if (isHit(b, x+15, y+7 )) return "E";
	if (isHit(b, x+7,  y   )) return "N";
	if (isHit(b, x+7,  y+15)) return "S";

	if (isHit(b, x+3,  y+3 )) return "NW";
	if (isHit(b, x+12, y+3 )) return "NE";
	if (isHit(b, x+3,  y+12)) return "SW";
	if (isHit(b, x+12, y+12)) return "SE";

	return null;
}

function isHit(b,x,y) {
	return b.x1 < x && x < b.x2 && b.y1 < y && y < b.y2;
}

function movePadd(ev) {
	padd.x1 = ev.clientX - 20;
	padd.x2 = padd.x1+48;
	padd.style.left = padd.x1+ "px";
}
