//---------------------------------------------------------------------------
// Plugin
//---------------------------------------------------------------------------

Wiki.plugins = {};
Wiki.plugins.contents = function(parser, params, line) {
	return new WOM(parser,{
		type:'plugin',
		toHtml: function(){
			var anums = parser.anums;
			if (anums.length == 0) return "";
			var html = "<div class='contents'>";
			for (var i=0; i<anums.length; i++) {
				if (anums[i].wom.level <= 3) {
					html += "<div style='text-indent:"+(anums[i].wom.level)+"em;'>"
					html += "<a href='#"+anums[i].anum+"'>"
						+anums[i].wom.getBody() +"</a></div>\n";
				}
			}
			return html+"</div>";
		}
	});
}
Wiki.plugins.anum = function(parser, params, line) {
	return new WOM(parser,{
		type:'plugin',
		onParse: function(){
			var param = params.split(",");
			for (var i=0; i<param.length || i<4; i++) {
				parser.anum[i] = param[i];
			}
		}
	});
}
Wiki.plugins.title = function(parser, params, line) {
	return new WOM(parser,{
		type:'plugin',
		toHtml: function(){
			var param = params.split(",");
			return	""
				+"<div align='right'>"+param[1]+"</div>\n"
				+"<div align='right'>"+param[2]+"</div>\n"
				+"<div align='center'><h1>"+param[0]+"</h1></div>\n"
			;
		}
	});
}


Wiki.plugins.include = function(parser, params, line) {
	return new WOM(parser,{
		type:'plugin',
		toHtml: function(){
			var wiki = new Wiki(Wiki.getWikiText(params));
			var root = wiki.parse();
			return root.toHtml();
		}
	});
}
Wiki.plugins.javascript = function(parser, params, line) {
	return new WOM(parser,{
		type:'plugin',
		toHtmlBlock: function(){
			var html = "\n<script type='text/javascript'>\n";
			for (var i=0; i<this.children.length; i++) {
				html += this.children[i].body+"\n";
			}
			html	+= "</script>\n"
			return html;
		}
	});

}
Wiki.plugins.pre = function(parser, params, line) {
	return new WOM(parser,{
		type:'plugin', isRawBody:true,
		toHtmlBlock: function(){
			var html = "\n<pre>";
			for (var i=0; i<this.children.length; i++) {
				html += this.preText(this.children[i].body)+"\n";
			}
			html	+= "</pre>\n"
			return html;
		}
	});
}
Wiki.plugins.html = function(parser, params, line) {
	return new WOM(parser,{
		type:'plugin',  isEnableHtml:true
	});
}
Wiki.plugins.blockquote = function(parser, params, line) {
	return new WOM(parser,{
		type:'plugin',
		toHtmlBlock: function(){
			var html = "<blockquote>";
			for (var i=0; i<this.children.length; i++) {
				if (i>0) html += "\n";
				html += this.children[i].toHtml();
			}
			html	+= "</blockquote>"
			return html;
		}
	});
}

Wiki.plugins.img = function(parser, params, line) {
	return new WOM(parser,{
		type:'plugin',
		toHtml: function(){
			var param = params.split(",");
			var html = "<img src='"+param[0]+"'";
			if (param[1]) html += " alt='"+param[1]+"'";
			if (param[2]) html += " width='"+param[2]+"'";
			if (param[3]) html += " height='"+param[3]+"'";
			if (param[4]) html += " "+param[4];
			html += "/>";
			return html;
		}
	});
}

Wiki.plugins.exlink = function(parser, params, line) {
	return new WOM(parser,{
		type:'plugin',
		toHtml: function(){
			var param = params.split(",");
			var html = 
				"<a target='_blank' href='"+param[1]+"'>"
				+param[0]+"</a>";
			return html;
		}
	});
}

Wiki.plugins.drawing = function(parser, params, line) {
	return new WOM(parser,{
		type:'plugin',
		toHtml: function(){
			var param = params.split(",");
			var req = new XMLHttpRequest();
			req.open('GET', param[0], false); 
			req.send(null);
			var name = param[1];
			if (name == null) name = "drawing-"+(parser.drawing++);
			var html =
			 "<div id='"+name+"'  style='position:relative;height:50%;'>"
				+"<script type='text/javascript'>"
					+"var jg = new jsGraphics('"+name+"');"
					+"with (jg) {"	+req.responseText +"}"
					+"jg.paint();"
				+"</script>"
			+"</div>";
			return html;
		}
	});
}

Wiki.plugins.search = function(parser, params, line) {
	return new WOM(parser,{
		type:'plugin',
		toHtml: function(){
			var param = params.split(",");
			var dirName = "";
			var key = param[0];
			var isRecu = (param.length>=2) ? param[1] : true;
			var list = SsjsWiki.search("/wiki/","",key,isRecu);
			var html = "<ul>\n"
			for (var i=0; i<list.length; i++) {
				var name = list[i].name;
				var date = Wiki.Util.formatDate(new Date(list[i].date));
				html += "<li>"
					+"<a onclick='Wiki.manager.reload(\""+dirName+name+"\")'>"+name+"</a>"
					+"<spam style='float:right;'>("+date+")</span>";
					+"</li>";
			}
			html += "</ul>\n";
			return html;
		}
	});
}

Wiki.plugins.recent = function(parser, params, line) {
	return new WOM(parser,{
		type:'plugin',
		toHtml: function(){
			var count = params;
			var list = SsjsWiki.recent("/wiki/", count);
			var html = "<div>\n";
			var lastDate = "";
			for (var i=0; i<list.length; i++) {
				var name = list[i].name;
				var date = Wiki.Util.formatDate(new Date(list[i].date),"YY/MM/DD");
				if (date != lastDate) {
					html += "<div><b>"+date+"</b></div>";
					lastDate = date;
				}
				html += "<div style='padding-left:1em;'><a onclick='Wiki.manager.reload(\""+name+"\")'>"+name+"</a></div>";
			}
			html += "</div>\n";
			return html;
		}
	});
}

Wiki.plugins.dirList = function(parser, params, line) {
	return new WOM(parser,{
		type:'plugin',
		toHtml: function(){
			var param = params.split(",");
			var dirName = param[0];
			var isRecu = (param.length>=2) ? param[1] : false;

			var list = SsjsWiki.dirList("/wiki/",dirName,isRecu);

			var html = "<ul>\n"
			for (var i=0; i<list.length; i++) {
				var name = list[i].name;
				var date = Wiki.Util.formatDate(new Date(list[i].date));
				html += "<li>"
					+"<a onclick='Wiki.manager.reload(\""+dirName+name+"\")'>"+name+"</a>"
					+"<spam style='float:right;'>("+date+")</span>";
					+"</li>";
			}
			html += "</ul>\n";
			return html;
		}
	});
}
Wiki.plugins.includePlain = function(parser, params, line) {
	return new WOM(parser,{
		type:'plugin',
		toHtml: function(){
			var param = params.split(/,/);
			var text = Wiki.getWikiText(param[0]);
			return "<xmp style='"+param[1]+"'>"+text+"</xmp>";
		}
	});
}
Wiki.plugins.iframe = function(parser, params, line) {
	return new WOM(parser,{
		type:'plugin',
		toHtml: function(){
			var param = params.split(/,/);
			var width  = "100%";
			var height = "200px";
			if (param[1]) width = param[1];
			if (param[2]) height = param[2];
			return "<iframe width='"+width+"' height='"+height
							+"' src='"+param[0]+"'></iframe>";
		}
	});
}

//-----------------------------------------------------------------------------
// EOF
//-------------------------------------------------------------------------------
