if(typeof ActiveXObject == "function" 
	&& typeof XMLHttpRequest == "undefined"){
    XMLHttpRequest = function(){
        return new ActiveXObject("Microsoft.XMLHTTP")
    }
}
unescapePageName = unescape;

//---------------------------------------------------------------------------
// WOM : Wiki Object Model : Wikiテキストを木構造で持つ為のクラス。
//---------------------------------------------------------------------------
function WOM(parser, params) {
	this.parser = parser;
	for (key in params) this[key] = params[key];
}
WOM.prototype.preText = function(body) {
	body = body.replace(/&/g, "&amp;");
	body = body.replace(/</g, "&lt;");
	body = body.replace(/>/g, "&gt;");
	return body;
}
WOM.prototype.getBody = function(body) {
	if (!body) body = this.body;
	if (body == null) return "";
	if (!this._isEnableHtml()) {
		body = body.replace(/</g, "&lt;");
		body = body.replace(/>/g, "&gt;");
	}

	body = body.replace(/&size\(([0-9]+)\)\{(.*)\};/g,
			"<span style='font-size:$1px;'/>$2</span>");
	body = body.replace(/%%(.*)%%/g, "<S/>$1</S>");
	body = body.replace(/'''(.*)'''/g, "<I/>$1</I>");
	body = body.replace(/''(.*)''/g, "<B/>$1</B>");

	body = body.replace(/&br;/g, "<br/>");
	if (this.anum) {
		body = body.replace("&anum;", this.anum);
	}

	var parser = this.parser;
	var matchs = body.match(); 
	body = body.replace(/\(\((.*)\)\)/g, function(str,$1) {
		var name = "(*"+(parser.annotate.length+1)+")";
		var view = "<font size='1'><sup>"+name+"</sup></font>";
		parser.annotate.push("<a name='"+name+"'></a>"+view+$1);
		return "<a href='#"+name+"'>"+view+"</a>";
	});

	body = body.replace(/\[\[([^:\]]*):([^\]]*)\]\]/g, function(str, $1, $2) {
		if ($1 == "http" || $1 == "https" || $1 == "ftp") {
			$1 = $1+":"+$2;
			$2 = $1;
		}
		if ($2 == "#") {
			var anums = parser.anums;
			for (var i=0; i<anums.length; i++) {
				var title = anums[i].wom.body.replace(/(&anum;)/,"");
				title = title.replace(/(^[ ]*)|([ ]*$)/g,"");
				if (title == $1) $2 = "#"+anums[i].anum;
			}
		}
		return "<a href='"+$2+"'>"+$1+"</a>";
	});

	body = body.replace(/\[\[([^\]]*)\]\]/g, "<a href='?$1'>$1</a>");
	body = body.replace(/~$/, "<br/>");

	// Plugin
	body = body.replace(/&([a-zA-Z_][a-zA-Z0-9_]*)\(([^)]*)\)({[^}]*})?;/g, function(str,$1,$2,$3) {
		if (Wiki.plugins[$1]) {
			return Wiki.plugins[$1](parser, $2, str).toHtml();
		} else {
			return str;
		}
	});

	return body;
}
WOM.prototype.toHtml = function() {
	var html = this.getBody();
	if (this.unitTag) {
		html = this.unitTag[0]+html+this.unitTag[1];
	}
//this.parser.log += "\n-->"+this._getParens()+":"+html+":"+this.body;
	return html;
}

WOM.prototype.toHtmlBlock = function() {
//this.parser.log += "\n==>"+this._getParens()+":"+this.body;
	var html = [];
	if (this.blockTag) html.push(this.blockTag[0]);
	for (var i=0; i<this.children.length; i++) {
		html.push(this.children[i].toHtml());
	}
	if (this.blockTag) html.push(this.blockTag[1]);
	return html.join("");
}
WOM.prototype._isEnableHtml = function() {
	var wom = this;
	while (wom != null) {
		if (wom.isEnableHtml) return true;
		wom = wom.parent;
	}
	return false;
}
WOM.prototype.isBreaker = function(parent) {
	if (!this.breakIt || !parent.type) return false;
	//console.log(this.type+":"+parent.type+"="+(this.breakIt.indexOf(parent.type) >= 0));
	return (this.breakIt.indexOf(parent.type) >= 0);
}
WOM.prototype._getParens = function() {
	var str = ""
	var wom = this;
	while (wom != null) {
		str = wom.type+">"+str;
		wom = wom.parent;
	}
	return str;
}

//---------------------------------------------------------------------------
// Wiki parser
//---------------------------------------------------------------------------
function Wiki(wikiText) {
	wikiText = wikiText.replace(/<\?xml .*\?>\r?\n/g, "");
	//wikiText = wikiText.replace(/[~]\r?\n/g, "&br;");
	this.wikiText = wikiText;
	this.lines = wikiText.split(/\r?\n/);
	this.anum = [0,0,0,0];
	this.anums = [];
	this.annotate = [];
	this.drawing = 1;
	this.log = "";
}

Wiki.prototype.parse = function() {
	var root = new WOM(this,{
		type:"root", level:-1, children:[], isBlock: true,
		blockTag: ["<div>","</div>"],
		toHtml: function() {
			this.parser.annotate = [];
			return this.toHtmlBlock() + this.parser.getAnnotateHtml();
		}
	});
	this._parse(root, 0);
	return root;
}
Wiki.prototype.getAnnotateHtml = function() {
	if (this.annotate.length == 0) return "";
	var html = "<hr/>";
	for (var i=0; i<this.annotate.length; i++) {
		html = html + "<div>"+this.annotate[i]+"</div>";
	}
	return html + "<hr/>";
}

Wiki.prototype._parse = function(parent, pos) {
	while (pos<this.lines.length) {
		var current = this.parseLine(parent, pos);
//console.log("--->"+current.type+":"+this.lines[pos]);
//this.log += "\n--->"+current.type+":"+this.lines[pos];
		var isBlockIn  = false;
		var isBlockOut = false;

		if (current.isChild) {
			if (parent.type == current.type) {
				if (parent.level < current.level) {
					isBlockIn = true;
				} else if (parent.level > current.level) {
					isBlockOut = true;
				}
			} else {
				if (current.isBreaker(parent)) {
					isBlockOut = true;
				} else {
					isBlockIn = true;
				}
			}
		} else if (current.isBegin) {
			isBlockIn = true;
			pos++;
		} else if (current.isEnd) {
			isBlockOut = true;
			if (parent.type == current.type) pos++;
		} else if (current.isBreaker(parent)) {
			isBlockOut = true;
		}


		if (isBlockIn) {
			var block = this._newBlock(parent, current);
			block.index = parent.children.length;
			parent.children.push(block);
			block.parent = parent;
			pos = this._parse(block, pos); // lines[pos]はブロック内で再処理
		} else if (isBlockOut) {
			return pos; //  lines[pos]は上位ブロックで再処理
		} else {
			if (current.anum != null) current.anum = this.getAnum(current); 
			current.index = parent.children.length;
			parent.children.push(current);
//for (var i=0; i<parent.children.length;i++) {
//	this.log+="\n=>"+i+":"+parent.children[i].body;
//}
			current.parent = parent;
			pos++;
			if (current.onParse) current.onParse();
		}

	}
}

/**
 * 行を解析して WOM インスタンスを返す。
 * WOM パラメータの意味
 *  type         : 行の属性
 *  level        : ブロックのネストレベル。 -:1 --:2 ---:3
 *  body         : 行の本文
 *  isBegin      : ブロックの開始。 #plugin(){
 *  isEnd        : プロックの終了。 #}
 *  isChild      : ブロックの子要素。必要に応じてブロックを生成する。 -,*
 *  isBrittle    : 弱いブロック。isBreaker によってブロックが中断される。
 *  isBreaker    : 弱いブロックを中断する。自身の属性のブロックは中断しない。
 *  isRawBody    : Plugin用。ブロック内を生テキストで取得する。
 *  isEnableHtml : ブロック内の HTML タグを有効にする。
 */

Wiki.prototype.parseLine = function(parent, pos) {
	if (pos >= this.lines.length) {
		return new WOM(this,{type:"EOF",body:"EOF", toHtml: function(){return "";}});
	}
	var line = this.lines[pos];

	// プラグインのブロック終端
	if (line.match(/^#\}/)) {
		return new WOM(this,{type:'plugin', isEnd:true});
	// プラグインブロック内の生テキスト。
	} else if (parent.isRawBody) {
		return new WOM(this,{type:'pre', level:0, body:line});
	// 整形済テキスト(pre)
	} else if (parent.isRawBody || line.match(/^[ \t]/)) {
		return new WOM(this,{
			type:'pre', level:0, body:line.substring(1), 
			isChild: true, breakIt:['plain','table','BQ'],
			toHtml: function(){return this.preText(this.body)+"\n";},
			blockTag: ["<pre>","</pre>"]
		});
	// 水平線
	} else if (line.match(/^-----------------*/)) {
		return new WOM(this,{
			type:'hline', level:0, isChild: false, breakIt:['plain','pre','table','BQ'],
			toHtml: function(){return "\n<hr/>\n";}
		});
	// リスト
	} else if (line.match(/^(-{1,16})/)) {
		return new WOM(this,{
			type:'list', level:RegExp.$1.length, body:RegExp.rightContext, 
			isChild: true, breakIt:['plain','pre','table','BQ'],
			unitTag: ["<li>","</li>"],	blockTag: ["<ul>","</ul>"]
		});
	// リスト番号付き
	} else if (line.match(/^([+]{1,16})/)) {
		return new WOM(this,{
			type:'list', level:RegExp.$1.length, body:RegExp.rightContext, 
			isChild: true, breakIt:['plain','pre','table','BQ'],
			unitTag: ["<li>","</li>"],	blockTag: ["<ol>","</ol>"]
		});
	// 見出し
	} else if (line.match(/^([*]{1,4})/)) {
		return new WOM(this,{
			type:'header', level:RegExp.$1.length, body:RegExp.rightContext,
			isChild: true, anum: "", breakIt:['plain','pre','list','term','table','BQ'],
			toHtml: function(){
				var tag = "h"+(this.level+1);
				return "<"+tag+"><a name='"+this.anum+"'></a>"+this.getBody()+"</"+tag+">\n";
			}
			//,blockTag: ["<div>","</div>"]
		});
	// 用語継続行
	} else if (line.match(/^(:{1,16})[|](.*)/)) {
		return new WOM(this,{
			type:'term', level:RegExp.$1.length, body:RegExp.$2,
			isChild: true, breakIt:['plain','pre','table','BQ'],
			toHtml: function(){return "<br/>"+this.getBody();}
		});
	// 用語
	} else if (line.match(/^(:{1,16})([^:|]+)[:|](.*)/)) {
		return new WOM(this,{
			type:'term', level:RegExp.$1.length, title:RegExp.$2, body:RegExp.$3,
			isChild: true, breakIt:['plain','pre','table','BQ'],
			toHtml: function(){return "<dt>"+this.title+":</dt><dd>"+this.getBody();},
			toHtmlBlock: function() {
				var html = "<dl>\n";
				for (var i=0; i<this.children.length; i++) {
					var child = this.children[i];
					if (i>0 && child.type == 'term' && child.isChild && child.title) {
						html += "</dd>"
					}
					html += child.toHtml();
				}
				return html +"</dl>\n";
			}
		});
	// テーブル
	} else if (line.match(/^[|]/)) {
		return new WOM(this,{
			type:'table', level:1, body:line, isChild: true, breakIt:['plain','pre','BQ'],
			toHtml: function(){
				var cells = this.body.split(/[|]/);
				var tag = 	(cells[cells.length-1] == "h") ? "th" : "td";
				var html = "<tr>";
				for (var i=1; i<cells.length-1; i++) {
					html += "<"+tag+">"+this.getBody(cells[i])+"</"+tag+">";
				}
				html += "</tr>\n";
				return html;
			},
			blockTag: ["<table class='style_table'>","</table>"]
		});
	// 引用
	} else if (line.match(/^(>{1,16})/)) {
		return new WOM(this,{
			type:'BQ', level:RegExp.$1.length, body:RegExp.rightContext, 
			isChild: true, breakIt:['plain','pre'],
			toHtml: function(){return this.getBody();},
			blockTag: ["<blockquote>","</blockquote>"]
		});
	// コメント
	} else if (line.match(/^\/\//)) {
		return new WOM(this,{
			type:'comment', level:0, isChild: false, breakIt:['pre'],
			unitTag: ["<!--","-->"]
		});
	// 空行
	} else if (line == "") {
		return new WOM(this,{
			type:'NIL', level:0, body:"NIL", isChild:false, 
			breakIt:['plain','pre','list','term','table','BQ'],
			toHtml: function(){return "\n";}
		});
	// プラグイン
	} else if (line.match(/^#([a-zA-Z_][^(]*)(\(([^)]*)\))?/)) {
		if (Wiki.plugins[RegExp.$1]) {
			var wom = Wiki.plugins[RegExp.$1](this, RegExp.$3, line);
			if (line.match(/[{][ \t]*$/)) {
				wom.isBegin = true;
			}
			return wom;
		} else {
			return new WOM(this,{
				type:'plain', level:0, body:line, isChild: false,
				toHtml: function(){return this.getBody();}
			});
		}
	// 通常文
	} else if (line.match(/^[~]/)) {
		return new WOM(this,{
			type:'plain', level:0, body:line.substring(1),
			isChild: true, breakIt:['pre','table','BQ'],
			toHtml: function(){return this.getBody();},
			blockTag: ["<div class='section'>","</div>"]
		});
	}
	// 通常文
	return new WOM(this,{
		type:'plain', level:0, body:line,
		isChild: true, breakIt:['pre','table','BQ'],
		toHtml: function(){return this.getBody();},
		blockTag: ["<div class='section'>","</div>"]
	});
}

Wiki.prototype._newBlock = function(parent, child) {
	var block = new WOM(this,{});
for (key in child) {
	if (key.match(/^(is.*)/)) {
		block[key] = child[key];
	}
}
	block.isChild = false;
	block.type = child.type;
	block.body = child.body;
	block.level = child.level;
	block.breakIt = child.breakIt;
	block.blockTag = child.blockTag;
	block.toHtml = child.toHtmlBlock;
	block.isBlock = true;
	block.children = [];
	return block;
}

Wiki.prototype._hasAncestor = function(parent, child) {
	parent = parent.parent;
	while (parent != null) {
		if (parent.type == child.type
				&& parent.level == child.level) {
			return true;
		}
		parent = parent.parent;
	}
	return false;
}

Wiki.prototype.getAnum = function(wom) {
	with (this) {
		var str = "";
		anum[wom.level-1]++;
		for (var i=wom.level; i<anum.length; i++) anum[i] = 0;
		if (wom.level == 1) str = anum[0]+".";
		if (wom.level == 2) str = anum[0]+"."+anum[1];
		if (wom.level == 3) str = anum[0]+"."+anum[1]+"."+anum[2];
		if (wom.level == 4) str = anum[0]+"."+anum[1]+"."+anum[2]+"."+anum[3];
		anums.push({anum:str, wom:wom});
		return str;
	}
}
//---------------------------------------------------------------------------

Wiki.doConvert = function(wikiText, dest) {
	var parser = new Wiki(wikiText);
	var wom = parser.parse();
	var html = wom.toHtml();
	Wiki.show(html, dest);
}
Wiki.show = function(html, dest) {
	dest.innerHTML = "";
	if (dest.insertAdjacentHTML) {
		dest.insertAdjacentHTML("BeforeEnd", html);
	} else {
		var range = document.createRange();
		range.setStartAfter(dest);
		var df = range.createContextualFragment(html);
		dest.appendChild(df);
	}

	var firstNode = dest.childNodes[0].childNodes ? dest.childNodes[0].childNodes[0] : null;
	if (firstNode && firstNode.tagName 
			&& firstNode.tagName.match(/^[hH][1-6]$/)) {
		firstNode.style.marginTop = 0;
	}

}


Wiki.getWikiText = function(pageName) {
	var req = new XMLHttpRequest();
	try {
		req.open('GET', pageName+"?"+new Date().getTime(), false);
		req.send(null);
		return req.responseText;
	} catch (e) {
		//console.log("-->"+e);
		return "Not found "+pageName;
	}
}

//---------------------------------------------------------------------------
Wiki.onload = function(srcId, dstId) {
	document.getElementById(srcId).style.display = "none";
	var src = document.getElementById(srcId).value;
	var dst = document.getElementById(dstId);
	Wiki.doConvert(src, dst);
	location.hash = location.hash;
}


function WikiManager(labelId, srcId, destId) {
	this.label  = document.getElementById(labelId);
	this.editor = document.getElementById(srcId);
	this.dest   = document.getElementById(destId);
	this.currentPageName = null;
}
WikiManager.prototype.load = function(pageName, ancName) {
 
	var wikiText = null;
	if (pageName == null) {
		pageName = "FrontPage";
		if (location.href.match(/^.*[?]([^#]*)(#(.*))?/)) {
			pageName = RegExp.$1;
			ancName = RegExp.$2;
		}
	}
	if (pageName.match(/[/]$/)) {
		wikiText = "#dirList("+pageName+");";
	}
	this.currentPageName = pageName;

	if (wikiText == null) {
		wikiText = Wiki.getWikiText(pageName+".wiki");
	}

	if (this.label) this.label.value = unescapePageName(pageName);
	if (this.editor) this.editor.value = wikiText;

	Wiki.doConvert(wikiText, this.dest);

	if (ancName) {
		location.hash = ancName; 
	}
} 
WikiManager.prototype.doConvert = function(wikiText) {

	if (wikiText == null) {
		wikiText = this.editor.value;
	}
	Wiki.doConvert(wikiText, this.dest);
}

//---------------------------------------------------------------------------
// Util
//---------------------------------------------------------------------------

Wiki.Util = {};
Wiki.Util.zeroPadd = function(num, len) {
	var str = "0000000000000000000000000000000000"+num;
	return str.substr(str.length-len);
}
Wiki.Util.formatDate = function(date,fmt) {
	var str = fmt ? fmt : "YYYY/MM/DD hh:mm:ss" ;
	str = str.replace(/YYYY/, date.getFullYear());
	str = str.replace(/YY/, Wiki.Util.zeroPadd(date.getYear()%100, 2));
	str = str.replace(/MM/, Wiki.Util.zeroPadd(date.getMonth()+1, 2));
	str = str.replace(/DD/, Wiki.Util.zeroPadd(date.getDate(), 2));
	str = str.replace(/hh/, Wiki.Util.zeroPadd(date.getHours(), 2));
	str = str.replace(/mm/, Wiki.Util.zeroPadd(date.getMinutes(), 2));
	str = str.replace(/ss/, Wiki.Util.zeroPadd(date.getSeconds(), 2));
	return str;
}

//-----------------------------------------------------------------------------
// EOF
//-------------------------------------------------------------------------------
