/* layoutTab*/

(function(JSCP){
var clazz = function(node) {
	this.node = node;
};
clazz.prototype = {
	NAME: "layoutTab",
	isMatch: function(node, lowerCaseName) {
		return lowerCaseName == JSCP.NS+"layout"
			&& JSCP.getAttr(node,"type") == "tab";
	},

	apply: function(node) {
		var ctx = JSCP.getAttrs(node);
		var children = JSCP.getChildren(node, JSCP.NS+"tab");
		var defTabNo = 0;
		var elements = [];

		for (var i=0; i<children.length; i++) {
			var element = JSCP.getAttrs(children[i]);
			element.select = this.select;
			if (element.onclick == null || element.onclick == "null") {
				element.onclick = "this.element.select(this);";
			}
			element.click = function(){ this.tab.click(); }

			element.body = children[i].innerHTML;
			elements.push(element);

			if (("#"+element.title) == location.hash) defTabNo = i;
		}
		ctx.elements = elements;

		var html = this.jscp(ctx, node);
		//console.log("-->"+html);
		var top = JSCP.setHTML(node, html);
		var tabs  = JSCP.getChildren(JSCP.getElementByClass(top, 'JSCP_TabItems'), "*");
		var bodys = JSCP.getChildren(JSCP.getElementByClass(top, 'JSCP_TabBodys'), "*");
        
		for (var i=0; i<tabs.length; i++) {
			if (elements[i].tgtid == null) {
				elements[i].body = bodys[i];
			} else {
				elements[i].body = document.getElementById(elements[i].tgtid);
				if (elements[i].body == null) {
					//throw "Not found tag target "+elements[i].tgtid;
				}
			}
			tabs[i].element = elements[i];
			elements[i].tab = tabs[i];
		}
		this.select(tabs[defTabNo], true);
		return tabs[defTabNo];
	},

	select: function(tab, isNoActivate) { // this == element.
		if (tab == null) return;
		if (this.title) {
			location.hash = "#"+this.title;
		}

		var tabs  = JSCP.getChildren(tab.parentNode, "*");
		var body = tab.element.body;

		for (var i=0; i<tabs.length; i++) {
			if (tabs[i] != tab) {
				var item = JSCP.getChildren(tabs[i], "*");
				item[0].style.display = "block";
				item[1].style.display = "none";
				if (tabs[i].element.body != null) {
					if (tabs[i].element.body.style.display != "none") {
						eval(tabs[i].element.onhide);
					}
					tabs[i].element.body.style.display = "none";
				} else {
					//throw "Not found tag target.";
				}
			}
		}

		var item = JSCP.getChildren(tab, "*");
		item[0].style.display = "none";
		item[1].style.display = "block";
		if (body != null) body.style.display = "block";
		eval(tab.element.onselect);

		if (!isNoActivate) JSCP.activate(body);
	}
};

return clazz;
})

