/* frame */

(function(JSCP){
var clazz = function(node) {
	this.node = node;
};
clazz.prototype = {
	NAME: "frame",
	isMatch: function(node, lowerCaseName) {
		return lowerCaseName == JSCP.NS+"frame";
	},

	apply: function(node) {
		var ctx = JSCP.getAttrs(node);
		if (ctx.title == null) ctx.title = "";

		if (ctx.include) {
			var xreq = JSCP.getXReq(ctx.include);
			ctx.body = xreq.responseText;
		} else {
			ctx.body = node.innerHTML;
		}

		var html = this.jscp(ctx, node);
		JSCP.setHTML(node, html);
		this.ctx = ctx;

		node.setLocation = function(loc) {this.driver.setLocation(loc);};
		node.reload      = function() {this.driver.reload();};
		node.back        = function() {this.driver.back();};
		node.forward     = function() {this.driver.forward();};

	},

	activate: function(node) {
		var iframe = null;
		if (this.ctx.iframe) {
			var iframes = node.getElementsByTagName("iframe");
			iframe = iframes[0];
			if (iframe && (iframe.src == "" || iframe.src == "about:blank")) {
				iframe.src = this.ctx.iframe;
			}
		}

		var frameWrapper = JSCP.getFirstChild(node);
		var table = JSCP.getElementByClass(frameWrapper, "JSCP_Frame");
		if (this.ctx.height) {
			var frameCT = JSCP.getElementByClass(frameWrapper, "JSCP_FrameCT");
			var frameCB = JSCP.getElementByClass(frameWrapper, "JSCP_FrameCB");
			frameWrapper.style.height = "0px";

			if (iframe) {
				iframe.style.height = "0px";
				JSCP.correctHeight(frameWrapper, this.ctx.height);
				var h = (frameWrapper.offsetHeight - frameCT.offsetHeight - frameCB.offsetHeight);
				iframe.style.height = h+"px";
			} else {
				var frameBody = JSCP.getElementByClass(frameWrapper, "JSCP_FrameBody");
				frameBody.style.height = "0px";
				JSCP.correctHeight(frameWrapper, this.ctx.height);
				var h = frameWrapper.offsetHeight - frameCT.offsetHeight - frameCB.offsetHeight;
				if (h>=0) {
					frameBody.style.height = h+"px";
				}

				if (this.ctx.justfit && eval("("+this.ctx.justfit+")")) {
					var firstNode = JSCP.getFirstChild(frameBody);
					var borderHeight = parseInt(firstNode.style.borderTop) + parseInt(firstNode.style.borderBottom);
					if (isNaN(borderHeight)) borderHeight = 0;
					if (h>=0) {
						firstNode.style.height = (h - borderHeight) +"px";
					}
				}

			}
		}

		if (table.clientWidth > frameWrapper.clientWidth) {
			var body = JSCP.getElementByClass(frameWrapper, "JSCP_FrameBody");
			var lm = JSCP.getElementByClass(frameWrapper, "JSCP_FrameLM");
			var rm = JSCP.getElementByClass(frameWrapper, "JSCP_FrameRM");
			var w = (frameWrapper.clientWidth-lm.clientWidth-rm.clientWidth);
			if (w>0) {
				body.style.width = w+"px";
			}
		}

	},


	setLocation: function(loc) {
		if (this.ctx.iframe) {
			this.ctx.iframe = loc;
			var ifr = this.node.getElementsByTagName("iframe");
			ifr[0].src = "about:blank";
		}
	},

	reload: function() {
		if (this.ctx.iframe) {
			var ifr = this.node.getElementsByTagName("iframe");
			//ifr[0].src = this.ctx.iframe;
			try {
				ifr[0].contentWindow.location.reload();
			} catch (e) {
				ifr[0].src = ifr[0].src;
			}
		}
	},
	openBlank: function() {
		if (this.ctx.iframe) {
			var ifr = this.node.getElementsByTagName("iframe");
			window.open(ifr[0].src, "_blank");
		}
	},
	back: function() {
		if (this.ctx.iframe) {
			var ifr = this.node.getElementsByTagName("iframe");
			ifr[0].contentWindow.history.back();
			ifr[0].src = ifr[0].src;
		}
	},
	forward: function() {
		if (this.ctx.iframe) {
			var ifr = this.node.getElementsByTagName("iframe");
			ifr[0].contentWindow.history.forward();
			ifr[0].src = ifr[0].src;
		}
	}

};

return clazz;
})


