/**
 * DIVタグに影を付ける jQuery plugin。
 * - 使い方
$("#target").boxShadow("makeShadow", opts);
$("#target").boxShadow("show");
$("#target").boxShadow("hide");
$("#target").boxShadow("toggle");

opts = {
	depth: 影の深さ(defo=6),
	opacity: 影の濃さ(defo=0.25),
	animeTime: アニメーション時間(defo=800ms),
}

 * @author kotemaru@kotemaru.org
 */
(function($) {

	var Methods = {
		DEFAULT_OPTS: {
			depth: 8,
			opacity: 0.20,
			animeTime: 800,
			END: "dummy"
		},

		makeShadow: function(jqobj, opts) {
			var options = $.extend(Methods.DEFAULT_OPTS, opts);

			var divs = $(".Shadow", jqobj);
			if (divs.length > 0) return;

			for (var i=0; i<options.depth*2; i++) {
				var div = $(document.createElement("div"));
				div.addClass("boxShadow");
				div.css({
					position: "absolute",
					backgroundColor: "black",
					display:"none"
				});
				div.fadeTo(0, options.opacity);
				div.hide();
				jqobj.prepend(div);
				jqobj.css({overflow:	"visible"});
			}
			jqobj[0].boxShadow = {options:options, isShow:false};
		},

		show: function(jqobj, opts) {
			var options = jqobj[0].boxShadow.options;
			var depth = options.depth;
			if (options.animeTime>0) {
				var time = options.animeTime/(depth*2);
				for (var i=0; i<depth; i+=2) {
					this.delayShow(jqobj, i, time*i);
				}
				this.showOne(jqobj, depth-1, time*depth);
			} else {
				this.showOne(jqobj, depth-1);
			}
			jqobj[0].boxShadow.isShow = true;
		},

		hide: function(jqobj, opts) {
			var options = jqobj[0].boxShadow.options;
			var depth = options.depth;
			if (options.animeTime>0) {
				var time = options.animeTime/(depth*2);
				var step = depth-2;
				for (var i=0; i<depth; i+=2) {
					this.delayShow(jqobj, step, time*i);
					step -= 2;
				}
				this.showOne(jqobj, -1, time*(depth+1));
			} else {
				this.showOne(jqobj, -1);
			}
			jqobj[0].boxShadow.isShow = false;
		},

		toggle: function(jqobj, opts) {
			if (jqobj[0].boxShadow.isShow) {
				this.hide(jqobj, opts);
			} else {
				this.show(jqobj, opts);
			}
		},

		//---------------------------------------------------------------------
		// private
		delayShow: function(jqobj, step, time) {
			var _this = this;
			setTimeout(function(){_this.showOne(jqobj, step);}, Math.floor(time));
		},

		showOne: function(jqobj, step) {
			var w = jqobj.width();
			var h = jqobj.height();

			var divs = $(".boxShadow", jqobj);
			var depth = divs.length/2;
			for (var i=0; i<divs.length; i++) {
				var div = $(divs[i]);
				var n = Math.floor(i/2);
				var r = depth - n;
				var pos = step+(depth-n);
				var thick = n+1-(depth-step);

				if(thick < 0) {
					div.hide();
					continue;
				}

				if (i % 2 == 1) {// TATE
					div.css({left:w, top:pos});
					div.width(thick);
					div.height(h - r*2+1);
				} else {// YOKO
					div.css({left:pos, top:h});
					div.width(w - r*2-n+(depth-step));
					div.height(thick);
				}
				div.show();
			}

			var margin = Math.floor(-step/2);
			jqobj.css({marginLeft:margin, marginTop:margin});
		},


		END: "dummy"
	};

	$.fn.boxShadow = function(cmd, opts) {
		Methods[cmd](this, opts);
		return this;
	};

})(jQuery);

