//-------------------------------------------------------------------------------
// Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
// Copyright (c) 2011- kotemaru@kotemaru.org
//-------------------------------------------------------------------------------
if (DateUtil == null) var DateUtil = {};


DateUtil.fmt = function(date) {
	if (typeof date == "number")  date = new Date(date);
	var yy = date.getFullYear();
	var mm = date.getMonth() + 1;
	var dd = date.getDate();
	if (yy < 2000) { yy += 1900; }
	if (mm < 10) { mm = "0" + mm; }
	if (dd < 10) { dd = "0" + dd; }
	return yy + "/" + mm + "/" + dd;
}

DateUtil.fmtMMDD = function(date) {
	if (typeof date == "number")  date = new Date(date);
	var mm = date.getMonth() + 1;
	var dd = date.getDate();
	if (mm < 10) { mm = "0" + mm; }
	if (dd < 10) { dd = "0" + dd; }
	return mm + "/" + dd;
}
DateUtil.fmtYYMM = function(date) {
	if (typeof date == "number")  date = new Date(date);
	var yy = date.getFullYear();
	var mm = date.getMonth() + 1;
	if (yy < 2000) { yy += 1900; }
	if (mm < 10) { mm = "0" + mm; }
	return yy + "/" + mm;
}

DateUtil.monthArea = function(date) {
	if (typeof date == "number")  date = new Date(date);
	var yy = date.getFullYear();
	var mm = date.getMonth();
	var minDate = new Date(yy,mm,1);

	if (++mm>=12) {
		mm = 0;
		yy++;
	}
	var maxDate = new Date(yy,mm,1);
	return {min: minDate.getTime(), max: maxDate.getTime()};
}

DateUtil.nextMonth = function(date) {
	if (typeof date == "number")  date = new Date(date);
	var yy = date.getFullYear();
	var mm = date.getMonth();
	var dd = date.getDate();
	if (++mm>=12) {
		mm = 0;
		yy++;
	}
	date.setYear(yy);
	date.setMonth(mm);
	return date.getTime();
}

DateUtil.prevMonth = function(date) {
	if (typeof date == "number")  date = new Date(date);
	var yy = date.getFullYear();
	var mm = date.getMonth();
	var dd = date.getDate();
	if (--mm<0) {
		mm = 11;
		yy--;
	}
	date.setYear(yy);
	date.setMonth(mm);
	return date.getTime();
}

