//-------------------------------------------------------------------------------
// Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
// Copyright (c) 2011- kotemaru@kotemaru.org
//-------------------------------------------------------------------------------
/**
 * DataStore クラス。
 * JavaScript から GAE の低レベルAPI を容易に使う為のクラス。
 */

/**
 * コンストラクタ。
 */
function DataStore() {
	this.ds = DataStore.DSF.getDatastoreService();
}

DataStore.API = Packages.com.google.appengine.api.datastore;
DataStore.DSF = DataStore.API.DatastoreServiceFactory;
DataStore.KEY = "pkey";
__PKG__.wsjs.gae.lowapi.EntityWrapper.defineClass(this);
var LOG = __ENV__.LOG;


/**
 * トランザクション処理の補助関数。
 * <li>処理関数をトランザクションの開始と終了の内側で実行する。
 * <li>処理関数が例外を発生させた場合は rollback する。
 * @param func 処理関数
 * @return func の戻り値
 */
DataStore.transaction = function(func){
	var ds = new DataStore();
	var tx = ds.ds.beginTransaction();
	try {
		try {
			return func(ds);
		} finally {
			tx.commit();
		}
	} catch (e) {
		tx.rollback();
		if (e.rhinoException) {
			throw e.rhinoException;
		} else if (e.fileName && e.lineNumber){
			throw e.message+"("+e.fileName+"#"+e.lineNumber+")";
		} else {
			throw e;
		}
	} finally {
		//TODO:
	}
}

DataStore.prototype.put = function(kind, data){
	with (this) {
		var wrapper = null;
		if (data instanceof EntityWrapper) {
			wrapper = data;
		} else {
			var entity = data[DataStore.KEY]
				? new DataStore.API.Entity(kind.name, data[DataStore.KEY])
				: new DataStore.API.Entity(kind.name);
			wrapper = new EntityWrapper(entity);
//LOG.info("--->"+wrapper.entity());
			for (var name in kind.types) {
				var defo = kind.types[name];
				wrapper[name] = _correctType(defo, data[name]);
			}
		}

		var _key_ = ds.put(wrapper.getEntity());
		var key = _key_.getName();
		if (key == null) key = _key_.getId();
		return key;
	}
}

// <form> から投げられた場合のみ使われる。
DataStore.prototype._correctType = function(defo, data){
	if (data == undefined) return defo;
	var type = typeof defo;
	if (type == typeof data) return data;
	//if (type == "object") type = defo.type; //TODO:

	if (type == "string") {
		return ""+data;
	} else if (type == "number" ) {
		return parseInt(data);
	} else if (type == "boolean") {
		return data == "true" || data == "on" || data == "ok"
			|| (typeof data == "number" && data != 0);
	} else {
		throw "Unsuppoted type "+type;
	}
}

DataStore.prototype.get = function(kind, key){
	with (this) {
		var query = new DataStore.API.Query(kind.name);
		var _key_ = DataStore.API.KeyFactory.createKey(kind.name, key);
		query.addFilter(DataStore.API.Entity.KEY_RESERVED_PROPERTY, 
								DataStore.API.Query.FilterOperator.EQUAL , _key_);
		var preQuery = ds.prepare(query);
		var entity = preQuery.asSingleEntity();
		if (entity == null) return null;
		return new EntityWrapper(entity);
	}
}

DataStore.prototype.remove = function(kind, key){
	with (this) {
		var _key_ = DataStore.API.KeyFactory.createKey(kind.name, key);
		return ds['delete'](_key_);
	}
}

DataStore.prototype.query = function(kind, where, sort){
	var query = this.newQuery(kind);
	if (where != null) {
		for (var name in where)	query.eq(name, where[name]);
	}
	if (sort != null) {
		for (var name in sort) query.sort(name, sort[name]);
	}
	return query.asArray(query, true);
}

DataStore.prototype.newQuery = function(kind){
	return new DataStore.Query(this, kind);
}



//-------------------------------------------------------------------
DataStore.Kind = function(name, types) {
	this.name = name;
	this.types = types;
}

//-------------------------------------------------------------------
DataStore.Query = function(parent, kind) {
	this.parent = parent;
	this.ds = parent.ds;
	this.kind = kind;
	this.query = new DataStore.API.Query(kind.name);
	this._limit = null;
	this._offset = null;
}
DataStore.Query.API = DataStore.API;
DataStore.Query.FilterOperator = DataStore.API.Query.FilterOperator;
DataStore.Query.SortDirection = DataStore.API.Query.SortDirection;

DataStore.Query.prototype.eq = function(name, val){
	this.query.addFilter(name,	DataStore.Query.FilterOperator.EQUAL, val);
	return this;
}
DataStore.Query.prototype.gt = function(name, val){
	this.query.addFilter(name,	DataStore.Query.FilterOperator.GREATER_THAN, val);
	return this;
}
DataStore.Query.prototype.gteq = function(name, val){
	this.query.addFilter(name,	DataStore.Query.FilterOperator.GREATER_THAN_OR_EQUAL, val);
	return this;
}
DataStore.Query.prototype.lt = function(name, val){
	this.query.addFilter(name,	DataStore.Query.FilterOperator.LESS_THAN, val);
	return this;
}
DataStore.Query.prototype.lteq = function(name, val){
	this.query.addFilter(name,	DataStore.Query.FilterOperator.LESS_THAN_OR_EQUAL, val);
	return this;
}
DataStore.Query.prototype.sort = function(name, dir){
	with (this) {
		if (dir == "DESC") {
			query.addSort(name,	DataStore.Query.SortDirection.DESCENDING);
		} else {
			query.addSort(name);
		}
	}
	return this;
}
DataStore.Query.prototype.limit = function(val){
	this._limit = val;
	return this;
}
DataStore.Query.prototype.offset = function(val){
	this._offset = offset;
	return this;
}

DataStore.Query.prototype.asList = function(){
	return this.ds.prepare(this.query).asList(this._getOperator());
}
DataStore.Query.prototype.asIterator = function(){
	return this.ds.prepare(this.query).asIterator(this._getOperator());
}
DataStore.Query.prototype.asArray = function(){
	with (this) {
		//var ite = ds.prepare(query).asIterator(_getOperator());
		var ite = ds.prepare(query).asIterator();
		var array = [];
		while (ite.hasNext()) {
			var entity = ite.next();
			array.push(new EntityWrapper(entity));
		}
		return array;
	}
}


DataStore.Query.prototype._getOperator = function(){
	with (this) {
		var op = DataStore.API.FetchOptions.Builder.withChunkSize(10);
		if (_limit) op = op.limit(_limit);
		if (_offset) op = op.offset(_offset);
		return op;
	}
}

//EOF
