
/** 
 * JSCP.js
 * ※ユーティリティは後半にあります。
 */

if (String.prototype.escapeHTML == null) {
	String.prototype.escapeHTML = function() {
		return this.replace(/&/g,"&amp;").replace(/'/g,"&apos;").replace(/"/g,"&quot;").replace(/</g,"&lt;");
	}
}
if(typeof ActiveXObject == "function" && typeof XMLHttpRequest == "undefined"){
    XMLHttpRequest = function(){
        return new ActiveXObject("Microsoft.XMLHTTP")
    }
}

if (undefined == JSCP) var JSCP = (function(){
//------------------------------------------------------------------------
// 初期化処理
//------------------------------------------------------------------------
var This = {};
var JSCP = This;

This.LOG = "";
This.NS_URL = "http://jscp/";
This.NS = "";
This.NS_stack = [];
This.resizeWidth = -1;
This.resizeHeight = -1;
//This.isIE = (document.documentElement.getAttribute("style") == document.documentElement.style);
This.isIE = /*@cc_on!@*/false; 
This.gid = 0;

This.findNamespace = function(node) {
	var attrs = node.attributes;
	if (attrs == null) return null;
	for (var i=0; i<attrs.length; i++) {
//alert("-->"+attrs[i].name+"="+attrs[i].value);
		if (attrs[i].value == This.NS_URL) {
			This.NS_stack.push(This.NS);
			This.NS = attrs[i].name.replace(/^xmlns:/,"")+":";
			return This.NS;
		}
	}
	return null;
}

// 名前空間の検索
{
	This.findNamespace(document.childNodes[1]);
	if (This.NS == "") {
// for IE BUG
//		throw "Not found namespace "+this.NS_URL;
	}
}

//------------------------------------------------------------------------
// 基本関数の定義
//------------------------------------------------------------------------
This.init = function() {
	// 初期状態の保存
	if (this.backupInnerHTML == null) {
		this.backupInnerHTML = document.body.innerHTML;
	} else {
		document.body.innerHTML = This.backupInnerHTML;
	}

	// JSCPの適用。
	this.apply(document.body);
	this.activate(document.body);
}
This.resize = function() {
	if (This.resizeHeight == document.body.clientHeight
		&& This.resizeWidth == document.body.clientWidth) {
		return;  // for IE6 BUG
	}
	this.activate(document.body);
	This.resizeHeight = document.body.clientHeight;
	This.resizeWidth = document.body.resizeWidth;
}

This.compile = function(jscpSrc, title) {
	var pos = 0;
	var parts = ["/*",title,"*/\n","(function(ctx, node){\n","var out=[];\n"];
	while (pos < jscpSrc.length) {
		var start = jscpSrc.indexOf("<%", pos);
		if (start == -1) start = jscpSrc.length;
		var html = jscpSrc.substring(pos, start);
		html = html.replace(/\r/g,"\\r").replace(/'/g,"\\'");
		var lines = html.split("\n");
		for (var i=0; i<lines.length; i++) {
			parts.push("out.push('");
			parts.push(lines[i]);
			if (i < lines.length-1) {
				parts.push("\\n');\n");
			} else {
				parts.push("');\n");
			}
		}
		
		pos = start + 2;

		var end   = jscpSrc.indexOf("%>", pos);
		if (end == -1) end = jscpSrc.length;
		var js = jscpSrc.substring(pos, end);
		if (js.match(/^=/)) {
			parts.push("out.push(");
			parts.push(js.replace(/^=/,""));
			parts.push(");\n");
		} else if (js.match(/^@[ ]*node[ ]*$/)) {
			parts.push("out.push('JSCP.getJSCPNode(this,');\n");
			parts.push("out.push(node.gid);\n");
			parts.push("out.push(')');\n");
		} else {
			parts.push(js);
		}
		parts.push("\n");
		pos = end + 2;
	}
	parts.push("return out.join('');\n})");
	var funcStr = parts.join("");
	try {
		eval("var func = "+funcStr); // TODO: SyntaxError lineNumber
		return func;
	} catch (e) {
		alert("This compile error:"+ e +"\n"+funcStr);
		throw e;
	}
}

This.compileURL = function(url) {
	var xreq = this.getXReq(url);
	return this.compile(xreq.responseText, url);
}

This.applyById = function(id) {
	this.apply(document.getElementById(id));
}
This.apply = function(node) {
	if (node == null || node.tagName == null) return;
	if (node.nodeType == 8) return; // Comment
	var isFindNS = this.findNamespace(node);

	var nodeName = node.nodeName.toLowerCase();
//JSCP.log(nodeName);
	for (var i=0; i<this.drivers.length; i++) {
		var driver = this.drivers[i];
		if (driver.prototype.isMatch(node, nodeName)) {
			if (node.gid == null) {
				node.gid = this.getGenerateId();
			}
			if (node.driver == null) {
				node.driver = new driver(node);
			}
			node.driver.apply(node);
			break;
		}
	}

	var children = node.childNodes;
	if (children == null) return;
	for (var i=0; i<children.length; i++) {
		this.apply(children[i]);
	}

	if (isFindNS) this.NS = this.NS_stack.pop();
}

This.activate = function(node) {
	if (node.style == null || node.style.display == "none") return;
	if (node.tagName == null || node.tagName.toUpperCase() == "IFRAME") return;

	if (node.driver &&
		typeof node.driver.activate == "function") {
		node.driver.activate(node);
	}

	if (node.activate) {
		node.activate();
	}

	var onactive = this.getAttr(node, "onactive")
	if (onactive) {
		(function(){eval(onactive);}).call(node);
	}

	var children = node.childNodes;
	if (children == null) return;
	for (var i=0; i<children.length; i++) {
		this.activate(children[i]);
	}
}

This.extension = function(url, tagName) {
	if (url.match(/[.]pack$/)) {
		var basedir = url.replace(/[^/]+$/,"");
		if (tagName == null) {
			tagName = ""+url.match(/[^/]+$/);
			tagName = tagName.replace(/[.]pack$/,"");
		}
		var xreq = this.getXReq(url);
		var pack = eval("("+xreq.responseText+")");
		for (var key in pack) {
			if (!pack[key].match(/^[/]/))	pack[key] = basedir+pack[key];
		}
		this._extension(pack, tagName);
	} else {
		var base = url.replace(/[.]jscp$/,"");
		if (tagName == null) tagName = url.match(/[^/]+$/);
		var pack = {js:base+".js", jscp:base+".jscp", css:base+".css", rpjs:base+".rpjs"};
		this._extension(pack, tagName);
	}
}

This._extension = function(pack, tagName) {
	var driver = null;
	if (pack.js) {
		var xreq = this.getXReq(pack.js);
		if (xreq.status == 200) {
			if (this.isIE) {
				eval("var func = "+xreq.responseText); // for IE.
				driver = func(This);
			} else {
				driver = eval(xreq.responseText)(This);
			}
		}
	}
	if (driver == null) {
		driver = function(node) {this.node = node;};
		driver.prototype = {
			isMatch: function(node, lowerCaseName) {
				return lowerCaseName == This.NS+tagName;
			},
			apply: function(node) {
				node.innerHTML = this.jscp(This.getAttrs(node), node);
			}
		};
	}

	if (pack.jscp) {
		var xreq = this.getXReq(pack.jscp);
		if (xreq.status == 200) {
			driver.prototype.jscp = this.compile(xreq.responseText, pack.jscp);
		}
	}

	if (pack.rpjs) {
		var xreq = this.getXReq(pack.rpjs);
		if (xreq.status == 200) {
			window.eval(xreq.responseText);
		}
	}
	if (pack.css) {
		this.loadCSS(pack.css);
	}
	this.drivers.push(driver);
}
This.loadCSS = function(url) {
	var link = document.createElement("link");
	link.setAttribute("rel", "stylesheet");
	link.setAttribute("href", url);
	link.setAttribute("type", "text/css");
	document.getElementsByTagName('head')[0].appendChild(link);		
}

//------------------------------------------------------------------------
// <jscp:jscp> Driver
//------------------------------------------------------------------------
This.drivers = [];
This.jscpCache = {};

var driver = function(node) {
	this.node = node;
};
driver.prototype = {
	This: This,
	isMatch: function(node, lowerCaseName) {
		return lowerCaseName == This.NS+"jscp";
	},

	apply: function(node) {
		var ctx = This.getAttrs(node);
		var jscpSrc = node.innerHTML;
		var jscp = null;

		if (ctx.src) {
			jscp = This.jscpCache[ctx.src];
			if (jscp == null) {
				var xreq = This.getXReq(ctx.src);
				jscpSrc = xreq.responseText;
				jscp = This.compile(jscpSrc, ctx.src);
				This.jscpCache[ctx.src] = jscp;
			}
		} else if (this.backupJscpSrc) {
			jscpSrc = this.backupJscpSrc
			jscp = This.compile(jscpSrc, ctx.src);
		} else {
			for (var i=0; i<node.childNodes.length; i++) {
				var child = node.childNodes[i];
				if (child.nodeType == 8 || child.nodeName == "#comment") {
					jscpSrc = child.nodeValue;
				}
			}
			this.backupJscpSrc = jscpSrc;
			jscp = This.compile(jscpSrc, ctx.src);
		}

		var html = jscp(ctx, node);
//alert(html);
		node.innerHTML = html;
	}
};

This.drivers.push(driver);

//----------------------------------------------------------------------
// Utils
//----------------------------------------------------------------------


/**
 * ノードの属性値を取得する。
 * @param node ノード
 * @param name 属性名
 * @param def  デフォルト値
 * @return XMLHttpRequestインスタンス。
 */
This.getAttr = function(node, name, def) {
	if (node.attributes && node.attributes[name]
			&& node.attributes[name].value != null) {
		return node.attributes[name].value;
	} else {
		return def;
	}
}

/**
 * ノードの属性値を全て取得する。
 * @param node ノード
 * @return 存在する属性のセット。
 */
This.getAttrs = function(node) {
	var attrs = {};
	if (node.attributes == null) return attrs;
	for (var i=0; i<node.attributes.length; i++) {
		var val = node.attributes[i].value;
		if (val) attrs[node.attributes[i].nodeName] = val;
	}
	return attrs;
}

/**
 * クラス名でノードを検索する。
 * @param node 検索ノード
 * @param name クラス名
 * @return 最初に見つかったノード
 */
This.getElementByClass = function(node, name) {
	var children = node.childNodes;
	if (children == null) return null;
	for (var i=0; i<children.length; i++) {
		if (children[i].className == name) {
			return children[i];
		} else if (children[i].tagName) {
			var res = This.getElementByClass(children[i], name);
			if (res != null) return res;
		}
	}
	return null;
}

/**
 * 子ノードからノード名でノードを検索する。
 * @param node 親ノード
 * @param name ノード名、"*"なら全て。
 * @return ノードのリスト。
 */
This.getChildren = function(node, name) {
	var children = node.childNodes;
	var res = [];
	if (name == "*") {
		for (var i=0; i<children.length; i++) {
			if (children[i].tagName != null) {
				res.push(children[i])
			}
		}
		return res;
	}

	name = name.toUpperCase();
	for (var i=0; i<children.length; i++) {
		var nodeName = children[i].nodeName;
		if (nodeName != null && nodeName.toUpperCase() == name) {
			res.push(children[i]);
		}
	}
	return res;
}

/**
 * テキストノードを除く最初のノードを返す。
 * @param node 親ノード
 * @return 最初のノード。
 */
This.getFirstChild = function(node) {
	for (var i=0; i<node.childNodes.length; i++) {
		if (node.childNodes[i].tagName) return node.childNodes[i];
	}
	return null;
}

/**
 * ノードが所属するJSCPのノードを返す。
 * @param node 対象ノード
 * @param gid JSCPノードのID
 * @return JSCPのノード。
 */
This.getJSCPNode = function(node, gid) {
	while (node != null) {
		if (node.driver) {
			if (gid == null) return node;
			if (gid == node.gid) return node;
		}
		node = node.parentNode;
	}
	return null;
}

/**
 * ノードが所属するJSCPのドライバを返す。
 * @param node 対象ノード
 * @return JSCPのドライバ。
 */
This.getDriver = function(node) {
	while (node != null) {
		if (node.driver) return node.driver;
		node = node.parentNode;
	}
	return null;
}

/**
 * 子要素にHTML文字列を設定し最初のノードを返す。
 * @param node 親ノード
 * @param html 設定するHTML
 * @return 最初のノード。
 */
This.setHTML = function(node, html) {
	node.innerHTML = html;
	return This.getFirstChild(node);
}

/**
 * ノードの外部文字列を取得する。
 * @param node 対象ノード
 * @return 外部文字列。
 */
This.outerHTML = function(node) {
	if (node.outerHTML) return node["outerHTML"];

	var html = "<"+node.tagName;
	if (node.attributes) {
		for (var i=0; i<node.attributes.length; i++) {
			var val = node.attributes[i].value.replace(/[']/g, "&apos;");
			html += " "+node.attributes[i].nodeName+"='"+val+"'";
		}
	}
	html += ">"+node.innerHTML+"</"+node.tagName+">";
	return html;
}



/**
 * ノードの高さを補正する。
 * - 現在位置(style.top)は変更しない。
 * - 100% で親ノードの bottom となる。
 * @param node 対象ノード
 * @param height 高さ、"{n}px" or "{n}%" or "both"
 */
This.correctHeight = function(node, height) {
	if (height == null) return;
	var both = node.offsetParent.offsetHeight - node.offsetTop -2;
	if (height == "both") height = "100%";

	if (height.match(/%$/)) {
		var h = both * 100 / parseInt(height);
		if (h>0) node.style.height = h + "px";
	} else if (height.match(/px$/)){
		node.style.height = height;
	} else {
		node.style.height = height+"px";
	}
}

/**
 * form の値を json に変換する。
 * - 対象ノードが form で無い場合は祖先ノードを検索する。
 * - inputタグの名前と値のペアになる。
 * @param node 対象ノード
 * @return input の 名前:値 のセット。
 */
This.form2json = function(node) {
	while (node != null) {
		if (node.nodeName.toUpperCase() == "FORM") break;
		node = node.parentNode;
	}
	var form = node;
	var json = {};
	var elems = form.elements;
	for (var i=0; i<elems.length; i++) {
		if (elems[i].name != "") {
			json[elems[i].name] = elems[i].value;
			if (elems[i].type == "checkbox") {
				json[elems[i].name] = elems[i].checked;
			}
		}
	}
	return json;
}

/**
 * json の値を form に設定する。
 * - 対象ノードが form で無い場合は祖先ノードを検索する。
 * - inputタグの名前と値のペアになる。
 * @param node 対象ノード
 * @param json データ
 */
This.json2form = function(node, json) {
	while (node != null) {
		if (node.nodeName.toUpperCase() == "FORM") break;
		node = node.parentNode;
	}
	var form = node;

	var elems = form.elements;
	for (var i=0; i<elems.length; i++) {
		if (elems[i].name != "") {
			elems[i].value = json[elems[i].name];
			if (elems[i].type == "checkbox") {
				 elems[i].checked = json[elems[i].name]
			}
		}
	}
}

/**
 * XMLHttpRequestでGETを発行する。
 * @param url リクエスト先URL
 * @return XMLHttpRequestインスタンス。
 */
This.getXReq = function(url) {
	var xreq;
	if (window.XMLHttpRequest) {
		xreq = new XMLHttpRequest();
	} else {
		xreq = new ActiveXObject("Microsoft.XMLHTTP");
	}
	xreq.open("GET", url, false);
	//xreq.setRequestHeader("If-Modified-Since", "Thu, 01 Jun 1970 00:00:00 GMT");
	//xreq.setRequestHeader("Cache-Control", "max-age=0");
	//xreq.setRequestHeader("Cache-Control", "no-cache");
	xreq.send(null);
	return xreq;
}

/**
 * デバッグ用ログ出力。
 * - id="debugLog"の textarea が存在すればそこに書き込む。
 * @param msg メッセージ
 */
This.log = function(msg) {
	if (This.LOG == "") {
		This.LOG = document.getElementById("debugLog");
	}
	if (This.LOG != null) {
		This.LOG.value += msg +"\n";
	} else if (console) {
		console.log(msg);
	}
}
/**
 * エラーダイアログ。
 * - 
 * @param msg エラーメッセージ
 * @param rootPath "/lib/errorDialog.html"までのパス
 */
This.errorDialog = function(msg, rootPath) {
	var url = "/_wsjs_/lib/errorDialog.html";
	if (rootPath) url = rootPath + url; 
	return window.showModalDialog(url , msg , 
			"dialogWidth:400px;dialogHeight:270px;");
}
/**
 * 固有IDの取得。
 * @return 固有ID。
 */
This.getGenerateId = function() {
	return (this.gid++);
}

//------------------------------------------------------------------------
return This;
})();
// EOF
