/**
SSJSはサーブレットの処理をJavaScriptにそのまま記述できます。
1. doGet()関数またはdoPost()関数が呼び出されます。
2. 引数の req,res は HttpServletRequest,HttpServletResponse その物です。
3. Rhinoの E4X を使用して容易に XHTML を生成できます。
4. 初期済変数（詳細はドキュメントを参照してください。）
  a) XMLHttpRequest : クライアントの物と同じです。利用制限があります。
  b) __ENV__ : WSJSシステムを指す変数です。WSJSのリソースのアクセスに使用します。
  c) __PKG__ : WSJSのJavaパッケージを指す変数です。
*/

function doGet(req, res) {
	var userName = __ENV__.user.name; // ログインユーザ名
	var html =
	<html xmlns="http://www.w3.org/1999/xhtml">
		<body>
			<form method="POST">
				<div>user: {userName}</div>
				<input name="sample"/>
				<input value="送信" type="submit"/>
			</form>
		</body>
	</html>
	res.writer.write(html);
}

function doPost(req, res) {
	sample = req.getParameter("sample");

	var html =
	<html xmlns="http://www.w3.org/1999/xhtml">
		<body>
			sample={sample}
		</body>
	</html>
	res.writer.write(html);
}

