
function doGet(req, res) {
	var message = "";
	if (!__ENV__.user.hasRole("member")) {
		message = <div style="color:red">この機能の利用は管理者の許可が必要です。</div>
	}

	var pageName = req.getParameter("pageName");

	var html =
<body>{message}
<table><tr><td>
	<form method="POST" enctype="multipart/form-data" >
		<fieldset><legend>UpLoad</legend>
			<font size="2">
				<input type="checkbox" name="overwrite" checked="yes">上書きする。</input><br/>
				<input type="checkbox" name="expandjar" checked="yes">jarファイルを展開する。</input><br/>
			</font><br/>
			<input type="hidden" name="mode" value="upload"/>
			転送先: <input readonly="yes" name="pageName" value={pageName}
				style="margin-bottom:4px;"/><br/>
			転送元: <input type="file" name="file" /><br/>
			<br/>
			<div  align="right"><input type="submit" value="送信" /></div>
		</fieldset>
	</form>

</td></tr><tr><td>

	<form method="POST" enctype="multipart/form-data" >
		<fieldset><legend>Backup</legend>
			<input type="hidden" name="mode" value="backup"/>
			転送元: <input readonly="yes" name="pageName" value={pageName}/><br/>
			<font size="1"><br/>※Backupファイルはjar形式です。</font>
			<div  align="right"><input type="submit" value="受信" /></div>
		</fieldset>
	</form>
</td></tr></table>
</body>
;

	res.writer.write(html);
}

function doPost(req, res) {
	if (!__ENV__.user.hasRole("member")) {
	//	throw new __PKG__.wsjs.AccessDeniedException(
	//		__ENV__.wsjsContext, __ENV__.user, "/_wsjs_/develop/UpLoad.ssjs");
	}

	var uploader = __PKG__.util.UploadUtil.getServletUploader();
	var ite = uploader.getItemIterator(req);
	var params = {};
	var file;
	var fileIn;
	while (ite.hasNext()) {
		var item = ite.next();
		if (item.isFormField()) {
			params[item.getFieldName()] = 
				__PKG__.util.IOUtil.streamToString(item.openStream(), "utf-8");
		} else {
			params[item.getFieldName()] = item;
			file = item;
			fileIn = item.openStream();
			break;
		}
	}

	if (params.mode == "backup") {
		return backup(req, res, params);
	}

	res.setContentType("text/plain; charset=utf-8");
	var pageName  = params.pageName;
	var overwrite = params.overwrite ? (params.overwrite=="on") : false;
	var expandjar = params.expandjar ? (params.expandjar=="on") : false;
	try {
		var basePageName = __ENV__.getPage(pageName).getPageName() +"/";
		if (expandjar) {
			var jarIn = java.util.jar.JarInputStream(fileIn);
			var entry = jarIn.getNextJarEntry();
			while (entry != null) {
				var name =	basePageName + entry.getName();
				var page = __ENV__.getPage(name);
				if (overwrite || !page.exists()) {
					if (entry.isDirectory()) {
						page.mkdir();
						res.writer.write("\nmkdir: "+name);
					} else {
						page.putBodyStream(jarIn);
						res.writer.write("\nwrite: "+name);
					}
				} else {
					res.writer.write("\nskip : "+name);
				}
				entry = jarIn.getNextJarEntry();
			}
			res.writer.write("\njarファイルを展開しました。");
		} else {
			var page = __ENV__.getPage(pageName);
			var name = basePageName;
			if (page.isDirectory()) name = basePageName + file.getName();
			page = __ENV__.getPage(name);
			if (overwrite || !page.exists()) {
				page.putBodyStream(fileIn);
				res.writer.write("ページ("+name+")を書き込みました。");
			} else {
				res.writer.write("ページ("+name+")が既に存在します。");
			}
		}
	} finally {
		fileIn.close();
	}
}

function backup(req, res, params) {
	var pageName  = params.pageName;
	var jarName = pageName.replace("/","_")+".jar";

	res.setContentType("application/java-archiver");
	res.setHeader("Content-Disposition", "attachment; filename="+jarName);

	var jarOut = new java.util.jar.JarOutputStream(res.getOutputStream());
	var page = __ENV__.getPage(pageName);
	if (page.isDirectory()) {
		backupDir(jarOut, pageName, page);
	} else {
		var pos = pageName.lastIndexOf("/");
		var baseName = pageName.substring(0, pos);
		backupFile(jarOut, baseName, page);
	}
	jarOut.close();
}
function backupDir(jarOut, baseName, page) {
	var pages = page.listPages();
	for (var i=0; i<pages.length; i++) {
		if (pages[i].isDirectory()) {
			backupDir(jarOut, baseName, pages[i]);
		} else {
			backupFile(jarOut, baseName, pages[i]);
		}
	}
}
function backupFile(jarOut, baseName, page) {
	var entName = page.pageName.substring(baseName.length());
	if (entName.startsWith("/")) entName = entName.substring(1);
	var entry = new java.util.zip.ZipEntry(entName);
	entry.setTime(page.lastModified());

	jarOut.putNextEntry(entry);
	page.writeBody(jarOut, false);
	jarOut.closeEntry();
}







