//-------------------------------------------------------------------------------
// Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
// Copyright (c) 2011- kotemaru@kotemaru.org
//-------------------------------------------------------------------------------

/*-----------------------------------------
             WSJS設定ファイル
-------------------------------------------*/

// ログレベルの設定
config.logLevel = log.INFO;
log.info("-- start config.js --");

var basedir = servletConfig.getServletContext().getRealPath("");
log.info("basedir="+basedir);

// TZ 設定
java.util.TimeZone.setDefault(new java.util.TimeZone("JST"));

// 初期データの入った jar ファイルを設定
config.documentRoot = basedir + "/WEB-INF/docroot.jar";
// システムのデフォルト文字コード
config.encoding = "UTF-8";

// メモリ上に持つページのキャッシュサイズ
config.limitTotalCacheSize = 30 * 1024 * 1024; // 30M
config.limitProcCacheSize = 500 * 1024; // 500k

// プロキシの設定：現在意味無し
config.proxyHost = "";
config.proxyPort = 0;

// indexファイルの設定
config.enableDirectoryList = true;
config.directoryIndex = ["index.html","index.wiki"];
// ブラウザキャッシュの有効期限
config.expires = 24*60*60;

// 各種プロセッサの設定
// - org.kotemaru.wsjs.Processor を実装すれば拡張可能
config.processors = [
	new Packages.org.kotemaru.wsjs.proc.RewriteProc("^/_ah/mail/.*$","/mail/receiver.ssjs"),
	new Packages.org.kotemaru.wsjs.proc.LocalDirProc(),
	new Packages.org.kotemaru.wsjs.proc.SsjsProc(),
	new Packages.org.kotemaru.wsjs.proc.RpjsProc(),
	new Packages.org.kotemaru.wsjs.proc.ExjsProc(),
	new Packages.org.kotemaru.wsjs.proc.JsProc(),
	new Packages.org.kotemaru.wsjs.proc.LinkProc(),
	new Packages.org.kotemaru.wsjs.proc.WikiProc(),
	new Packages.org.kotemaru.wsjs.proc.ClassProc(),
	new Packages.org.kotemaru.wsjs.proc.LocalFileProc()
];

// 拡張子とMIMEタイプのマッピング
config.extensions = {
	".pac": "application/x-ns-proxy-autoconfig",
	".xhtml": "application/xhtml+xml",
	".html": "text/html",
	".htm" : "text/html",
	".xml" : "text/xml",
	".js"  : "application/javascript",
	".gif" : "image/gif",
	".png" : "image/png",
	".jpg" : "image/jpeg",
	".css" : "text/css",
	".json": "application/json",
	".ico" : "image/x-icon",
	".jscp" : "text/plain",
	".jar" : "application/java-archiver",
};


// 読込パーミッション設定
// - ディレクトリ単位。
// - ディレクトリ名とロール名のリスト
// -- ロールの扱いは config.roleManager の設定による。
// - 先に一致した方が優先なので範囲が広い方を後に書く必要がある
config.permitRead = [
	["/admin/",                 "admin"],
	["/login/",                 "member","visitor"],
	["/",                       "member","visitor"]
];
// 書込パーミッション設定
config.permitWrite = [
	["/_wsjs_/",                "admin"],
	["/tmp/",                   "member","visitor"],
	["/",                       "admin"],
];

// GAEでは空で固定
config.permitClass = [];
config.permitJNDI = [];

// 固定：GAEのUserServiceでログインを行う
config.pam = config.newJavaInstance({
	"class": "org.kotemaru.auth.gae.PAMImpl",
});
// 固定：GAEのUserServiceでユーザ管理を行う
config.userManager = config.newJavaInstance({
	"class": "org.kotemaru.auth.gae.UserManagerImpl",
});
// 固定：GAEのUserServiceでロール管理を行う
// - admin  : GAEの管理ユーザ
// - member : 一般ユーザでログイン
// - visitor : ログインしていない
config.roleManager = config.newJavaInstance({
	"class": "org.kotemaru.auth.gae.RoleManagerImpl",
});


/*
 * 設定一覧出力
for (var name in config) {
	log.info(name +"="+config[name]);
}
*/
