/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs.ssjs;

import java.io.*;
import java.net.*;
import java.text.*;
import java.util.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;
import org.apache.commons.httpclient.methods.*;
import org.apache.commons.httpclient.*;
import org.mozilla.javascript.*;
import org.kotemaru.util.LOG ;
import org.kotemaru.wsjs.Config ;
import javax.servlet.http.HttpSession;

/**
TODO: 非同期、キャッシュ、クッキー
*/
public class XMLHttpRequest {
	private static final String HTTP_CLIENT = "httpClient";
	private static final String GET = "GET";
	private static final String POST = "POST";
	private static final String CONTENT_TYPE = "Content-type";

	private final SsjsEnv __ENV__;
	private HttpClient client;
	private HttpMethod method = null;
	private String overrideMimeType = null;

	private int status = 0;
	private String responseText = null;
	private Document responseXML = null;
	public String charset = null; //TODO:

	public XMLHttpRequest(SsjsEnv env) {
		__ENV__ = env;
		client = getHttpClient(env);
		String proxyHost = Config.getProxyHost();
		int proxyPort = Config.getProxyPort();
		if (proxyHost != null && proxyHost.length()>0 ) {
			client.getHostConfiguration().setProxy(proxyHost, proxyPort);
		}
	}
	private static HttpClient getHttpClient(SsjsEnv env) {
		HttpSession session = env.getRequest().getSession();
		HttpClient client = (HttpClient) session.getAttribute(HTTP_CLIENT);
		if (client == null) {
			client = new HttpClient();
			session.setAttribute(HTTP_CLIENT, client);
		}
		return client;
	}


	public void open(String type, String url) throws Exception {
		open(type, url, false);
	}
	public void open(String type, String url, boolean isAsync) throws Exception {
		if (isAsync) {
			throw new RuntimeException("Unsupported async XMLHttpRequest.");
		}
		if (GET.equalsIgnoreCase(type)) {
			method = new GetMethod(url);
		} else {
			method = new PostMethod(url);
			method.setRequestHeader(CONTENT_TYPE, "text/plain; charset=utf-8");
		}
		method.setRequestHeader("Connection","close");
	}
	public void close() throws Exception {
		if (method != null) method.releaseConnection();
	}

	public void overrideMimeType(String ctype) {
		overrideMimeType = ctype.trim().toLowerCase();
	}
	public void setRequestHeader(String name, String value) {
		method.setRequestHeader(name, value);
	}
	public String getResponseHeader(String name) {
		Header header = method.getResponseHeader(name);
		return getValue(header, null);
	}
	private String getContentType() {
		if (overrideMimeType != null) return overrideMimeType;
		String val = getResponseHeader(CONTENT_TYPE);
		if (val == null) return null;
		return val.trim().toLowerCase();
	}

	public void send(String body) throws Exception {
		__ENV__.LOG.info("XREQ.send|"+__ENV__.getUser()+"|"+__ENV__.getPage()+"|"+method.getName()+" "+method.getURI());
		if (__ENV__.getWsjsContext().getAppConfig() != null) {
			__ENV__.getWsjsContext().getAppConfig().addXreqCount();
		}
		try {
			_send(body);
		} finally {
			method.releaseConnection();
		}
	}
	private void _send(String body) throws Exception {

		if (POST.equals(method.getName())) {
			PostMethod pm = (PostMethod) method;
			Header header = pm.getRequestHeader(CONTENT_TYPE);
			String ctype = getValue(header, "plain/text");
			HeaderElement[] elems = header.getElements();
			String charset =
				getValue(elems[0].getParameterByName("charset"), "utf-8");

			RequestEntity entity =
					new StringRequestEntity(body, ctype, charset);
			pm.setRequestEntity(entity);
		}
		status = client.executeMethod(method);

		if (__ENV__.LOG.isDebugEnabled()) debugLog();

		String ctype = getContentType();
		if (charset != null) { // TODO:
			byte[] resbody = method.getResponseBody();
			responseText = new String(resbody, charset);
		} else if (ctype == null) {
			responseText = method.getResponseBodyAsString();
		} else if (ctype.startsWith("text/xml")
			|| ctype.startsWith("application/xhtml+xml")
			|| ctype.startsWith("application/rss+xml")) {
			DocumentBuilder builder =
				DocumentBuilderFactory.newInstance().newDocumentBuilder();
			responseXML = builder.parse(method.getResponseBodyAsStream());
		} else {
			responseText = method.getResponseBodyAsString();
		}
	}
	private String getValue(NameValuePair pair, String def) {
		if (pair == null) return def;
		return pair.getValue();
	}

	public int getStatus() {
		return status;
	}
	public String getResponseText() {
		return 	responseText;
	}
	public Document getResponseXML() throws Exception {
		return responseXML;
	}


	private void debugLog() throws Exception {
		String msg = "XREQ request detail.\n";
		msg += ">> "+method.getName()+" "+method.getURI()+"\n";
		Header[] reqhs = method.getRequestHeaders();
		for (int i=0; i<reqhs.length; i++) {
			msg += ">> "+reqhs[i];
		}

		msg += "\n<< "+method.getStatusLine()+"\n";
		Header[] reshs = method.getResponseHeaders();
		for (int i=0; i<reshs.length; i++) {
			msg += "<< "+reshs[i];
		}

		__ENV__.LOG.debug(msg);
	}

//---------------------------------------------------------------
// for ScriptableObject
/*
	public void jsConstructor() { }
	public String getClassName() {return "XMLHttpRequest";}
	public void jsFunction_open(String type, String url) {open(type,url);}
	public void jsFunction_send(String body) {open(body);}
	public void jsFunction_setRequestHeader(String name, String value) {
		setRequestHeader(name, value);
	}
	public String jsFunction_getResponseHeader(String name) {
		return getResponseHeader(name);
	}
	public int jsGet_status() {return getStatus();}
	public String jsGet_responseText() {return getResponseText();}
	public Document jsGet_responseXML() {return getResponseXML();}
*/
}



