/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs.ssjs;

import java.io.* ;
import java.net.* ;
import java.util.* ;
import org.mozilla.javascript.*;
import javax.servlet.*;
import javax.servlet.http.*;

import org.kotemaru.util.* ;
import org.kotemaru.wsjs.* ;

public class SsjsUtil  {
	public static Script compileResource(String resName) {
		return compileResource(SsjsUtil.class, resName);
	}
	public static Script compileResource(Class cls, String resName) {
		Context cx = Context.enter();
		try {
			String src = IOUtil.getResource(cls, resName);
			return cx.compileString(src, resName, 1, null);
		} catch (Exception e) {
			e.printStackTrace();
			throw new RuntimeException(e);
		} finally {
			Context.exit();
		}
	}

	public static Script compile(Page page) throws IOException  {
		String src = page.getBodyString();
		Context cx = Context.enter();
		try {
			Script script = cx.compileString(src, page.getPageName(), 1, null);
			return script;
		} finally {
			Context.exit();
		}
	}

}
