/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs.ssjs;

import java.io.* ;
import java.net.* ;
import java.util.* ;
import org.mozilla.javascript.*;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.naming.*;
import java.sql.*;
import javax.sql.*;

import org.kotemaru.util.* ;
import org.kotemaru.wsjs.* ;
import org.kotemaru.auth.* ;

import org.mozilla.javascript.Context;


/**
RPJS,SSJS の実行環境を表すクラス。
<li>RPJS,SSJS 上では大域変数 __ENV__ に設定される。
*/
public class SsjsEnv implements ClassShutter {
/*
	private static final String DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
	static {
		ContextFactory.initGlobal(new SsjsContextFactory());

		try {
			Class.forName(DRIVER);
		} catch (Throwable t) {
			new LOG().error("Derby not found: "+t);
			//throw new Error(e);
		}
	}
*/
	public static void init() {
	}

	public final Log LOG;

	private final WsjsContext wsjsContext;
	private final Context context;
	private final Scriptable scope;
	private final Page page;

	public SsjsEnv(WsjsContext ctx, Context cx, Scriptable scope, Page page) {
		this.wsjsContext = ctx;
		this.context = cx;
		this.scope = scope;
		this.page = page;

		this.LOG = ctx.getLog();
		AppConfig conf = ctx.getAppConfig();
		if (conf != null) {
			((SsjsContext)cx).setTimeout(
				System.currentTimeMillis()+conf.getTimeout()*1000);
		}
	}

	/**
	 * WSJSのコンテキストを取得。
	 */
	public WsjsContext getWsjsContext() {
		return wsjsContext;
	}
	/**
	 * Servletを取得。
	 */
	public Servlet getServlet() {
		return wsjsContext.getServlet();
	}
	/**
	 * HttpServletRequestを取得。
	 */
	public HttpServletRequest getRequest() {
		return wsjsContext.getRequest();
	}
	/**
	 * HttpServletResponseを取得。
	 */
	public HttpServletResponse getResponse() {
		return wsjsContext.getResponse();
	}
	/**
	 * ログイン中のユーザを取得。
	 */
	public User getUser() {
		return wsjsContext.getUser();
	}

	/**
	 * ログイン中のユーザを取得。
	 */
	public Context getContext() {
		return Context.getCurrentContext();
	}

	/**
	 * トップレベルスコープを取得。
	 */
	public Scriptable getScope() {
		return scope;
	}


	/**
	 * 実行中のページを取得。
	 */
	public Page getPage() {
		return page;
	}


	// for ClassShutter
	public boolean visibleToScripts(String className) {
		if (className.charAt(0) == '$') return true;
		if (className.indexOf('.') == -1) return false;
		if (Package.getPackage(className) != null) return false;

		User owner = null;
		if (wsjsContext.getAppConfig() != null) {
			owner = wsjsContext.getAppConfig().getOwner();
		}

		boolean b = Config.hasPermitClass(className, page, owner);
		if (b == false) {
			this.LOG.warn("JavaClass blocked "+className+":"+page+":"+wsjsContext.getUser());
			throw new ErrorPageException("classShutter", className, page, wsjsContext.getUser());
		}
		return b;
	}


	/**
	 * 他のページをインクルードする。
	 */
	public void include(String pageName, Scriptable scope)  throws Exception {
		pageName = getAbsPageName(pageName);
		Processor proc = wsjsContext.getProcessor(pageName);
		if (proc == null) {
			throw new ErrorPageException("notFoundPage", pageName);
		}
		Script script = proc.getScript(wsjsContext);
		if (script == null) {
			throw new ErrorPageException("notJavaScriptPage", pageName);
		}
		script.exec(getContext(), scope);
	}

	private String getAbsPageName(String name) {
		if (name.startsWith("/")) {
			return IOUtil.formalPageName(name);
		}
		String curPageName = page.getPageName();
		int pos = curPageName.lastIndexOf('/');
		name = curPageName.substring(0,pos+1)+name;
		return IOUtil.formalPageName(name);
	}

	/**
	 * 他のページを取得する。
	 */
	public Page getPage(String pageName) throws IOException {
		pageName = getAbsPageName(pageName);
		return wsjsContext.getPageAccessor(pageName);
	}


	/**
	 * デフォルトのDB接続を取得する。
	 */
/*--- for GAE
	public Connection getDBConnection() throws Exception {
		return getDBConnection(null);
	}
---*/
	/**
	 * DB接続を取得する。
	 */
/*--- for GAE
	public Connection getDBConnection(String dataSourceName) throws Exception {
		if (dataSourceName == null) {
			String url = "jdbc:derby:"+Config.getDatabaseRoot()+";create=true";
			return DriverManager.getConnection(url);	
		} else {
			if (!Config.hasPermitJNDI(dataSourceName,page,wsjsContext.getUser())) {
				this.LOG.error("DB connect blocked "+dataSourceName+" in "+page);
				throw new ErrorPageException("accessDeniedJNDI", page, dataSourceName);
			}
			InitialContext ic = new InitialContext();
			DataSource ds = (DataSource)ic.lookup(dataSourceName);
			return ds.getConnection();
		}
	}
---*/
	/**
	 * 現在時間を取得する。
	 */
	public long currentTimeMillis() {
		return System.currentTimeMillis();
	}
	/**
	 * スリープする。
	 */
	public void sleep(int ms) throws Exception {
		Thread.sleep(ms);
	}

	/**
	 * JSON文字列をJavaScriptオブジェクトに変換する。
	 * <li>eval()は禁止されているのでこちらを使用する。
	 */
	public Scriptable parseJson(String data) {
		JSONParser parser = new JSONParser(getContext(), getScope());
		return parser.parse(new StringReader(data));
	}

	/**
	 * JavaScriptオブジェクトをJSON文字列に変換する。
	 * <li>関数オブジェクトは引数に Writer を渡して呼び出されるのでそこに書き込む。
	 */
	public String serialJson(Scriptable obj) throws IOException {
		JSONSerializer serializer =
			new JSONSerializer(this, getContext(), getScope());
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		serializer.serialize(obj, out);
		return new String(out.toByteArray(),"UTF-8");
	}

	/**
	 * 実行環境にjavaクラスパスを追加する。
	 * <li>当該実行Contextのみに反映される。
	 * @param pageName jarファイル又はディレクトリのページ名
	 */
	public void addClassPath(String pageName) throws Exception {
		pageName = getAbsPageName(pageName);
		ClassLoader parent = context.getApplicationClassLoader();

		ClassLoader loader = 
			new RepositoryClassLoader(wsjsContext, pageName, parent);
		context.setApplicationClassLoader(loader);

		// NOTE: Rhino-1.7 の実装に依存。
		// これをしないと setApplicationClassLoader() が反映されない。
		NativeJavaTopPackage.init(context, scope, false);
	}

//-----------------------------------------------------------------------------
// Deleted.
	/** @deprecated @see Page APIに移行*/
	public boolean hasPermitRead(String pageName) throws IOException {
		return Config.hasPermitRead(pageName, wsjsContext.getUser());
	}
	/** @deprecated @see Page APIに移行 */
	public boolean hasPermitWrite(String pageName) throws IOException {
		return Config.hasPermitWrite(pageName, wsjsContext.getUser());
	}

	/** @deprecated @see Page APIに移行 */
	public void checkPermitRead(String pageName) throws IOException {
		if (hasPermitRead(pageName)) return;
		throw new AccessDeniedException(wsjsContext, wsjsContext.getUser(), pageName);
	}
	/** @deprecated @see Page APIに移行 */
	public void checkPermitWrite(String pageName) throws IOException {
		if (hasPermitWrite(pageName)) return;
		throw new AccessDeniedException(wsjsContext, wsjsContext.getUser(), pageName);
	}

	/** @deprecated @see Page APIに移行 */
	public String getTextContent(String pageName) throws IOException {
		return getTextContent(pageName, null);
	}
	/** @deprecated @see Page APIに移行 */
	public String getTextContent(String pageName, String charset) throws IOException {
		//checkPermitRead(pageName);
		if (charset == null) charset = Config.getEncoding();
		return getPage(pageName).getBodyString(charset);
	}
	/** @deprecated */
	public void putTextContent(String pageName, String data) throws IOException {
		putTextContent(pageName, data, null);
	}
	/** @deprecated @see Page APIに移行 */
	public void putTextContent(String pageName, String data, String charset) throws IOException {
		checkPermitWrite(pageName);
		if (charset == null) charset = Config.getEncoding();
		getPage(pageName).putBodyString(data, charset);
	}

	/** @deprecated @see Page APIに移行  */
	public byte[] getBinaryContent(String pageName) throws IOException {
		//checkPermitRead(pageName);
		return getPage(pageName).getBodyBytes();
	}
	/** @deprecated @see Page APIに移行 */
	public void putBinaryContent(String pageName, byte[] data) throws IOException {
		checkPermitWrite(pageName);
		getPage(pageName).putBodyBytes(data);
	}


}
