/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs.ssjs;

import org.mozilla.javascript.*;

public class SsjsContextFactory extends ContextFactory {
	private static final int LIMIT_TIME = 300*1000; //300sec

	protected Context makeContext(){
		SsjsContext cx = new SsjsContext();
		cx.setInstructionObserverThreshold(LIMIT_TIME/10);
		return cx;
	}
		
	protected Object doTopCall(Callable callable, Context cx,
				Scriptable scope, Scriptable thisObj, Object[] args){
		long curTime = System.currentTimeMillis();
		((SsjsContext)cx).setTimeout(curTime + LIMIT_TIME);
		return super.doTopCall(callable, cx, scope, thisObj, args);
	}

	protected void observeInstructionCount(Context cx, int instructionCount){
		((SsjsContext)cx).checkTimeout();
	}
		
}
