/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs.proc;

import java.io.* ;

import java.net.* ;
import java.util.* ;
import java.text.* ;
import javax.servlet.*;
import javax.servlet.http.*;
import org.mozilla.javascript.*;

import org.kotemaru.auth.* ;
import org.kotemaru.util.* ;
import org.kotemaru.util.gae.GaeIOUtil;
import org.kotemaru.wsjs.* ;
import org.kotemaru.wsjs.ssjs.* ;

public class WikiProc extends LocalFileProc {
	private static final String EXT_WIKI = ".wiki";
	private static final byte[] HEADER;
	private static final byte[] FOOTER;

	static {
		try {
			HEADER = GaeIOUtil.getResourceWithCache(WikiProc.class, "wiki-header.html").getBytes("utf-8");
			FOOTER = GaeIOUtil.getResourceWithCache(WikiProc.class, "wiki-footer.html").getBytes("utf-8");
			//HEADER = IOUtil.getResource(WikiProc.class, "wiki-header.html").getBytes("utf-8");
			//FOOTER = IOUtil.getResource(WikiProc.class, "wiki-footer.html").getBytes("utf-8");
		} catch (Exception e) {
			throw new Error(e);
		}
	}

	public WikiProc() {
		super();
	}

	private WikiProc(Page page) throws IOException {
		super(page);
	}
	public Processor getInstance(WsjsContext ctx, Page page) throws IOException  {
		if (!page.hasExt(EXT_WIKI)) return null;
		if (!page.exists()) return null;
		return new WikiProc(page);
	}

	public void processing(WsjsContext ctx) throws IOException {
		super.access();
		if (ProcUtil.check304(ctx, page.lastModified(), cacheCtrl)) return;

		HttpServletResponse res = ctx.getResponse();
		res.setContentType("text/html");
		
		byte[] buff = getCacheBuffer(ctx);
		if (buff != null) {
			res.setContentLength(HEADER.length+buff.length+FOOTER.length);
		} else {
			res.setContentLength(HEADER.length+(int)page.length()+FOOTER.length);
		}
		
		OutputStream out = res.getOutputStream();
		out.write(HEADER);

		if (buff != null) {
			out.write(buff);
		} else {
			page.writeBody(out, false);
		}

		out.write(FOOTER);
	}


}
