/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs.proc;

import java.io.* ;
import java.net.* ;
import java.util.* ;
import java.text.* ;
import javax.servlet.*;
import javax.servlet.http.*;
import org.mozilla.javascript.*;

import org.kotemaru.auth.* ;
import org.kotemaru.util.* ;
import org.kotemaru.wsjs.* ;
import org.kotemaru.wsjs.ssjs.* ;

//import org.kotemaru.wsjs.gae.lowapi.RhinoEntity ;

public class SsjsProc extends ProcessorBase {
	private static final String EXT_SSJS = ".ssjs";

	private static Script bootScript =
		SsjsUtil.compileResource(SsjsProc.class, "ssjs-boot.js");

	transient private long lastUpdateTime = -1;
	transient private Script script = null;

	public SsjsProc() {
		super();
	}

	private SsjsProc(Page page) throws IOException {
		super(page);
		update();
	}
	public Processor getInstance(WsjsContext ctx, Page page) throws IOException  {
		if (!page.hasExt(EXT_SSJS)) return null;
		if (!page.exists()) return null;
		return new SsjsProc(page);
	}
	public void dispose() {
		lastUpdateTime = -1;
		script = null;
		super.dispose();
	}

	public void processing(WsjsContext ctx) throws IOException {
		super.access();

		HttpServletRequest req = ctx.getRequest();
		HttpServletResponse res = ctx.getResponse();
		Context cx = Context.enter();
		try {
			Scriptable scope = cx.initStandardObjects();
			SsjsEnv env =  new SsjsEnv(ctx, cx, scope, getPage(ctx));
			cx.setClassShutter(env);
			scope.put("__ENV__", scope, env);
			//ScriptableObject.defineClass(scope, RhinoEntity.class);

			Function func =	(Function) bootScript.exec(cx, scope);
			getScript(ctx).exec(cx, scope);

			func.call(cx, scope, func, new Object[]{req, res});
		} catch (RuntimeException e) {
			e.printStackTrace();
			throw e;
		//} catch (Exception e) {
		//	e.printStackTrace();
		//	throw new RuntimeException(e);
		} finally {
			Context.exit();
		}
	}

	public synchronized Script getScript(WsjsContext ctx) throws IOException {
		update();
		return script;
	}
	public double getCacheScore() {
		return super.getCacheScore() * 1.5;
	}

	public boolean update()  throws IOException {
		if (page.lastModified() > lastUpdateTime) {
			lastUpdateTime = page.lastModified();
			script = SsjsUtil.compile(page);
			super.accessReset((int)page.length());
			return true;
		} else {
			return false;
		}
	}
}
