/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs.proc;

import java.io.* ;
import java.net.* ;
import java.util.* ;
import java.text.* ;
import javax.servlet.*;
import javax.servlet.http.*;
import org.mozilla.javascript.*;

import org.kotemaru.auth.* ;
import org.kotemaru.util.* ;
import org.kotemaru.wsjs.* ;
import org.kotemaru.wsjs.ssjs.* ;

//import org.kotemaru.wsjs.gae.lowapi.RhinoEntity ;

public class RpjsProc extends ProcessorBase {
	private static final String EXT_RPJS = ".rpjs";
	private static final String CT_JAVASCRIPT = "application/javascript; charset=utf-8";
	private static final String CT_JSON = "application/json; charset=utf-8";

	private static Script bootScript =
		SsjsUtil.compileResource(RpjsProc.class, "rpjs-boot.js");
	private static Script stubScript =
		SsjsUtil.compileResource(RpjsProc.class, "rpjs-stub.js");

	private final String contextPath;
	private final String cacheCtrl;
	transient private long lastUpdateTime = -1;
	transient private byte[] bufferStub = null;
	transient private Script script = null;

	public RpjsProc() {
		super();
		contextPath = null;
		cacheCtrl = null;
	}

	private RpjsProc(Page page, String cpath) throws IOException {
		super(page);
		this.contextPath = cpath;
		String pageName = page.getPageName();
		cacheCtrl = Config.hasPermitRead(pageName, PAMFactory.getVisitUser())
				? "public" : "private";
		update();
	}
	public Processor getInstance(WsjsContext ctx, Page page) throws IOException  {
		if (!page.hasExt(EXT_RPJS)) return null;
		if (!page.exists()) return null;

		return new RpjsProc(page, ctx.getRequest().getContextPath());
	}
	public void dispose() {
		lastUpdateTime = -1;
		bufferStub = null;
		script = null;
		super.dispose();
	}

	public void processing(WsjsContext ctx) throws IOException {
		super.access();
		HttpServletRequest req = ctx.getRequest();
		HttpServletResponse res = ctx.getResponse();

		if ("GET".equals(req.getMethod())) {
			byte[] buff = getCacheBuffer(ctx);
			if (ProcUtil.check304(ctx, lastUpdateTime, cacheCtrl)) return;
			res.setContentType(CT_JAVASCRIPT);
			res.setContentLength(buff.length);
			res.getOutputStream().write(buff);
			return;
		}

		Context cx = Context.enter();
		try {

			Scriptable scope = cx.initStandardObjects();
			SsjsEnv env =  new SsjsEnv(ctx, cx, scope, getPage(ctx));
			cx.setClassShutter(env);
			scope.put("__ENV__", scope, env);
			//ScriptableObject.defineClass(scope, RhinoEntity.class);


			JSONParser parser = new JSONParser(cx, scope);
			Object reqInfo = parser.parse(req.getReader());

			Function func =	(Function) bootScript.exec(cx, scope);
			getScript(ctx).exec(cx, scope);
			Object rv = func.call(cx, scope, func, new Object[]{req, res, scope, reqInfo});

			res.setContentType(CT_JSON);
			JSONSerializer serilizer = new JSONSerializer(env, cx, scope);
			serilizer.serialize((Scriptable) rv, res.getOutputStream());
		} catch (RuntimeException e) {
			e.printStackTrace();
			throw e;
		//} catch (Exception e) {
		//	e.printStackTrace();
		//	throw new RuntimeException(e);
		} finally {
			Context.exit();
		}
	}

	public synchronized byte[] getCacheBuffer(WsjsContext ctx) throws IOException {
		update();
		return bufferStub;
	}
	public synchronized Script getScript(WsjsContext ctx) throws IOException {
		update();
		return script;
	}
	public double getCacheScore() {
		return super.getCacheScore() * 2.0;
	}

	public boolean update() throws IOException {
		if (page.lastModified() > lastUpdateTime) {
			lastUpdateTime = page.lastModified();
			script = SsjsUtil.compile(page);
			bufferStub = makeStub(page.getPageName(), script).getBytes("UTF-8");//TODO:UTF-8
			super.accessReset(bufferStub.length+(int)page.length());
			return true;
		} else {
			return false;
		}
	}


	private String makeStub(String pageName, Script script) throws IOException {
		Context cx = Context.enter();
		try {
			Scriptable scope = cx.initStandardObjects();
			Function func =	(Function) RpjsProc.stubScript.exec(cx, scope);
			script.exec(cx, scope);

			String url = contextPath + pageName;

			Object stub = func.call(cx, scope, func, new Object[]{url, scope});
			return (String) cx.jsToJava(stub, String.class);
		} finally {
			Context.exit();
		}
		
	}
}
