/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs.proc;

import java.io.* ;
import java.net.* ;
import java.util.* ;
import java.text.* ;
import javax.servlet.*;
import javax.servlet.http.*;
import org.mozilla.javascript.*;
import java.util.regex.*;

import org.kotemaru.auth.* ;
import org.kotemaru.util.* ;
import org.kotemaru.wsjs.* ;

public class RewriteProc extends ProcessorBase {
	private Pattern pattern;
	private String destPageName;
	private Processor destProc;

	public RewriteProc(String patt, String dest) {
		super();
		this.pattern = Pattern.compile(patt);
		this.destPageName = dest;
	}
	private RewriteProc(Processor proc) {
		destProc = proc;
	}

	public Processor getInstance(WsjsContext ctx, Page page) throws IOException  {
		Matcher matcher = pattern.matcher(page.getPageName());
		if (!matcher.matches()) return null;
		Processor proc = ctx.getProcessor(destPageName);
		return new RewriteProc(proc);
	}
	public boolean isCachable() {
		return false;
	}

	public void dispose() {
	}

	public void processing(WsjsContext ctx) throws IOException, javax.servlet.ServletException {
		destProc.processing(ctx);
	}
}
