/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs.proc;

import java.io.* ;
import java.net.* ;
import java.util.* ;
import java.text.* ;
import javax.servlet.*;
import javax.servlet.http.*;
import org.mozilla.javascript.*;

import org.kotemaru.auth.* ;
import org.kotemaru.util.* ;
import org.kotemaru.wsjs.* ;

public class ProcUtil {
	public static final String DATE_FMT = "EEE, dd MMM yyyy HH:mm:ss zzz";
	public static final int MAX_CACHE_SIZE = 4096; // TODO:Config
	public static final String HH_IF_MOD = "if-modified-since";
	public static final String HH_LAST_MOD = "last-modified";
	public static final String HH_EXPIRES = "Expires";
	public static final String HH_CACHE_CTRL = "Cache-Control";
	public static final String HH_PRAGMA = "Pragma";
	public static final String HV_NO_CACHE = "no-cache";

	public static boolean check304(WsjsContext ctx, long time, String cacheCtrl)
				throws IOException {
		DateFormat fmt = new SimpleDateFormat(DATE_FMT, Locale.US);
		fmt.setTimeZone(TimeZone.getTimeZone("GMT")); 

		boolean is304 = false;

		String ifMod = ctx.getRequest().getHeader(HH_IF_MOD);
		if (ifMod != null) {
			try {
				Date date = fmt.parse(ifMod);
				is304 = (time/1000) <= (date.getTime()/1000);
			} catch (ParseException e) {
				// ignore.
			}
		}

		HttpServletResponse res = ctx.getResponse();

		long expires = System.currentTimeMillis()+Config.getExpires()*1000;
		AppConfig conf = ctx.getAppConfig();
		if (conf != null && !conf.isClientCache()) {
			cacheCtrl = HV_NO_CACHE;
		}

		res.setHeader(HH_PRAGMA, null);
		res.setHeader(HH_EXPIRES, null);

		if (is304) {
			res.setStatus(304);
			res.setHeader(HH_CACHE_CTRL, cacheCtrl+",max-age="+Config.getExpires());
			res.setHeader(HH_LAST_MOD, fmt.format(new Date(time)));
			//res.setHeader(HH_EXPIRES, fmt.format(new Date(expires)));
		} else {
			res.setHeader(HH_CACHE_CTRL, cacheCtrl+",max-age="+Config.getExpires());
			res.setHeader(HH_LAST_MOD, fmt.format(new Date(time)));
			//res.setHeader(HH_EXPIRES, fmt.format(new Date(expires)));
		}
		return is304;
	}

}
