/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs.proc;

import java.io.* ;
import java.net.* ;
import java.util.* ;
import java.text.* ;
import javax.servlet.*;
import javax.servlet.http.*;
import org.mozilla.javascript.*;

import org.kotemaru.auth.* ;
import org.kotemaru.util.* ;
import org.kotemaru.wsjs.* ;

public class LocalFileProc extends ProcessorBase {
	final static String DATE_FMT = "EEE, dd MMM yyyy HH:mm:ss zzz";

	private final String contentType;
	protected final String cacheCtrl;
	protected long lastUpdateTime = -1;
	private byte[] buffer = null;

	public LocalFileProc() {
		super();
		contentType = null;
		cacheCtrl = null;
	}

	protected LocalFileProc(Page page) throws IOException {
		super(page);
		String pageName = page.getPageName();
		contentType = Config.getContentType(IOUtil.getExt(pageName));
		cacheCtrl = Config.hasPermitRead(pageName, PAMFactory.getVisitUser())
				? "public" : "private";
		update();
	}
	public Processor getInstance(WsjsContext ctx, Page page) throws IOException  {
		if (!page.exists()) return null;
		return new LocalFileProc(page);
	}
	public void dispose() {
		lastUpdateTime = -1;
		buffer = null;
		super.dispose();
	}

	public void processing(WsjsContext ctx) throws IOException {
		super.access();
		if (ProcUtil.check304(ctx, page.lastModified(), cacheCtrl)) return;

		HttpServletResponse res = ctx.getResponse();
		res.setContentType(contentType);

		byte[] buff = getCacheBuffer(ctx);
		if (buff != null) {
			res.setContentLength(buff.length);
			res.getOutputStream().write(buff);
		} else {
			res.setContentLength((int)page.length());
			OutputStream out = res.getOutputStream();
			page.writeBody(out);
		}
	}

	public synchronized byte[] getCacheBuffer(WsjsContext ctx) throws IOException  {
		update();
		return buffer;
	}

	public boolean update() throws IOException {
		if (page.lastModified() > lastUpdateTime) {
			if (page.length() < Config.getLimitProcCacheSize()) {
				lastUpdateTime = page.lastModified();
				buffer = page.getBodyBytes();
				super.accessReset(buffer.length);
			} else {
				buffer = null;
				super.accessReset(0);
			}
			return true;
		} else {
			return false;
		}
	}

}
