/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs.proc;

import java.io.* ;
import java.net.* ;
import java.util.* ;
import java.text.* ;
import javax.servlet.*;
import javax.servlet.http.*;
import org.mozilla.javascript.*;

import org.kotemaru.auth.* ;
import org.kotemaru.util.* ;
import org.kotemaru.wsjs.* ;

public class LocalDirProc  extends ProcessorBase {

	public LocalDirProc() {
		super();
	}

	public LocalDirProc(Page page) {
		super(page);
	}
	public Processor getInstance(WsjsContext ctx, Page page) throws IOException {
		if (!page.isDirectory()) return null;

		String pageName = page.getPageName();
		//if (!page.hasExt("/")) {
		//	String loc = ctx.getRequest().getContextPath()+pageName+"/";
		//	return new LinkProc(page, 301, loc);
		//}

		String dir = pageName.equals("/") ? pageName : pageName+"/";
		String[] indexPageNames = Config.getDirectoryIndex();
		for (int i=0; i<indexPageNames.length; i++) {
			String indexPageName = dir+indexPageNames[i];
			if (pageName.equals("/")) pageName = "";

			Processor proc = ctx.getProcessor(indexPageName);
			if (proc != null) {
				String loc = ctx.getRequest().getContextPath()+indexPageName;
				return new LinkProc(page, 301, loc);
			}
		}

		return new LocalDirProc(page);
	}
	public void dispose() {
	}

	public void processing(WsjsContext ctx) throws IOException {
		if (!Config.getEnableDirectoryList()) return;

		HttpServletResponse res = ctx.getResponse();

		Page[] list = page.listPages();
		Arrays.sort(list);

		res.setContentType("text/html");
		Writer writer = res.getWriter();
		writer.write("<h2>List of "+page.getPageName()+"</h2>");
		for (int i=0; i<list.length; i++) {
			Page page = list[i];
			String name = page.getLastName();
			if (page.isDirectory()) name += "/";
			writer.write("<div><a href='"+name+"'>"+name+"</a></div>");
		}
	}
	public boolean isCachable() {
		return false;
	}

}
