/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs.proc;

import java.io.* ;
import java.net.* ;
import java.util.* ;
import java.text.* ;
import javax.servlet.*;
import javax.servlet.http.*;
import org.mozilla.javascript.*;

import org.kotemaru.auth.* ;
import org.kotemaru.util.* ;
import org.kotemaru.wsjs.* ;

public class LinkProc extends ProcessorBase {
	public static final String EXT_LINK = ".link";

	private CacheData cacheData = new CacheData();

	public LinkProc() {
		super();	
	}

	public LinkProc(Page page, int stat, String loc) throws IOException {
		super(page);	
		cacheData = new CacheData();
		cacheData.lastUpdateTime = Long.MAX_VALUE;
		cacheData.statusCode = stat;
		cacheData.location = loc;
		cacheData.withUserName = (loc.indexOf("${user}") >= 0);
	}

	private LinkProc(Page page) throws IOException {
		super(page);
		update();
	}
	public Processor getInstance(WsjsContext ctx, Page page) throws IOException  {
		if (!page.hasExt(EXT_LINK)) return null;
		if (!page.exists()) return null;
		return new LinkProc(page);
	}

	public void dispose() {
		//cacheData.lastUpdateTime = -1;
		//cacheData.location = null;
		//super.dispose();
		// nop.
	}

	public void processing(WsjsContext ctx) throws IOException {
		super.access();
		HttpServletResponse res = ctx.getResponse();

		CacheData data = update();

		res.setStatus(data.statusCode);
		String loc = data.location;
		if (data.withUserName) {
			User user = ctx.getUser();
			if (user.isVisitor()) {
				throw new AccessDeniedException(ctx, user, page);
			}
			loc = loc.replaceAll("[$][{]user[}]", user.getName());
		}
		res.addHeader("location", loc);
		res.addHeader("Pragma","no-cache");
		res.addHeader("Cache-Control","no-cache, no-store, must-revalidate");
		res.addHeader("Expires", "-1");
	}

	public synchronized CacheData update() throws IOException  {
		if (page != null 
				&& page.lastModified() > cacheData.lastUpdateTime) {
			cacheData = new CacheData(page);
			super.accessReset(cacheData.location.length()+20);
		}
		return cacheData;
	}

	private class CacheData implements Serializable {
		long lastUpdateTime = -1;
		int statusCode = 307;
		String location = null;
		boolean withUserName = false;

		public CacheData() {}
		public CacheData(Page page) throws IOException {
			lastUpdateTime = page.lastModified();
			location = page.getBodyString();

			if (location.startsWith("3")) {
				statusCode = Integer.parseInt(location.substring(0,3));
				location = location.substring(4);
			} else {
				statusCode = 307;
			}
			withUserName = (location.indexOf("${user}") >= 0);
		}
	}

}
