/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs.proc;

import java.io.* ;
import java.net.* ;
import java.util.* ;
import java.text.* ;
import javax.servlet.*;
import javax.servlet.http.*;
import org.mozilla.javascript.*;

import org.kotemaru.auth.* ;
import org.kotemaru.util.* ;
import org.kotemaru.wsjs.* ;
import org.kotemaru.wsjs.ssjs.* ;

public class JsProc extends LocalFileProc {
	private static final String EXT_JS = ".js";

	private Script script = null;

	public JsProc() {
		super();
	}

	private JsProc(Page page) throws IOException {
		super(page);
	}
	public Processor getInstance(WsjsContext ctx, Page page) throws IOException  {
		if (!page.hasExt(EXT_JS)) return null;
		if (!page.exists()) return null;
		return new JsProc(page);
	}

	public synchronized Script getScript(WsjsContext ctx) throws IOException {
		if (script == null || page.lastModified() > lastUpdateTime) {
			script = SsjsUtil.compile(page);
		}
		return script;
	}


}
