/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs.proc;

import java.io.* ;
import java.net.* ;
import java.util.* ;
import javax.servlet.*;
import javax.servlet.http.*;
import org.mozilla.javascript.*;
import org.kotemaru.wsjs.* ;

public class DefaultProc extends ProcessorBase {
	public static final DefaultProc INSTANCE = new DefaultProc();
	public static final String HH_CACHE_CTRL = "Cache-Control";

	public Processor getInstance(WsjsContext ctx, Page page) throws IOException {
		return INSTANCE;
	}
	public void processing(WsjsContext ctx) throws IOException {
		HttpServletResponse res = ctx.getResponse();
		res.setStatus(404);
		res.setContentType("text/plain");
		res.setHeader(HH_CACHE_CTRL, "public,max-age="+Config.getExpires());
		res.getWriter().write("404 NotFound");
	}
	public boolean isCachable() {
		return false;
	}

}
