/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs.proc;

import java.io.* ;
import java.net.* ;
import java.util.* ;
import java.text.* ;
import javax.servlet.*;
import javax.servlet.http.*;
import org.mozilla.javascript.*;

import org.kotemaru.auth.* ;
import org.kotemaru.util.* ;
import org.kotemaru.wsjs.* ;

public class ClassProc extends LocalFileProc {
	private static final String EXT_CLASS = ".class";

	private Class cacheClass = null;

	public ClassProc() {
		super();
	}

	protected ClassProc(Page page) throws IOException {
		super(page);
	}
	public Processor getInstance(WsjsContext ctx, Page page) throws IOException  {
		if (!page.hasExt(EXT_CLASS)) return null;
		if (!page.exists()) return null;
		return new ClassProc(page);
	}

	public void processing(WsjsContext ctx) throws IOException {
		super.processing(ctx);
	}

	public synchronized Class getCacheClass() {
		return cacheClass;
	}
	public synchronized void setCacheClass(Class cls) {
		cacheClass = cls;
	}
	public boolean update() throws IOException {
		if (super.update()) {
			setCacheClass(null);
			return true;
		} else {
			return false;
		}
	}

}
