/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs.gae.lowapi;

import java.io.* ;
import java.net.* ;
import java.util.* ;
import javax.servlet.*;
import javax.servlet.http.*;
import org.kotemaru.util.* ;
import org.kotemaru.auth.* ;
import org.kotemaru.wsjs.* ;
import java.util.jar.* ;


import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.*;

import java.util.logging.*;

/**
 */
public class PersistentImpl  {
	public static final DatastoreServiceFactory DSF = new DatastoreServiceFactory();
	public static final String KIND = "_Persistent";
	public static final String BODY = "body";

	/**
	 * コンストラクタ。
	 */
	public PersistentImpl() {
	}

	public static Object getObject(String pkey)  throws Exception {
		byte[] data = getBlob(pkey);
		if (data == null) return null;
		ByteArrayInputStream bin = new ByteArrayInputStream(data);
		ObjectInputStream in = new ObjectInputStream(bin);
		Object obj = in.readObject();
		in.close();
		return obj;
	}

	public static void setObject(String pkey, Object obj) throws Exception {
		ByteArrayOutputStream bout = new ByteArrayOutputStream();
		ObjectOutputStream out = new ObjectOutputStream(bout);
		out.writeObject(obj);
		out.flush();
		setBlob(pkey, bout.toByteArray());
		out.close();
	}

	public static byte[] getBlob(String pkey) {
		DatastoreService ds = DSF.getDatastoreService();
		Entity entity = getEntity(ds, pkey, true);
		if (entity == null) return null;
		Blob blob = (Blob) entity.getProperty(BODY);
		if (blob == null) return null;
		return blob.getBytes();
	}

	public static void setBlob(String pkey, byte[] data) {
System.out.println("----->"+data.length);
		DatastoreService ds = DSF.getDatastoreService();
		Transaction tx = ds.beginTransaction();
		Entity entity = newEntity(pkey);
		entity.setProperty(BODY, null);
		entity.setProperty(BODY, new Blob(data));
		ds.put(entity);
		tx.commit();
	}

	public static Entity getEntity(DatastoreService ds, String pkey, boolean withBody) {
		Query query = new Query(KIND);
		Key key = KeyFactory.createKey(KIND, pkey);
		query.addFilter(Entity.KEY_RESERVED_PROPERTY, 
								Query.FilterOperator.EQUAL , key);
		PreparedQuery pq = ds.prepare(query);
		Entity entity = pq.asSingleEntity();
		if (entity == null) return null;
		if (withBody) ((Blob)entity.getProperty(BODY)).getBytes();
		return entity;
	}

	public static Entity newEntity(String pkey) {
		Entity entity = new Entity(KIND, pkey);
		return entity;
	}

	public static void putEntity(Entity entity) {
		DatastoreService ds = DSF.getDatastoreService();
		ds.put(entity);
	}

	public static boolean delEntity(Entity entity) {
		DatastoreService ds = DSF.getDatastoreService();
		try {
			ds.delete(entity.getKey());
			return true;
		} catch (IllegalArgumentException e) {
			LOG.warn(e.toString());
			return false;
		}
	}
}
