/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs.gae.lowapi;
import com.google.appengine.api.datastore.*;
import org.mozilla.javascript.*;
import java.util.*;

public class EntityWrapper extends ScriptableObject {
	private static final String PKEY = "pkey";
	private Entity entity;
	private Scriptable entityScriptable;

	public static void defineClass(Scriptable scope)
			throws java.lang.IllegalAccessException,
					java.lang.InstantiationException,
					java.lang.reflect.InvocationTargetException
	{
		defineClass(scope, EntityWrapper.class);
	}

	public EntityWrapper(){}

	public String getClassName() {
		return "EntityWrapper";
	}

	public void jsConstructor(Scriptable scr) {
		this.entityScriptable = scr;
		this.entity = (Entity) ((Wrapper)scr).unwrap();
	}
	public Scriptable jsFunction_getEntity() { return entityScriptable; }

	public Object[] getIds() {
		Set keySet = entity.getProperties().keySet();
		List list = new ArrayList(keySet.size()+1);
		list.addAll(keySet);
		list.add(PKEY);
		return list.toArray();
	}

	public Object get(String name, Scriptable start) {
		if (entity == null) return super.get(name, start);
		if (PKEY.equals(name)) {
			Key key = entity.getKey();
			if (key.getName() != null) return key.getName();
			return new Long(key.getId());
		}
		if (entity.hasProperty(name)) {
			return entity.getProperty(name);
		}
		return super.get(name, start);
	}

	public boolean has(String name, Scriptable start) {
		if (entity == null) return super.has(name, start);
		if (entity.hasProperty(name)) return true;
		return super.has(name, start);
	}

	public void put(String name, Scriptable start, Object value) {
		if (value instanceof org.mozilla.javascript.Callable) {
			super.put(name, start, value);
		} else {
			entity.setProperty(name, getJavaObject(value));
		}
	}

	private static Object getJavaObject(Object obj) {

		if (obj instanceof Scriptable) {
			if (obj instanceof org.mozilla.javascript.NativeJavaObject) {
				return ((Wrapper)obj).unwrap();
			} else {
				throw new RuntimeException("Unsuppoted type "
					+obj.getClass().getName()+":"+((Scriptable)obj).getClassName());
			}
		} else { 
			return obj;
		}
	}


}
