/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs.gae.lowapi;

import java.io.* ;
import java.net.* ;
import java.util.* ;
import javax.servlet.*;
import javax.servlet.http.*;
import org.kotemaru.util.* ;
import org.kotemaru.auth.* ;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.*;


public class BodyOutputStream extends ByteArrayOutputStream implements Const {
	private final Entity entity;
	private final boolean isAppend;

	public BodyOutputStream(Entity entity, boolean isAppend) {
		this.entity = entity;
		this.isAppend = isAppend;
if (isAppend) {
throw new Error("Not implements.");
}
	}

	public void close() throws IOException {
		super.close();
		Blob blob = new Blob(toByteArray());

		entity.setProperty(LENGTH, blob.getBytes().length);
 		entity.setProperty(LAST_MODIFIED, System.currentTimeMillis());
  		entity.setProperty(BODY, blob);

		RepositoryImpl.putEntity(entity);
	}
}
