/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs.gae;

import java.io.*;
import java.net.*;
import javax.servlet.*;
import javax.servlet.http.*;
//import org.mortbay.servlet.ProxyServlet;
import org.kotemaru.util.*;
import org.kotemaru.auth.*;
import org.kotemaru.wsjs.ssjs.*;
import org.kotemaru.wsjs.proc.*;
//import org.kotemaru.wsjs.gae.RepositoryJDOImpl;
import org.kotemaru.wsjs.gae.lowapi.RepositoryImpl;
import org.mozilla.javascript.*;
import org.kotemaru.util.gae.*;

public class WsjsGaeFilter implements Filter {
	private static final String ORIGIN = "org.kotemaru.wsjs.WsjsFilter";
	private Filter origin;

	public void init(FilterConfig config) throws ServletException {
		try {
			System.out.println("Initialize WsjsGaeFilter.");
			CacheClassLoader ccl = new CacheClassLoader(this.getClass().getClassLoader());
			origin = (Filter) Class.forName(ORIGIN, true, ccl).newInstance();
			origin.init(config);
		} catch (Exception e) {
			throw new ServletException(e);
		}
	}
	public void destroy() {
		// nop.
	}

	public void doFilter(ServletRequest _req, ServletResponse _res,
              FilterChain chain)
              throws java.io.IOException, ServletException
	{
		origin.doFilter(_req, _res, chain);
	}

}
