/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs.gae;

import javax.servlet.http.*;
import javax.servlet.ServletContext;
import java.util.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author tmjee
 * @version $Date$ $Id$
 */
public class HttpSessionImpl implements HttpSession {

    private static final Log LOG = LogFactory.getLog(HttpSessionImpl.class);

    private String sessionId;
    private Map<String, Object> attributes;
    private HttpServlet servlet;

    public HttpSessionImpl(String jsessionId, HttpServlet servlet) {
        this.sessionId = jsessionId;
        this.servlet = servlet;
        attributes = new HashMap<String, Object>();
    }

    public HttpSessionImpl(HttpServlet servlet) {
        this(UUID.randomUUID().toString().replaceAll("-", ""), servlet);      
    }


    public String getId() {
        return sessionId;
    }

    public long getCreationTime() {
	throw new UnsupportedOperationException();
    }


    public long getLastAccessedTime() {
	throw new UnsupportedOperationException();
    }

    public ServletContext getServletContext() {
        return servlet.getServletContext();
    }

    public void setMaxInactiveInterval(int i) {
 	throw new UnsupportedOperationException();
    }

    public int getMaxInactiveInterval() {
 	throw new UnsupportedOperationException();
    }

    public HttpSessionContext getSessionContext() {
        throw new UnsupportedOperationException("As of Java Servlet API 2.1 with no replacement");
    }

    public Object getAttribute(String name) {
        return attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(attributes.keySet());
    }

    public String[] getValueNames() {
        return attributes.keySet().toArray(new String[0]);
    }

    public void setAttribute(String name, Object value) {
        attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        attributes.remove(name);
    }

    public Object getValue(String name) {
        return getAttribute(name);
    }
    public void putValue(String name, Object value) {
        setAttribute(name, value);
    }
    public void removeValue(String name) {
        removeAttribute(name);
    }

    public synchronized void invalidate() {
    }

    public boolean isNew() {
 	throw new UnsupportedOperationException();
    }

}

