/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs.gae;

import javax.servlet.http.*;
import javax.servlet.ServletContext;
import java.util.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import com.google.appengine.api.datastore.*;

/**
 * @author tmjee
 * @version $Date$ $Id$
 */
public class HttpReqWrapper extends HttpServletRequestWrapper {
    private static final Log LOG = LogFactory.getLog(HttpReqWrapper.class);
	private HttpServlet servlet;
	private HttpServletRequest origin;
	private HttpSession currentSession;

    public HttpReqWrapper(HttpServlet servlet, HttpServletRequest request) {
		super(request);
		this.origin = request;
    }

	public HttpSession getSession() {
		return getSession(true);
	}
	public HttpSession getSession(boolean create) {
		if (currentSession != null) return currentSession;

		String sid = getRequestedSessionId();
		currentSession = manager_getSession(sid);
		if (currentSession != null) return currentSession;
		if (!create) return null;

		currentSession = manager_newSession();
		return currentSession;
	}

	// TODO: Bigtable.
	private static final Map<String,HttpSession> sessionMap =
		new HashMap<String,HttpSession>();
	public static final DatastoreServiceFactory DSF = new DatastoreServiceFactory();
	public static final String KIND = "_Session";
	public static final String EXPIRE = "_expire";
	public static final String ATTRS = "_attributes";

	private HttpSession manager_getSession(String sid) {
		synchronized (sessionMap) {
			return sessionMap.get(sid);
		}
	}
	private HttpSession manager_newSession() {
		HttpSession session = new HttpSessionImpl(servlet);
		synchronized (sessionMap) {
			sessionMap.put(session.getId(), session);
		}
		return session;
	}

}

