/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs;

import java.io.*;
import java.net.*;
import javax.servlet.*;
import javax.servlet.http.*;
//import org.mortbay.servlet.ProxyServlet;
import org.kotemaru.util.*;
import org.kotemaru.auth.*;
import org.kotemaru.wsjs.ssjs.*;
import org.kotemaru.wsjs.proc.*;
//import org.kotemaru.wsjs.gae.RepositoryJDOImpl;
import org.kotemaru.wsjs.gae.lowapi.RepositoryImpl;
import org.mozilla.javascript.*;
import org.kotemaru.util.gae.*;

public class WsjsServlet extends HttpServlet implements WsjsServletIF {
	public static final String QUERY_ENCODING = "org.mortbay.jetty.Request.queryEncoding";
	public static final String USER_NAME = "USER_NAME";
	private File realPath;
	private Repository systemRepository;
	private Repository repository;

	public void init(ServletConfig config) throws ServletException {
		try {
			System.out.println("Initialize WsjsServlet.");
			String path = config.getServletContext().getRealPath("");
			realPath = new File(path);
			localInit(config);

			PAMFactory.init(Config.getPam(),
				Config.getRoleManager(), Config.getUserManager());
			SsjsEnv.init();
			LOG.info("Start WsjsServlet.");
		} catch (Exception e) {
			e.printStackTrace();
			throw new ServletException(e);
		}
	}

	public void localInit(ServletConfig servletConfig) throws Exception {
		if (servletConfig == null) servletConfig = getServletConfig();

		String configText = ConfigServlet.getConfigText(realPath);
		//Config.init(this, servletConfig, new File(realPath, "/WEB-INF/config.js"));
		Config.init(this, servletConfig, configText);

		systemRepository = new RepositoryFileImpl(new File(realPath, ""));
		if (Config.getIsGAE()) {
//			repository = new RepositoryJDOImpl(Config.getDocumentRoot());
			repository = new RepositoryImpl(Config.getDocumentRoot());
		} else {
			repository = new RepositoryFileImpl(Config.getDocumentRoot());
			//CPUMonitor.startMonitor();
		}
	}

	public Repository getRepository() {
		return repository;
	}
	public Repository getSystemRepository() {
		return systemRepository;
	}

	public void service(HttpServletRequest request, HttpServletResponse response) 
			throws ServletException, IOException 
	{
		long t1 = System.currentTimeMillis();
		WsjsContext ctx = null;
		Log log = WsjsContext.DEFAULT_LOG;
		try {
			initEncoding(request, response);
//if (Config.getIsGAE()) { // TODO:
//request = new org.kotemaru.wsjs.gae.HttpReqWrapper(this, request);
//}
			ctx = new WsjsContext(this, request, response);
			log = ctx.getLog();
			Processor proc = ctx.getProcessor();
			if (proc == null) proc = DefaultProc.INSTANCE;
			proc.processing(ctx);

			setUserNameCookie(ctx);
		} catch (AccessDeniedException e) {
			if (e.getUser().isVisitor()) {
				String reqUrl = HttpUtils.getRequestURL(request).toString();
				String loc = e.getUser().getPAM().getLoginURL(
						request, reqUrl, Config.getEncoding());
				response.sendRedirect(loc);
			} else {
				e.doForward(request,response);
			}
			return;
		} catch (UnregisterUserException e) {
			String reqUrl = HttpUtils.getRequestURL(request).toString();
			String loc = PAMFactory.getUserManager().getRegisterURL(
										request, "/", Config.getEncoding());
			response.sendRedirect(loc);
			return;
		} catch (Throwable t) {
			log.error(t);
			ErrorPageException epe = convertException(t, false);
			log.error(epe);
			epe.doForward(request,response);
		} finally {
			if (LOG.isDebugEnabled()) {
				long t2 = System.currentTimeMillis();
				User user = null;
				if (ctx != null) user = ctx.getUser();
				log.debug(user+":"+request.getPathInfo()+" "+(t2-t1)+"ms");
			}
		}
	}

	private ErrorPageException convertException(Throwable t, boolean isJS) {
		if (t instanceof ErrorPageException) {
			return (ErrorPageException)t;
		} else if (t instanceof JavaScriptException) {
			Object eval = ((JavaScriptException)t).getValue();
			if (eval instanceof org.mozilla.javascript.NativeJavaObject) {
				eval = (((Wrapper)eval).unwrap());
			}
			if (eval instanceof ErrorPageException) {
				return (ErrorPageException) eval;
			} else if (!(eval instanceof Throwable)) {
				return new ErrorPageException(500,
						"JavaScriptException", t.toString(), t);
			}
			return convertException((Throwable) eval, true);

		} else if (t instanceof WrappedException) {
			Throwable we = ((WrappedException)t).getWrappedException();
			if (we instanceof ErrorPageException) {
				return (ErrorPageException) we;
			}
			return convertException(we, true);

		} else if (isJS) {
			return new ErrorPageException(500,
						"JavaScriptException", t.getMessage(), t);
		} else {
			return new ErrorPageException(500, t);
		}
	}


	private void setUserNameCookie(WsjsContext ctx) throws Exception {
		User user = ctx.getUser();
		Cookie userCookie = new Cookie(USER_NAME,
					NetUtil.encodeURI(user.getName()));
		userCookie.setPath("/");
		if (user == null || user.isVisitor()) userCookie.setMaxAge(-1); 
		ctx.getResponse().addCookie(userCookie);
	}
	private void initEncoding(HttpServletRequest request,
				 HttpServletResponse response) throws Exception {
		// Corrent default charset for jetty
		request.setAttribute(QUERY_ENCODING, Config.getEncoding());

		if (request.getCharacterEncoding() == null) {
			request.setCharacterEncoding(Config.getEncoding());
		}
		response.setCharacterEncoding(Config.getEncoding());
	}


	private void writeObject(ObjectOutputStream stream) throws IOException {
		// nop.
	}

	private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
		// nop.
	}
}
