/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs;
import org.kotemaru.auth.*;
import javax.servlet.http.*;
import java.io.UnsupportedEncodingException;

/**
 * 未登録ユーザで発生する例外。
 */
public class UnregisterUserException extends ErrorPageException {
	private final User user;
	private final String pageName;

	/**
	 * コンストラクタ。<ul>
	 * <li>ユーザはリクエストから自動的に取得する。
	 * </ul>
	 * @param ctx         WSJSコンテキスト
	 * @param user        アクセスしようとしたユーザ
	 * @param pageName    ページ名
	 */
	public UnregisterUserException(WsjsContext ctx, User user, String pageName) {
		super(403, "unregisterUser", user, getUrl(ctx, user, pageName));
		this.user = user;
		this.pageName = pageName;
	}
	public UnregisterUserException(WsjsContext ctx, User user, Page page) {
		this(ctx, user, page.getPageName());
	}

	private static String getUrl(WsjsContext ctx, User user, String pageName) {
		HttpServletRequest req = ctx.getRequest();
		String retUrl = req.getContextPath() + pageName;
		return PAMFactory.getUserManager().getRegisterURL(req, retUrl, Config.getEncoding());
	}


	/**
	 * ユーザを返す。
	 * @return ユーザ
	 */
	public User getUser(){
		return user;
	}
	/**
	 * ページを返す。
	 * @return ページ名
	 */
	public String getPageName(){
		return pageName;
	}

}




