/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs;

import java.io.* ;
import java.net.* ;
import java.util.* ;
import javax.servlet.*;
import javax.servlet.http.*;
import org.kotemaru.util.* ;
import org.kotemaru.auth.* ;
import java.util.jar.* ;
import org.kotemaru.wsjs.proc.ClassProc ;

/**
 * リポジトリからクラスをロードする。
 * <li>ディレクトリパスとJarの両方に対応。
 */
public class RepositoryClassLoader extends ClassLoader {
	private WsjsContext context;
	private Page basePage;

	public RepositoryClassLoader(WsjsContext ctx, String pageName, 
				ClassLoader parent) throws IOException {
		super(parent);
		this.context = ctx;
		this.basePage = ctx.getPage(pageName);
//System.out.println("------->RepositoryClassLoader:"+pageName);
	}

	public Class findClass(String name) throws ClassNotFoundException {
//System.out.println("------->"+name);
		if (basePage.isDirectory()) {
			return findClassForPage(name);
		} else {
			return findClassForJarFile(name);
		}
	}

	private Class findClassForPage(String name) throws ClassNotFoundException {
		try {
			String path = basePage.getPageName()+"/"
								+name.replace('.','/')+".class";
			Processor proc = context.getProcessor(path);
			if (proc == null || !(proc instanceof ClassProc)) {
				throw new ClassNotFoundException("Not found "+name+" in "+basePage.getPageName());
			}

			ClassProc cproc = (ClassProc) proc;
			Class cls = cproc.getCacheClass();
//System.out.println("--->"+cls);
			if (cls != null) return cls;

			byte[] data = cproc.getCacheBuffer(context);
			cls = defineClass(name, data, 0, data.length);
			cproc.setCacheClass(cls);
			return cls;
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}
	private Class findClassForJarFile(String name) throws ClassNotFoundException  {
		try {
			String path = name.replace('.','/')+".class";
			InputStream in = getJarStream(path);
			if (in == null) {
				throw new ClassNotFoundException("Not found "+name+" in "+basePage.getPageName());
			}
			byte[] data = IOUtil.streamToBytes(in);
			return defineClass(name, data, 0, data.length);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	public InputStream getResourceAsStream(String name) {
		try {
			if (basePage.isDirectory()) {
				Page page = context.getPage(basePage.getPageName()+"/"+name);
				if (!page.exists()) return null;
				byte[] data = page.getBodyBytes();
				return new ByteArrayInputStream(data);
			} else {
				return getJarStream(name);
			}
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	private InputStream getJarStream(String path) {
		try {
			ByteArrayInputStream bin = new ByteArrayInputStream(basePage.getBodyBytes());
			JarInputStream jarIn = new JarInputStream(bin);
			JarEntry file = jarIn.getNextJarEntry();
			while (file != null) {
				if (path.equals(file.getName())) return jarIn;
				file = jarIn.getNextJarEntry();
			}
			return null;
		} catch (IOException e) {
			throw new RuntimeException(e);
		//} finally {
		//	if (bin != null) bin.close();
		}
	}
}
