/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs;

import java.io.* ;
import java.net.* ;
import java.util.* ;
import javax.servlet.*;
import javax.servlet.http.*;
import org.kotemaru.util.* ;
import org.kotemaru.auth.* ;

/**
 * ページのリポジトリ管理クラス。
 * <ul>
 * <li>ページをOSのファイルシステムにマップする。
 * <li>ルートとなるディレクトリを持つ。
 * <li>ページのエントリをキャッシュとして持つ。
 * <li>キャッシュの全体サイズを管理する。
 * <li>
 * </ul>
 */
public interface Repository {
	public Processor getProcessor(WsjsContext ctx, String pageName, boolean isCheck) throws IOException;
	public void addTotalCacheSize(int oldSize, int newSize);

	/** @return null は返さない。*/
	public Page getPage(WsjsContext ctx, String pageName) throws IOException;
}
