/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs;

import java.io.* ;
import java.net.* ;
import java.util.* ;
import javax.servlet.*;
import javax.servlet.http.*;
import org.kotemaru.util.* ;
import org.kotemaru.auth.* ;

/**
 * ファイルを実体して持つページ。
 */
public class PageFileImpl implements Page {
	private final String pageName;
	private final File file;
	private Set permitWriteRoles = null;

	public PageFileImpl(String pageName, File file) {
		this.pageName = pageName;
		this.file = file;
	}

	public String getPageName() {
		return pageName;
	}
	public String getLastName() {
		return file.getName();
	}
	public boolean isDirectory() {
		return file.isDirectory();
	}
	public long lastModified() {
		return file.lastModified();
	}
	public long length() {
		return file.length();
	}
	public boolean exists() {
		return file.exists();
	}
	public Page[] listPages() {
		File[] files = file.listFiles();
		Page[] pages = new Page[files.length];
		for (int i=0; i<files.length; i++) {
			String pname = pageName+'/'+files[i].getName();
			pages[i] = new PageFileImpl(pname, files[i]);
		}
		return pages;
	}

	public boolean hasExt(String ext) {
		return pageName.endsWith(ext);
	}
	public String getBodyString() throws IOException {
		return getBodyString(Config.getEncoding());
	}
	public String getBodyString(String charset) throws IOException {
		return IOUtil.getFile(file, charset);
	}
	public byte[] getBodyBytes() throws IOException {
		return IOUtil.getFileBytes(file);
	}
	public void writeBody(OutputStream out) throws IOException {
		writeBody(out, true);
	}
	public void writeBody(OutputStream out, boolean isClose) throws IOException {
		//RandomAccessFile raf = new RandomAccessFile(file, "r");
		//IOUtil.transrate(raf, out, true, isClose);
		FileInputStream in = new FileInputStream(file);
		IOUtil.transrate(in, out, true, isClose);
	}

	public void putBodyString(String data) throws IOException {
		putBodyString(data, Config.getEncoding());
	}
	public void putBodyString(String data, String charset) throws IOException {
		//for GAE
		//IOUtil.putFile(file, data, charset);
		throw new Error("Local file write");
	}
	public void putBodyBytes(byte[] data) throws IOException {
		//for GAE
		throw new Error("Local file write");
/*
		FileOutputStream out = new FileOutputStream(file);
		try {
			out.write(data);
		} finally {
			out.close();
		}
*/
	}
	public void putBodyStream(InputStream in) throws IOException {
		//for GAE
		throw new Error("Local file write");
/*
		FileOutputStream out = new FileOutputStream(file);
		IOUtil.transrate(in, out, false, true);
*/
	}
	public OutputStream getBodyOutputStream(boolean isAppend) throws IOException {
		//for GAE
		throw new Error("Local file write");
		//return new FileOutputStream(file, isAppend);
	}

	public boolean mkdir() throws IOException {
		return file.mkdirs();
	}

	public boolean remove() throws IOException {
		return file.delete();
	}

	public Set<String> getPermitWriteRoles() {
		if (permitWriteRoles == null) {
			permitWriteRoles =Config.getPermitWriteRoles(this);
		}
		return permitWriteRoles;
	}

	public int compareTo(Object obj) {
		return file.compareTo(((PageFileImpl)obj).file);
	}

	public String toString() {
		return getPageName();
	}

}
