/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs;

import java.io.* ;
import java.net.* ;
import java.util.* ;
import javax.servlet.*;
import javax.servlet.http.*;
import org.kotemaru.util.* ;
import org.kotemaru.auth.* ;

/**
 * 
 */
public class PageDelegate implements Page {
	protected final Page origin;

	public PageDelegate(Page page) {
		origin = page;
	}

	public String getPageName() {
		return origin.getPageName();
	}
	public String getLastName() {
		return origin.getLastName();
	}
	public boolean isDirectory() {
		return origin.isDirectory();
	}
	public long lastModified() {
		return origin.lastModified();
	}
	public long length() {
		return origin.length();
	}
	public boolean exists() {
		return origin.exists();
	}
	public Page[] listPages() {
		return origin.listPages();
	}

	public boolean hasExt(String ext) {
		return origin.hasExt(ext);
	}
	public String getBodyString() throws IOException {
		return origin.getBodyString();
	}
	public String getBodyString(String charset) throws IOException {
		return origin.getBodyString(charset);
	}
	public byte[] getBodyBytes() throws IOException {
		return origin.getBodyBytes();
	}
	public void writeBody(OutputStream out) throws IOException {
		origin.writeBody(out);
	}
	public void writeBody(OutputStream out, boolean isClose) throws IOException {
		origin.writeBody(out, isClose);
	}

	public void putBodyString(String data) throws IOException {
		origin.putBodyString(data);
	}
	public void putBodyString(String data, String charset) throws IOException {
		origin.putBodyString(data, charset);
	}
	public void putBodyBytes(byte[] data) throws IOException {
		origin.putBodyBytes(data);
	}
	public void putBodyStream(InputStream in) throws IOException {
		origin.putBodyStream(in);
	}
	public OutputStream getBodyOutputStream(boolean isAppend) throws IOException {
		return origin.getBodyOutputStream(isAppend);
	}

	public boolean mkdir() throws IOException {
		return origin.mkdir();
	}

	public boolean remove() throws IOException {
		return origin.remove();
	}

	public Set<String> getPermitWriteRoles() {
		return origin.getPermitWriteRoles();
	}

	public int compareTo(Object obj) {
		return origin.compareTo(obj);
	}

	public String toString() {
		return origin.toString();
	}

}
