/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs;

import java.io.* ;
import java.net.* ;
import java.util.* ;
import javax.servlet.*;
import javax.servlet.http.*;
import org.kotemaru.util.* ;
import org.kotemaru.auth.* ;

/**
 * 
 */
public class PageAccessor extends PageDelegate {
	private final WsjsContext wsjsContext;
	private final boolean isReadable;
	private final boolean isWritable;

	public PageAccessor(WsjsContext ctx, Page page) {
		super(page);
		wsjsContext = ctx;
		String pageName = page.getPageName();
		User user = ctx.getUser();
		isReadable = Config.hasPermitRead(pageName, user);
		isWritable = Config.hasPermitWrite(pageName, user);
	}

	private void checkPermitRead() {
		if (isReadable) return;
		throw new AccessDeniedException(wsjsContext,
						wsjsContext.getUser(), origin.getPageName());
	}
	private void checkPermitWrite() {
		if (isWritable) return;
		throw new AccessDeniedException(wsjsContext,
						wsjsContext.getUser(), origin.getPageName());
	}
	
	public String getBodyString() throws IOException {
		checkPermitRead();
		return super.getBodyString();
	}
	public String getBodyString(String charset) throws IOException {
		checkPermitRead();
		return super.getBodyString(charset);
	}
	public byte[] getBodyBytes() throws IOException {
		checkPermitRead();
		return super.getBodyBytes();
	}
	public void writeBody(OutputStream out) throws IOException {
		checkPermitRead();
		super.writeBody(out);
	}

	public void putBodyString(String data) throws IOException {
		checkPermitWrite();
		super.putBodyString(data);
	}
	public void putBodyString(String data, String charset) throws IOException {
		checkPermitWrite();
		super.putBodyString(data, charset);
	}
	public void putBodyBytes(byte[] data) throws IOException {
		checkPermitWrite();
		super.putBodyBytes(data);
	}
	public void putBodyStream(InputStream in) throws IOException {
		checkPermitWrite();
		super.putBodyStream(in);
	}
	public OutputStream getBodyOutputStream(boolean isAppend) throws IOException {
		checkPermitWrite();
		return super.getBodyOutputStream(isAppend);
	}

	public boolean mkdir() throws IOException {
		String pageName = origin.getPageName();
		User user = wsjsContext.getUser();
		boolean isWritable = Config.hasPermitWrite(pageName+"/", user);
		if (!isWritable) {
			throw new AccessDeniedException(wsjsContext,
						wsjsContext.getUser(), origin.getPageName());
		}
		return super.mkdir();
	}

	public boolean remove() throws IOException {
		checkPermitWrite();
		return super.remove();
	}
}
