/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs;

import java.io.* ;
import java.net.* ;
import java.util.* ;
import javax.servlet.*;
import javax.servlet.http.*;
import org.kotemaru.util.* ;
import org.kotemaru.auth.* ;

/**
 * ページを表すインターフェース。
 * <li>機能は java.io.File にほぼ同じ。
 * <li>getBodyXxx() メソッドはキャッシュしない。
 */
public interface Page extends Comparable, Serializable {
	/** ページ名を得る */
	public String getPageName();
	/** ページ名の最後の部分を得る */
	public String getLastName();
	/** ページの最終更新時間を得る。 */
	public long lastModified();
	/** ページの長さを得る。 */
	public long length();
	/** 配下のページを返す。ディレクトリの場合のみ有効。 */
	public Page[] listPages();

	/** ディレクトリならば true を返す */
	public boolean isDirectory();
	/** ページの実体が存在すれば true を返す。 */
	public boolean exists();
	/** 指定された拡張子を持っていれば true を返す */
	public boolean hasExt(String ext);

	/** ページの内容を文字列で得る。 */
	public String getBodyString() throws IOException;
	/** ページの内容を文字種を指定して文字列で得る。 */
	public String getBodyString(String charset) throws IOException;
	/** ページの内容をバイト列で得る。 */
	public byte[] getBodyBytes() throws IOException;
	/** ページの内容をストリームに書き出す。 */
	public void writeBody(OutputStream out) throws IOException;
	/** ページの内容をストリームに書き出しストリームを閉じる。 */
	public void writeBody(OutputStream out, boolean isClose) throws IOException;

	/** ページの内容を文字列で設定する。 */
	public void putBodyString(String data) throws IOException;
	/** ページの内容を文字種を指定して文字列で設定する。 */
	public void putBodyString(String data, String charset) throws IOException;
	/** ページの内容をバイト列で設定する。 */
	public void putBodyBytes(byte[] data) throws IOException;
	/** ページの内容をストリームから読み込んで設定する。 */
	public void putBodyStream(InputStream in) throws IOException;

	/**
	 * ページに書き込むストリームを得る。
	 * @param isAppend 追加書き込みフラグ
	 * @return ページに書き込むストリーム
	 */
	public OutputStream getBodyOutputStream(boolean isAppend) throws IOException;

	/**
	 * ディレクトリページを作成する。
	 */
	public boolean mkdir() throws IOException;

	/**
	 * ページを削除する。
	 */
	public boolean remove() throws IOException;

	/**
	 * ページを削除する。
	 */
	public Set<String> getPermitWriteRoles();
}
