/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs;

import java.io.* ;
import java.net.* ;
import java.util.* ;
import java.lang.reflect.* ;
import javax.servlet.*;
import javax.servlet.http.*;

import org.mozilla.javascript.*;
import org.kotemaru.util.* ;
import org.kotemaru.auth.* ;

import javax.cache.*;
import javax.cache.CacheException;
import javax.cache.CacheFactory;
import com.google.appengine.api.memcache.*;

public class Config extends ConfigBean {

	private static final String NS_MEMCACHE = Config.class.getName();
	public static MemcacheService memcache =
		MemcacheServiceFactory.getMemcacheService(NS_MEMCACHE); 

	private PermitUtil.Matcher[] permitReadMatchers = null;
	private PermitUtil.Matcher[] permitWriteMatchers = null;
	private PermitUtil.Matcher[] permitClassMatchers = null;
	private PermitUtil.Matcher[] permitJNDIMatchers = null;
	private Map<String,String> extContentTypeMap = null;
	private Map<String,String> pamInfo = null;

	public Config() {
	}
	public Config(Scriptable scope) {
		super(scope);
	}

	//public static void init(WsjsServlet servlet, ServletConfig servletConfig, File file) throws Exception {
	//public static void init(WsjsServlet servlet, ServletConfig servletConfig, String src) throws Exception {
	public static void init(Object servlet, Object servletConfig, String src) throws Exception {


//		Object obj = org.kotemaru.wsjs.gae.lowapi.PersistentImpl.getObject("Config");
		INSTANCE = loadConfig();
		if (INSTANCE != null) {
			System.out.println("Config hot boot. "+INSTANCE);
			return;
		}



		Context cx = Context.enter();
		try {
			Scriptable scope = cx.initStandardObjects();
			//ScriptableObject.defineClass(scope, Config.class);
 			//Scriptable config = cx.newObject(scope, "Config");
			Config config = new Config(scope);
			Config.INSTANCE = config;
			scope.put("config", scope, config);

			scope.put("servlet", scope, servlet);
			scope.put("log", scope, new LOG());
			scope.put("servletConfig", scope, servletConfig);
			//Script script = getConfigScript(cx, file);
			Script script = cx.compileString(src, "config.js", 1, null);
			script.exec(cx, scope);

			String saveConfig = null;
			try {
				String fname = Config.getSaveConfigFile();
				if (fname != null) {
				    saveConfig = IOUtil.getFile(fname);
				}
			} catch (Exception e) {
				LOG.warn("Can not load saveConfigFile: "+e);
			}
			if (saveConfig != null) {
				cx.evaluateString(scope, saveConfig, Config.getSaveConfigFile(), 1, null);
			}
		} finally {
			Context.exit();
		}

		INSTANCE.permitReadMatchers = PermitUtil.toDirMatchers(getPermitRead());
		INSTANCE.permitWriteMatchers = PermitUtil.toDirMatchers(getPermitWrite());
		INSTANCE.permitClassMatchers = PermitUtil.toClassMatchers(getPermitClass());
		INSTANCE.permitJNDIMatchers = PermitUtil.toJNDIMatchers(getPermitJNDI());

//		org.kotemaru.wsjs.gae.lowapi.PersistentImpl.setObject("Config", INSTANCE);
		saveConfig(INSTANCE);
	}
	private static Script getConfigScript(Context cx, File file) throws Exception {
		//Object obj = org.kotemaru.wsjs.gae.lowapi.PersistentImpl.getObject("config.js");
		//if (obj != null) {
		//	return (Script) obj;
		//}
		String src = IOUtil.getFile(file);              
		Script script = cx.compileString(src, file.toString(), 1, null);
		//org.kotemaru.wsjs.gae.lowapi.PersistentImpl.setObject("config.js", script);
		return script;
	}

	private static void saveConfig(Config config) throws CacheException,IOException {
		byte[] data = IOUtil.serialize(config);
		memcache.put("config", data);
	}

	private static Config loadConfig() throws CacheException,IOException  {
try {
		byte[] data = (byte[]) memcache.get("config");
		if (data == null) return null;
		return (Config)IOUtil.deserialize(data);
} catch (Throwable e) {
		e.printStackTrace();
		return null;
}
	}


    public void setExtensions(Scriptable pExtensions) {
        extContentTypeMap = toMap(pExtensions);
    }
    public Scriptable getExtensions() {
        return toScriptable(extContentTypeMap, __scope);
    }
    public void setLogLevel(int pLogLevel) {
		super.setLogLeval(pLogLevel);
		LOG.level = pLogLevel;
    }
    public int getLogLevel() {
        return LOG.level;
    }

	public static Processor getProcessor(WsjsContext ctx, Page page)  throws IOException {
		if (page == null) {
			return null;
		}
		Processor[] processors = getProcessors();
		for (int i=0; i<processors.length; i++) {
			if (processors[i].isEnable()) {
				Processor proc = processors[i].getInstance(ctx, page);
				if (proc != null) return proc;
			}
		}
		return null;
	}

	public static String getContentType(String ext) {
		return INSTANCE.extContentTypeMap.get(ext);
	}

	public static boolean hasPermitRead(String pageName, User user) {
		return PermitUtil.hasPermit(INSTANCE.permitReadMatchers, getPermitRead(),
										pageName, user);
	}
	public static boolean hasPermitWrite(String pageName, User user) {
		return PermitUtil.hasPermit(INSTANCE.permitWriteMatchers, getPermitWrite(),
										pageName, user);
	}
	public static boolean hasPermitClass(String className, Page page, User user) {
		if (INSTANCE.permitClassMatchers == null || INSTANCE.permitClassMatchers.length ==0) {
			return true;
		}
		return PermitUtil.hasPermitClass(INSTANCE.permitClassMatchers, getPermitClass(),
				INSTANCE.permitWriteMatchers,	getPermitWrite(),
				className, page, user);
	}
	public static boolean hasPermitJNDI(String jndiName, Page page, User user) {
		return PermitUtil.hasPermitJNDI(INSTANCE.permitJNDIMatchers, getPermitClass(),
				INSTANCE.permitWriteMatchers,	getPermitWrite(),
				jndiName, page, user);
	}
	public static Set<String> getPermitWriteRoles(Page page) {
		return PermitUtil.getPermitRoles(
			INSTANCE.permitWriteMatchers, getPermitWrite(), page.getPageName());
	}


	private static HashMap toMap(Scriptable var) {
		HashMap map = new HashMap();
		Object[] ids = var.getIds();
		for (int i=0; i<ids.length; i++) {
			String name = (String) ids[i];
			map.put(name, var.get(name, var));
		}
		return map;
	}

	private Scriptable toScriptable(Map map, Scriptable scope) {
		Context cx = Context.getCurrentContext();
		Scriptable var = cx.newObject(scope);
		Iterator<Map.Entry<String,Object>> ite = map.entrySet().iterator();
		while(ite.hasNext()){
			Map.Entry<String,Object> ent = ite.next();
			String name = ent.getKey();
			var.put(name, var, ent.getValue());
		}
		return var;
	}

	private static final String CLASS = "class";
	private static final Class[] TYPES = {Map.class};
	public Object newJavaInstance(Scriptable params) throws Exception {
		HashMap map = toMap(params);
		Class cls = Class.forName((String)map.get(CLASS));
		Constructor cons = cls.getConstructor(TYPES);
		return cons.newInstance(new Object[]{map});
	}


}
