/*******************************************************************************
 * Apache License, Version 2.0 (http://www.apache.org/licenses/LICENSE-2.0)
 * Copyright (c) 2011- kotemaru@kotemaru.org
 ******************************************************************************/
package org.kotemaru.wsjs;

import java.io.* ;
import java.net.* ;
import java.util.* ;
import java.text.* ;
import org.kotemaru.util.LOG;

public class AppLog extends Log {
	private static final int LIMIT_LOG_SIZE = 512*1024; // 0.5M
	private static final String LIMIT_MSG = "\n\n----- LOG SIZE OVER -----\n";
	private final Page logPage;

	public AppLog(Page page) {
		this.logPage = page;
	}
	public boolean isDebugEnabled() {
		return true;
	}

	public  void println(String level, String msg) {
		try {
			if (logPage.length()>LIMIT_LOG_SIZE) return;
			OutputStream out = logPage.getBodyOutputStream(true);
			try {
				LOG.println(out, level, msg);
				out.flush();
				if (logPage.length()>LIMIT_LOG_SIZE) {
					out.write(LIMIT_MSG.getBytes("UTF-8"));
				}
			} finally {
				out.close();
			}
		} catch (Throwable t) {
			LOG.error(t);
		}
	}

	public  void error(Throwable t) {
		if (!isErrorEnabled()) return;
		LOG.error(t);
		try {
			if (logPage.length()>LIMIT_LOG_SIZE) return;
			PrintStream out = new PrintStream(logPage.getBodyOutputStream(true));
			try {
				LOG.println(out, "ERROR ", t.getMessage());		
				t.printStackTrace(out);
				out.flush();
				if (logPage.length()>LIMIT_LOG_SIZE) {
					out.write(LIMIT_MSG.getBytes("UTF-8"));
				}
			} finally {
				out.close();
			}
		} catch (Throwable tt) {
			LOG.error(tt);
		}
	}
	public void error(String msg) {
		if (!isErrorEnabled()) return;
		LOG.error(msg);
		println("ERROR ", msg);		
	}
	public void access(String msg) {
		if (!isAccessEnabled()) return;
		LOG.access(msg);
		println("ACCESS", msg);		
	}
	public void warn(String msg) {
		if (!isWarnEnabled()) return;
		LOG.warn(msg);
		println("WARN  ", msg);		
	}
	public void info(String msg) {
		if (!isInfoEnabled()) return;
		LOG.info(msg);
		println("INFO  ", msg);		
	}
	public void debug(String msg) {
		if (!isDebugEnabled()) return;
		LOG.debug(msg);
		println("DEBUG ", msg);		
	}

}
